/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.export.common.diagonal;

import com.kingdee.bos.qing.export.common.diagonal.DiagonalInfo;
import com.kingdee.bos.qing.export.common.diagonal.DiagonalRender;
import com.kingdee.bos.qing.export.common.model.ExFont;
import com.kingdee.bos.qing.export.common.model.IExportAdapter;
import com.kingdee.bos.qing.util.LogUtil;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.List;
import javax.imageio.ImageIO;

public class DiagonalUtil {
    public static byte[] getCrossHeader(float scaling, IExportAdapter tvAdapter) {
        DiagonalInfo info = DiagonalUtil.getCrossHeaderInfo(scaling, tvAdapter);
        if (info == null) {
            return null;
        }
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        BufferedImage image = new BufferedImage((int)info.getWidth(), (int)info.getHeight(), 2);
        Graphics g = image.getGraphics();
        ExFont exFont = info.getFont();
        Font font = exFont.toAwtFont();
        g.setFont(font.deriveFont((float)font.getSize() * scaling));
        DiagonalUtil.draw(g, scaling, tvAdapter);
        try {
            ImageIO.write((RenderedImage)image, "png", bytes);
        }
        catch (IOException e) {
            LogUtil.error((String)"getCrossHeader() occurs an Exception!", (Throwable)e);
        }
        return bytes.toByteArray();
    }

    public static void draw(Graphics g, float scaling, IExportAdapter tvAdapter) {
        DiagonalInfo info = DiagonalUtil.getCrossHeaderInfo(scaling, tvAdapter);
        if (info == null) {
            return;
        }
        DiagonalRender render = new DiagonalRender();
        render.setLineWidth(render.getLineWidth() * scaling);
        Rectangle cellShape = new Rectangle((int)info.getWidth(), (int)info.getHeight());
        render.draw(g, cellShape, info);
    }

    private static DiagonalInfo getCrossHeaderInfo(float scaling, IExportAdapter tvAdapter) {
        int i;
        List<String> diagonalTitles = tvAdapter.getDiagonalTitles();
        if (diagonalTitles == null) {
            return null;
        }
        float width = 0.0f;
        int leftHeadColCount = tvAdapter.getLeftHeadColCount();
        int topHeadRowCount = tvAdapter.getTopHeadRowCount();
        for (int i2 = 0; i2 < leftHeadColCount; ++i2) {
            width += (float)tvAdapter.getColWidth(i2);
        }
        float height = 0.0f;
        for (int i3 = 0; i3 < topHeadRowCount; ++i3) {
            height += (float)tvAdapter.getRowHeight(i3);
        }
        width *= scaling;
        height *= scaling;
        DiagonalInfo info = new DiagonalInfo();
        Point2D[] rowPoint = new Point2D[topHeadRowCount + 1];
        Point2D[] colPoint = new Point2D[leftHeadColCount + 1];
        boolean[] isLean = new boolean[topHeadRowCount + leftHeadColCount];
        double x = width;
        double y = 0.0;
        Point2D.Double p = new Point2D.Double(x, y);
        rowPoint[0] = p;
        for (i = 0; i < topHeadRowCount; ++i) {
            p = new Point2D.Double(x, y += (double)((float)tvAdapter.getRowHeight(i) * scaling));
            rowPoint[i + 1] = p;
            isLean[i] = true;
        }
        x = 0.0;
        y = height;
        p = new Point2D.Double(0.0, y);
        colPoint[0] = p;
        for (i = 0; i < leftHeadColCount; ++i) {
            p = new Point2D.Double(x += (double)((float)tvAdapter.getColWidth(i) * scaling), y);
            colPoint[i + 1] = p;
            isLean[isLean.length - 1 - i] = i > 0;
        }
        info.setRowPoint(rowPoint);
        info.setColPoint(colPoint);
        info.setIsLean(isLean);
        info.setTitles(diagonalTitles);
        info.setColCount(leftHeadColCount);
        info.setRowCount(topHeadRowCount);
        info.setWidth(width);
        info.setHeight(height);
        ExFont font = new ExFont();
        font.setFontSize((int)((float)font.getFontSize() * scaling));
        info.setFont(font);
        info.setBgColor(tvAdapter.getRowHeadColor());
        return info;
    }
}

