/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.export.pdf.comp;

import com.kingdee.bos.qing.export.common.model.ExAlign;
import com.kingdee.bos.qing.export.common.model.IExportAdapter;
import com.kingdee.bos.qing.export.pdf.TableViewExportJob;
import com.kingdee.bos.qing.export.pdf.model.SetupModel;
import com.lowagie.text.DocumentException;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.ColumnText;
import com.lowagie.text.pdf.PdfContentByte;
import java.awt.Font;
import java.util.List;

public abstract class BasicPainter {
    protected com.lowagie.text.Font font;
    protected Font awtFont;
    protected SetupModel model;
    protected IExportAdapter tableAdapter;
    protected TableViewExportJob exportJob;
    protected float x;
    protected float y;
    protected float width;
    protected float height;

    public BasicPainter(TableViewExportJob exportJob) {
        this.exportJob = exportJob;
        this.model = exportJob.getModel();
        this.tableAdapter = exportJob.getTableAdapter();
    }

    public List<ColumnText> createContent(PdfContentByte pdfContentByte) throws DocumentException {
        return null;
    }

    public List<ColumnText> createContentOfLengend(PdfContentByte pdfContentByte) throws DocumentException {
        return null;
    }

    protected int transferAlign(ExAlign align) {
        switch (align) {
            case LEFT: {
                return 0;
            }
            case CENTER: {
                return 1;
            }
            case RIGHT: {
                return 2;
            }
            case TOP: {
                return 4;
            }
            case MIDDLE: {
                return 5;
            }
            case BOTTOM: {
                return 6;
            }
        }
        return 0;
    }

    protected float getTextHeight(String text) {
        if (text == null || text.isEmpty()) {
            text = "\u58f9";
        }
        BaseFont bf = this.getFont().getBaseFont();
        float ascent = bf.getAscentPoint(text, this.font.getSize());
        float descent = bf.getDescentPoint(text, this.font.getSize());
        return ascent - descent;
    }

    public float getX() {
        return this.x;
    }

    public void setX(float x) {
        this.x = x;
    }

    public float getY() {
        return this.y;
    }

    public void setY(float y) {
        this.y = y;
    }

    public float getWidth() {
        return this.width;
    }

    public void setWidth(float width) {
        this.width = width;
    }

    public float getHeight() {
        return this.height;
    }

    public void setHeight(float height) {
        this.height = height;
    }

    public IExportAdapter getTableAdapter() {
        return this.tableAdapter;
    }

    public com.lowagie.text.Font getFont() {
        return this.font;
    }

    public void setFont(com.lowagie.text.Font font) {
        this.font = font;
    }

    public Font getAwtFont() {
        return this.awtFont;
    }

    public void setAwtFont(Font awtFont) {
        this.awtFont = awtFont;
    }
}

