/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.service.job.core;

import com.kingdee.bos.Context;
import com.kingdee.bos.service.job.core.Configuration;
import com.kingdee.bos.service.job.core.ICoreJobHandler;
import com.kingdee.bos.service.job.core.IJobHandler;
import com.kingdee.bos.service.job.core.Job;
import com.kingdee.bos.service.job.core.JobDefCache;
import com.kingdee.bos.service.job.core.JobLog;
import com.kingdee.bos.service.job.core.MonitorJobSender;
import com.kingdee.bos.service.job.core.PulseSource;
import com.kingdee.bos.service.job.returns.Destroy;
import java.util.HashMap;

class DisableTrigger
implements IJobHandler,
ICoreJobHandler {
    private static final long serialVersionUID = -4049492326591791567L;

    DisableTrigger() {
    }

    @Override
    public Object execute(Job job) throws Exception {
        HashMap params = (HashMap)job.getParameters();
        String trigger = (String)params.get("trigger");
        String jobDef = (String)params.get("jobdef");
        PulseSource.removePulseSource(job.getContext().getAIS(), trigger);
        JobDefCache.remove(job.getContext().getAIS(), jobDef);
        String description = "remove jobDef and trigger by " + Configuration.serviceInstanceIdGenerator().getInstanceId();
        JobLog msg = new JobLog(JobLog.Type.Info, description, null, null, null);
        msg.save(job.getContext().getAIS(), jobDef);
        return Destroy.instance();
    }

    static void sendCommand(Context ctx, String triggerId, String jobDefId, String instanceId) {
        String currentInstanceId = Configuration.serviceInstanceIdGenerator().getInstanceId();
        if (currentInstanceId.equals(instanceId)) {
            PulseSource.removePulseSource(ctx.getAIS(), triggerId);
            JobDefCache.remove(ctx.getAIS(), jobDefId);
            String description = "remove jobDef and trigger by " + currentInstanceId;
            JobLog msg = new JobLog(JobLog.Type.Info, description, null, null, null);
            msg.save(ctx.getAIS(), jobDefId);
        } else {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("trigger", triggerId);
            params.put("jobdef", jobDefId);
            MonitorJobSender.createJob(ctx, new DisableTrigger(), "~\u4ece\u7f13\u51b2\u533a\u6e05\u9664\u8fc7\u671f\u89e6\u53d1\u5668 {" + triggerId + " # " + jobDefId + "}", params, instanceId);
        }
    }

    static void sendCommand(Context ctx, String triggerId, String jobDefId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("trigger", triggerId);
        params.put("jobdef", jobDefId);
        MonitorJobSender.createJob(ctx, new DisableTrigger(), "~\u4ece\u7f13\u51b2\u533a\u6e05\u9664\u8fc7\u671f\u89e6\u53d1\u5668 {" + triggerId + " # " + jobDefId + "}", params);
    }
}

