/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.service.job.core;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.service.job.core.Configuration;
import com.kingdee.bos.service.job.core.ICoreJobHandler;
import com.kingdee.bos.service.job.core.IJobHandler;
import com.kingdee.bos.service.job.core.Job;
import com.kingdee.bos.service.job.core.JobLoader;
import com.kingdee.bos.service.job.core.JobState;
import com.kingdee.bos.service.job.core.ReadyJobs;
import com.kingdee.bos.service.job.core.RunningJobs;
import com.kingdee.bos.service.job.core.WaitingJobs;
import com.kingdee.bos.service.job.returns.Delay;
import com.kingdee.bos.service.job.util.SQL;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class JobGardian
implements IJobHandler,
ICoreJobHandler {
    private static final int MAX_TOP_COUNT = 128;
    private static final long serialVersionUID = -988414921010713734L;
    private static Logger log = Logger.getLogger((String)RunningJobs.class.getName());
    private static HashMap<String, JobGardian> jobGardians = new HashMap();
    private String dc;
    private int count = 0;
    private volatile int top_count = 128;

    static void maybeLeaked(Job job) {
        if (!job.isPersistent()) {
            return;
        }
        String dc = job.getContext().getAIS();
        JobGardian g = jobGardians.get(dc);
        if (g != null) {
            g.top_count = 1;
        }
    }

    public JobGardian(String dc) {
        this.dc = dc;
        jobGardians.put(dc, this);
    }

    @Override
    public Object execute(Job job) throws Exception {
        try {
            if (++this.count >= this.top_count) {
                this.count = 0;
                if (this.top_count < 128) {
                    this.top_count *= 2;
                }
                this.run(job);
            }
        }
        catch (Throwable error) {
            log.warn((Object)("JobGardian failed. dc = " + this.dc), error);
        }
        return new Delay(5);
    }

    private void run(Job job) throws BOSException {
        List<Map<?, ?>> list = this.getLoadedJobIds();
        if (list.isEmpty()) {
            return;
        }
        Set<String> ids = this.collectJobIds();
        boolean leaked = this.checkLeakage(list, ids);
        if (leaked) {
            JobLoader.newJobEnqueued(this.dc);
        }
        this.checkErrorJob();
    }

    private void checkErrorJob() {
        Job[] jobs;
        for (Job job : jobs = RunningJobs.getStateErrorJobs()) {
            if (!job.reSetState()) continue;
            RunningJobs.removeStateErrorJob(job);
        }
    }

    private boolean checkLeakage(List<Map<?, ?>> list, Set<String> ids) throws BOSException {
        boolean leaked = false;
        for (Map<?, ?> i : list) {
            String jobId = (String)i.get("fjobinstid");
            if (ids.contains(jobId)) continue;
            String state = (String)i.get("fstate");
            String sql = "UPDATE T_JOB_INST SET fstate=?,fholderid=null WHERE fjobinstid=? AND fstate=?";
            int[] types = new int[]{12, 12, 12};
            Object[] values = new Object[]{JobState.ReScheduled.toString(), jobId, state};
            int affected = SQL.executeUpdate(this.dc, sql, types, values);
            if (affected != 1) continue;
            leaked = true;
            String msg = "Job leakage existed. dc = " + this.dc + ", job=" + jobId;
            log.warn((Object)msg);
        }
        return leaked;
    }

    private List<Map<?, ?>> getLoadedJobIds() throws BOSException {
        String me = Configuration.serviceInstanceIdGenerator().getInstanceId();
        String sql = "SELECT fjobinstid,fstate FROM T_JOB_INST WHERE fstate in(?,?) AND fholderid=? AND fscheduledtime < ?";
        Timestamp now = new Timestamp(System.currentTimeMillis());
        Object[] params = new Object[]{JobState.Ready.toString(), JobState.Waiting.toString(), me, now};
        int[] types = new int[]{12, 12, 12, 93};
        ArrayList list = SQL.executeQuery(this.dc, sql, types, params);
        return list;
    }

    private Set<String> collectJobIds() {
        HashSet<String> ids = new HashSet<String>(128);
        ids.addAll(WaitingJobs.getJobIds());
        ids.addAll(ReadyJobs.getJobIds());
        ids.addAll(RunningJobs.getJobIds());
        ids.addAll(RunningJobs.getExclusiveJobIds());
        return ids;
    }
}

