/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.service.job.core;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.orm.template.ORMObject;
import com.kingdee.bos.service.job.IJobService;
import com.kingdee.bos.service.job.core.ClusterStateManager;
import com.kingdee.bos.service.job.core.Configuration;
import com.kingdee.bos.service.job.core.IJobHandler;
import com.kingdee.bos.service.job.core.Job;
import com.kingdee.bos.service.job.core.JobDef;
import com.kingdee.bos.service.job.core.JobDefCache;
import com.kingdee.bos.service.job.core.JobEvent;
import com.kingdee.bos.service.job.core.JobInstanceConfig;
import com.kingdee.bos.service.job.core.JobIsolationLevel;
import com.kingdee.bos.service.job.core.JobLoader;
import com.kingdee.bos.service.job.core.JobManager;
import com.kingdee.bos.service.job.core.JobServiceStatus;
import com.kingdee.bos.service.job.core.JobState;
import com.kingdee.bos.service.job.core.JobThreadPoolManager;
import com.kingdee.bos.service.job.core.PulseSource;
import com.kingdee.bos.service.job.core.ReadyJobs;
import com.kingdee.bos.service.job.core.RunningJobs;
import com.kingdee.bos.service.job.core.ThreadWorker;
import com.kingdee.bos.service.job.core.Trigger;
import com.kingdee.bos.service.job.core.WaitingJobs;
import com.kingdee.bos.service.job.util.Counter;
import com.kingdee.bos.service.job.util.Ctx;
import com.kingdee.bos.service.job.util.DbConnector;
import com.kingdee.bos.service.job.util.IListener;
import com.kingdee.bos.service.job.util.SQL;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.rpc.ObjectFactory;
import com.kingdee.eas.base.job.JobDefInfo;
import com.kingdee.eas.base.log.AppLogFactory;
import com.kingdee.eas.base.log.IAppLog;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.StringUtils;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class JobService
extends ORMObject
implements IJobService,
Serializable {
    private static Logger log = Logger.getLogger((String)JobService.class.getName());
    private static JobManager manager = null;
    private static Method createJobDef;
    private static Method createJobInstance;
    private static Counter failedJobCounter;
    private static Counter completedJobCounter;
    private static final String RESXNAME = "com.kingdee.eas.base.job.app.ProcessDefResx";
    private static final BOSObjectType BOSTYPE;
    private static final String TITLE = "title";
    private static final String PROCESSTITLE = "processTitle";
    private static final String MANUAL_DEFAULT_LOGITEM = "manual_default_logitem";
    private static final String RELEASE = "Release";
    private static final String SUSPEND = "Suspend";
    private static final String ABORT = "Abort";
    private static final String ENABLE = "Enable";
    private static final String DISABLE = "Disable";
    private static final String TEST = "Test";
    private static final String START = "Start";
    private static final String RESUME = "Resume";
    private static final String RESTART = "Restart";
    private final Context ctx;

    public static int getFailedJobCount() {
        return failedJobCounter.get();
    }

    public static int getCompletedJobCount() {
        return completedJobCounter.get();
    }

    public static int getRunningJobcount() {
        return RunningJobs.size();
    }

    public static int getReadyJobCount() {
        return ReadyJobs.size();
    }

    static void incFailedJobCounter() {
        failedJobCounter.inc(1);
    }

    static void incCompletedJobCounter() {
        completedJobCounter.inc(1);
    }

    public JobService(Context ctx) {
        this.ctx = ctx;
    }

    @Override
    public void createJobDef(JobDef def, Trigger trigger, boolean enable) throws BOSException {
        ObjectUuidPK retPk = new ObjectUuidPK(def.getDefId());
        IAppLog appLog = null;
        IObjectPK appLogId = null;
        try {
            appLog = AppLogFactory.getLocalInstance((Context)this.ctx);
            appLogId = this.writeAppLog(this.ctx, appLog, (IObjectPK)retPk, def, RELEASE);
        }
        catch (Exception e) {
            log.error((Object)"fail to write AppLog for JobService Operation.", (Throwable)e);
        }
        ObjectFactory.invokeRequired((Object)manager, (Method)createJobDef, (Object[])new Object[]{def, trigger, enable});
        try {
            if (appLogId != null) {
                appLog.upateLogStatus(appLogId);
            }
        }
        catch (Exception e) {
            log.error((Object)"fail to write AppLog for JobService Operation.", (Throwable)e);
        }
    }

    @Override
    public void createJobInstance(Job job) throws BOSException {
        if (this.ctx != null) {
            job.setContext(this.ctx);
        }
        ObjectFactory.invokeRequired((Object)manager, (Method)createJobInstance, (Object[])new Object[]{job});
    }

    @Override
    public String createJobInstance(String title, IJobHandler handler, Timestamp scheduledTime, boolean isPersistent) throws BOSException {
        JobInstanceConfig dyn = new JobInstanceConfig(handler, isPersistent);
        Job job = new Job(this.ctx, title, dyn, null, scheduledTime, null, -1, null);
        ObjectFactory.invokeRequired((Object)manager, (Method)createJobInstance, (Object[])new Object[]{job});
        return job.getId();
    }

    @Override
    public void createJobDef(JobDef def) throws BOSException {
        this.createJobDef(def, null, false);
    }

    @Override
    public void removeJobDef(String jobDefId) throws BOSException {
        Method method = null;
        try {
            method = JobManager.class.getMethod("removeJobDef", Context.class, String.class);
        }
        catch (Exception e) {
            log.error((Object)"can't get removeJobDef method from JobManager!", (Throwable)e);
        }
        if (method != null) {
            ObjectFactory.invokeRequired((Object)manager, (Method)method, (Object[])new Object[]{this.ctx, jobDefId});
        }
    }

    @Override
    public String testJobDef(JobDef def, Object param) throws BOSException {
        return this.testJobDef(def, null, param);
    }

    @Override
    public String testJobDef(JobDef def, String selectedServer, Object param) throws BOSException {
        ObjectUuidPK retPk = new ObjectUuidPK(def.getDefId());
        IAppLog appLog = null;
        IObjectPK appLogId = null;
        try {
            appLog = AppLogFactory.getLocalInstance((Context)this.ctx);
            appLogId = this.writeAppLog(this.ctx, appLog, (IObjectPK)retPk, def, TEST);
        }
        catch (Exception e) {
            log.error((Object)"fail to write AppLog for JobService Operation.", (Throwable)e);
        }
        Job job = this.jobDefToDynJob(def, param);
        if (!StringUtils.isEmpty((String)selectedServer)) {
            job.setIsolationBoundary(selectedServer);
        }
        job.setDefId(def.getDefId());
        this.createJobInstance(job);
        try {
            if (appLogId != null) {
                appLog.upateLogStatus(appLogId);
            }
        }
        catch (Exception e) {
            log.error((Object)"fail to write AppLog for JobService Operation.", (Throwable)e);
        }
        return job.getTitle();
    }

    public Job jobDefToDynJob(JobDef def, Object param) throws BOSException {
        def.initListenersAndHandler();
        JobInstanceConfig dyn = new JobInstanceConfig(def.getHandler(), true, false, def.getPriority(), null, null, null);
        HashMap map = def.getListeners();
        for (Object event : map.keySet()) {
            ArrayList l = (ArrayList)map.get(event);
            JobEvent e = event instanceof JobEvent ? (JobEvent)event : JobEvent.valueOf(event.toString());
            for (int i = 0; i < l.size(); ++i) {
                dyn.addEventListener(e, (IListener)l.get(i));
            }
        }
        String title = "{" + def.getTitle() + " } \u6d4b\u8bd5\uff0c" + new Timestamp(System.currentTimeMillis());
        return new Job(this.ctx, title, dyn, param);
    }

    @Override
    public int abort(String[] jobInstIds) throws BOSException {
        int count = 0;
        for (int i = 0; i < jobInstIds.length; ++i) {
            try {
                boolean b = true;
                String jobId = jobInstIds[i];
                String sql = "select * from T_JOB_INST WITH(READPAST) where fjobinstid='" + jobId + "'";
                ArrayList result = SQL.executeQuery(this.ctx, sql);
                if (result.size() == 0) {
                    throw new BOSException("\u540e\u53f0\u4e8b\u52a1(" + jobId + ")\u4e0d\u5b58\u5728\uff01");
                }
                Job job = Job.from(this.ctx.getAIS(), (HashMap)result.get(0), false);
                if (job.getState().equals(JobState.Running)) {
                    log.error((Object)"fail to abort jobinst for JobService Operation.", (Throwable)new BOSException("\u540e\u53f0\u4e8b\u52a1(" + jobId + ")\u6b63\u5728\u6267\u884c\uff01"));
                    b = false;
                }
                if (job.getState().equals(JobState.Complete) || job.getState().equals(JobState.Aborted)) {
                    log.error((Object)"fail to abort jobinst for JobService Operation.", (Throwable)new BOSException("\u540e\u53f0\u4e8b\u52a1(" + jobId + ")\u5df2\u7ed3\u675f\uff01"));
                    b = false;
                }
                ObjectUuidPK retPk = new ObjectUuidPK(jobId);
                IAppLog appLog = null;
                IObjectPK appLogId = null;
                try {
                    appLog = AppLogFactory.getLocalInstance((Context)this.ctx);
                    appLogId = this.writeAppLog(this.ctx, appLog, (IObjectPK)retPk, job, ABORT);
                }
                catch (Exception e) {
                    log.error((Object)"fail to write AppLog for JobService Operation.", (Throwable)e);
                }
                if (!b || !job.setState(JobState.Aborted)) continue;
                JobManager.instance().raiseEvent(JobEvent.OnAborted, job);
                ++count;
                try {
                    if (appLogId == null) continue;
                    appLog.upateLogStatus(appLogId);
                }
                catch (Exception e) {
                    log.error((Object)"fail to write AppLog for JobService Operation.", (Throwable)e);
                }
                continue;
            }
            catch (Exception e) {
                log.error((Object)"fail to abort jobinst for JobService Operation.", (Throwable)e);
            }
        }
        return count;
    }

    @Override
    public int delete(String[] jobInstIds) throws BOSException {
        String sql = "delete from t_job_log where fownerid in (" + this.concat(jobInstIds) + ")";
        SQL.executeUpdate(this.ctx, sql);
        sql = "delete from t_job_inst where fjobinstid in (" + this.concat(jobInstIds) + ")";
        int affected = SQL.executeUpdate(this.ctx, sql);
        if (jobInstIds.length != affected) {
            sql = "delete from t_job_insthst where fjobinstid in (" + this.concat(jobInstIds) + ")";
            affected += SQL.executeUpdate(this.ctx, sql);
        }
        return affected;
    }

    @Override
    public int drop(String jobInstId) throws BOSException {
        String sql = "delete from t_job_inst where fjobinstid = ?";
        int[] types = new int[]{12};
        Object[] params = new Object[]{jobInstId};
        int affected = SQL.executeUpdate(this.ctx, sql, types, params);
        return affected;
    }

    @Override
    public int drop(String jobInstId, String title) throws BOSException {
        String sql = "delete from t_job_inst where fjobinstid = ? and ftitle = ?";
        int[] types = new int[]{12, 12};
        Object[] params = new Object[]{jobInstId, title};
        int affected = SQL.executeUpdate(this.ctx, sql, types, params);
        return affected;
    }

    @Override
    public boolean deleteByTitle(String title) throws BOSException {
        String sql = "select fjobinstid from T_JOB_INST WITH(READPAST) where ftitle=?";
        int[] types = new int[]{12};
        Object[] values = new Object[]{title};
        sql = !StringUtils.isEmpty((String)Configuration.clusterIsolation()) ? sql + " and fcluster = '" + Configuration.clusterIsolation() + "'" : sql + " and fcluster is null";
        ArrayList rs = SQL.executeQuery(this.ctx, sql, types, values);
        if (rs.size() == 0) {
            return false;
        }
        String id = (String)((Map)rs.get(0)).get("fjobinstid");
        sql = "delete from t_job_inst where fjobinstid=? and fstate!=?";
        types = new int[]{12, 12};
        values = new Object[]{id, JobState.Running.toString()};
        return SQL.executeUpdate(this.ctx, sql, types, values) == 1;
    }

    @Override
    public int moveToHistory(String[] jobInstIds) throws BOSException {
        int j;
        String ids = this.concat(jobInstIds);
        String sql = "insert into t_job_insthst(fjobinstid, ftitle, fuserid, forgid, fclientip, fcreatedtime, fscheduledtime, fexpiredtime, fstartedtime, fprogress, fpriorstate, fstate, fstatechangedtime, fparameters, fresult, fexception, fjobdefid, finstanceconfig, fisolationboundary, fhashCode, fholderid, fpriorJobId, ffinishtime, fcluster, fcostTime)\r\n select fjobinstid, ftitle, fuserid, forgid, fclientip, fcreatedtime, fscheduledtime, fexpiredtime, fstartedtime, fprogress, fpriorstate, fstate, fstatechangedtime, fparameters, fresult, fexception, fjobdefid, finstanceconfig, fisolationboundary, fhashCode, fholderid, fpriorJobId,ffinishtime, fcluster, fcostTime from t_job_inst \r\n where fjobinstid in (" + ids + ")";
        int i = SQL.executeUpdate(this.ctx, sql);
        if (i != (j = SQL.executeUpdate(this.ctx, sql = "delete from t_job_inst where fjobinstid in(" + ids + ")"))) {
            throw new BOSException("some of selected jobs' state be changed!");
        }
        return i;
    }

    @Override
    public int moveToHistory(String jobInstId) throws BOSException {
        String sql;
        int[] types = new int[]{12};
        Object[] params = new Object[]{jobInstId};
        try {
            String deletesql = "delete from t_job_insthst where fjobinstid = ?";
            SQL.executeUpdate(this.ctx, deletesql, types, params);
            sql = "insert into t_job_insthst(fjobinstid, ftitle, fuserid, forgid, fclientip, fcreatedtime, fscheduledtime, fexpiredtime, fstartedtime, fprogress, fpriorstate, fstate, fstatechangedtime, fparameters, fresult, fexception, fjobdefid, finstanceconfig, fisolationboundary, fhashCode, fholderid, fpriorJobId, ffinishtime, fcluster, fcostTime)\r\n select fjobinstid, ftitle, fuserid, forgid, fclientip, fcreatedtime, fscheduledtime, fexpiredtime, fstartedtime, fprogress, fpriorstate, fstate, fstatechangedtime, fparameters, fresult, fexception, fjobdefid, finstanceconfig, fisolationboundary, fhashCode, fholderid, fpriorJobId,ffinishtime, fcluster, fcostTime from t_job_inst \r\n where fjobinstid = ?";
            SQL.executeUpdate(this.ctx, deletesql, types, params);
        }
        catch (Exception e) {
            log.error((Object)e);
        }
        sql = "delete from t_job_inst where fjobinstid = ?";
        int i = SQL.executeUpdate(this.ctx, sql, types, params);
        return i;
    }

    @Override
    public String getJobException(String jobInstId) throws BOSException {
        return Job.load(this.ctx.getAIS(), jobInstId).getException();
    }

    @Override
    public int resume(String[] jobInstIds) throws BOSException {
        int count = 0;
        for (int i = 0; i < jobInstIds.length; ++i) {
            try {
                boolean b = true;
                String jobId = jobInstIds[i];
                String sql = "select * from T_JOB_INST WITH(READPAST) where fjobinstid='" + jobId + "'";
                ArrayList result = SQL.executeQuery(this.ctx, sql);
                if (result.size() == 0) {
                    throw new BOSException("\u540e\u53f0\u4e8b\u52a1(" + jobId + ")\u4e0d\u5b58\u5728\uff01");
                }
                Job job = Job.from(this.ctx.getAIS(), (HashMap)result.get(0), false);
                if (!job.getState().equals(JobState.Suspended)) {
                    log.error((Object)"fail to resume jobinst for JobService Operation.", (Throwable)new BOSException("\u540e\u53f0\u4e8b\u52a1(" + jobId + ")\u672a\u88ab\u6302\u8d77\uff01"));
                    b = false;
                }
                ObjectUuidPK retPk = new ObjectUuidPK(jobId);
                IAppLog appLog = null;
                IObjectPK appLogId = null;
                try {
                    appLog = AppLogFactory.getLocalInstance((Context)this.ctx);
                    appLogId = this.writeAppLog(this.ctx, appLog, (IObjectPK)retPk, job, RESUME);
                }
                catch (Exception e) {
                    log.error((Object)"fail to write AppLog for JobService Operation.", (Throwable)e);
                }
                if (!b) continue;
                String sql1 = "update t_job_inst set fstartedtime=null, fholderid=null, fisolationboundary=?, fstatechangedtime=?, fstate='" + JobState.ReScheduled + "' where fjobinstid = '" + jobId + "' and fstate in('" + JobState.Suspended + "')";
                ClusterStateManager cm = ClusterStateManager.get(this.ctx);
                int[] types = new int[]{12, 93};
                Object[] params = new Object[]{JobIsolationLevel.Server.getJobIsolationBoundary(), cm.dbNow()};
                int r = SQL.executeUpdate(this.ctx, sql1, types, params);
                JobLoader.newJobEnqueued(this.ctx);
                count += r;
                try {
                    if (appLogId == null) continue;
                    appLog.upateLogStatus(appLogId);
                }
                catch (Exception e) {
                    log.error((Object)"fail to write AppLog for JobService Operation.", (Throwable)e);
                }
                continue;
            }
            catch (Exception e) {
                log.error((Object)"fail to resume jobinst for JobService Operation.", (Throwable)e);
            }
        }
        return count;
    }

    @Override
    public int restart(String[] jobInstIds) throws BOSException {
        int count = 0;
        for (int i = 0; i < jobInstIds.length; ++i) {
            try {
                boolean b = true;
                String jobId = jobInstIds[i];
                String sql = "select * from T_JOB_INST WITH(READPAST) where fjobinstid='" + jobId + "'";
                ArrayList result = SQL.executeQuery(this.ctx, sql);
                if (result.size() == 0) {
                    throw new BOSException("\u540e\u53f0\u4e8b\u52a1(" + jobId + ")\u4e0d\u5b58\u5728\uff01");
                }
                Job job = Job.from(this.ctx.getAIS(), (HashMap)result.get(0), false);
                if (!job.getState().equals(JobState.Missed) && !job.getState().equals(JobState.Failed)) {
                    log.error((Object)"fail to restart jobinst for JobService Operation.", (Throwable)new BOSException("\u540e\u53f0\u4e8b\u52a1(" + jobId + ")\u672a\u9519\u8fc7\u6216\u5931\u8d25\uff01"));
                    b = false;
                }
                ObjectUuidPK retPk = new ObjectUuidPK(jobId);
                IAppLog appLog = null;
                IObjectPK appLogId = null;
                try {
                    appLog = AppLogFactory.getLocalInstance((Context)this.ctx);
                    appLogId = this.writeAppLog(this.ctx, appLog, (IObjectPK)retPk, job, RESTART);
                }
                catch (Exception e) {
                    log.error((Object)"fail to write AppLog for JobService Operation.", (Throwable)e);
                }
                if (!b) continue;
                String sql1 = "update t_job_inst set  fstartedtime=null, fholderid=null, fexpiredtime=null, fscheduledtime=?,fstatechangedtime=?, fstate='" + JobState.ReScheduled + "' where fjobinstid = '" + jobId + "' and fstate in('" + JobState.Missed + "','" + JobState.Failed + "')";
                ClusterStateManager cm = ClusterStateManager.get(this.ctx);
                int r = SQL.executeUpdate(this.ctx, sql1, new int[]{93, 93}, new Object[]{cm.dbNow(), cm.dbNow()});
                JobLoader.newJobEnqueued(this.ctx);
                count += r;
                try {
                    if (appLogId == null) continue;
                    appLog.upateLogStatus(appLogId);
                }
                catch (Exception e) {
                    log.error((Object)"fail to write AppLog for JobService Operation.", (Throwable)e);
                }
                continue;
            }
            catch (Exception e) {
                log.error((Object)"fail to restart jobinst for JobService Operation.", (Throwable)e);
            }
        }
        return count;
    }

    @Override
    public int suspend(String[] jobInstIds) throws BOSException {
        int count = 0;
        for (int i = 0; i < jobInstIds.length; ++i) {
            try {
                boolean b = true;
                String jobId = jobInstIds[i];
                String sql = "select * from T_JOB_INST WITH(READPAST) where fjobinstid='" + jobId + "'";
                ArrayList result = SQL.executeQuery(this.ctx, sql);
                if (result.size() == 0) {
                    throw new BOSException("\u540e\u53f0\u4e8b\u52a1(" + jobId + ")\u4e0d\u5b58\u5728\uff01");
                }
                Job job = Job.from(this.ctx.getAIS(), (HashMap)result.get(0), false);
                if (job.getState().equals(JobState.Running)) {
                    log.error((Object)"fail to suspend jobinst for JobService Operation.", (Throwable)new BOSException("\u540e\u53f0\u4e8b\u52a1(" + jobId + ")\u6b63\u5728\u6267\u884c\uff01"));
                    b = false;
                }
                if (job.getState().equals(JobState.Complete) || job.getState().equals(JobState.Aborted)) {
                    log.error((Object)"fail to suspend jobinst for JobService Operation.", (Throwable)new BOSException("\u540e\u53f0\u4e8b\u52a1(" + jobId + ")\u5df2\u7ed3\u675f\uff01"));
                    b = false;
                }
                ObjectUuidPK retPk = new ObjectUuidPK(jobId);
                IAppLog appLog = null;
                IObjectPK appLogId = null;
                try {
                    appLog = AppLogFactory.getLocalInstance((Context)this.ctx);
                    appLogId = this.writeAppLog(this.ctx, appLog, (IObjectPK)retPk, job, SUSPEND);
                }
                catch (Exception e) {
                    log.error((Object)"fail to write AppLog for JobService Operation.", (Throwable)e);
                }
                if (!b || !job.setState(JobState.Suspended)) continue;
                ++count;
                try {
                    if (appLogId == null) continue;
                    appLog.upateLogStatus(appLogId);
                }
                catch (Exception e) {
                    log.error((Object)"fail to write AppLog for JobService Operation.", (Throwable)e);
                }
                continue;
            }
            catch (Exception e) {
                log.error((Object)"fail to suspend jobinst for JobService Operation.", (Throwable)e);
            }
        }
        return count;
    }

    private String concat(String[] ids) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < ids.length; ++i) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append("'").append(ids[i].replace('\'', ' ')).append("'");
        }
        return sb.toString();
    }

    @Override
    public void enableTrigger(String triggerId) throws BOSException {
        ObjectUuidPK retPk = new ObjectUuidPK(triggerId);
        IAppLog appLog = null;
        IObjectPK appLogId = null;
        try {
            String defId = triggerId.substring(0, 36) + "BGJOBDEF";
            String sql = "select \"def\".ftitle,\"def\".fjobdefid from T_JOB_DEF as \"def\",T_JOB_TRIGGER as \"trigger\" where \"def\".fjobdefid = \"trigger\".fjobdefid and (\"trigger\".fid='" + triggerId + "' or \"trigger\".fjobdefid='" + defId + "')";
            ArrayList list = SQL.executeQuery(this.ctx.getAIS(), sql);
            if (list.size() == 0) {
                throw new BOSException("trigger {" + triggerId + "} dosn't exist.");
            }
            JobDefInfo jobdefInfo = this.hashMapToJobdef((HashMap)list.get(0));
            appLog = AppLogFactory.getLocalInstance((Context)this.ctx);
            appLogId = this.writeAppLog(this.ctx, appLog, (IObjectPK)retPk, jobdefInfo, ENABLE);
        }
        catch (Exception e) {
            log.error((Object)"fail to write AppLog for JobService Operation.", (Throwable)e);
        }
        manager.enableTrigger(triggerId, this.ctx.getAIS());
        try {
            if (appLogId != null) {
                appLog.upateLogStatus(appLogId);
            }
        }
        catch (Exception e) {
            log.error((Object)"fail to write AppLog for JobService Operation.", (Throwable)e);
        }
    }

    private JobDefInfo hashMapToJobdef(HashMap hashMap) {
        JobDefInfo jobDefInfo = new JobDefInfo();
        jobDefInfo.setTitle(hashMap.get("ftitle") != null ? (String)hashMap.get("ftitle") : "");
        jobDefInfo.setJobdefid(hashMap.get("fjobdefid") != null ? (String)hashMap.get("fjobdefid") : "");
        return jobDefInfo;
    }

    @Override
    public void disableTrigger(String triggerId) throws BOSException {
        ObjectUuidPK retPk = new ObjectUuidPK(triggerId);
        IAppLog appLog = null;
        IObjectPK appLogId = null;
        try {
            String defId = triggerId.substring(0, 36) + "BGJOBDEF";
            String sql = "select \"def\".ftitle,\"def\".fjobdefid from T_JOB_DEF as \"def\",T_JOB_TRIGGER as \"trigger\" where \"def\".fjobdefid = \"trigger\".fjobdefid and (\"trigger\".fid='" + triggerId + "' or \"trigger\".fjobdefid='" + defId + "')";
            ArrayList list = SQL.executeQuery(this.ctx.getAIS(), sql);
            if (list.size() == 0) {
                throw new BOSException("trigger {" + triggerId + "} dosn't exist.");
            }
            JobDefInfo jobdefInfo = this.hashMapToJobdef((HashMap)list.get(0));
            appLog = AppLogFactory.getLocalInstance((Context)this.ctx);
            appLogId = this.writeAppLog(this.ctx, appLog, (IObjectPK)retPk, jobdefInfo, DISABLE);
        }
        catch (Exception e) {
            log.error((Object)"fail to write AppLog for JobService Operation.", (Throwable)e);
        }
        manager.disableTrigger(triggerId, this.ctx.getAIS());
        try {
            if (appLogId != null) {
                appLog.upateLogStatus(appLogId);
            }
        }
        catch (Exception e) {
            log.error((Object)"fail to write AppLog for JobService Operation.", (Throwable)e);
        }
    }

    @Override
    public String createJobInstance(String jobDefId, Object param, Timestamp scheduledTime) throws BOSException {
        JobDef def = JobDefCache.getJobDef(this.ctx.getAIS(), jobDefId);
        if (def == null) {
            throw new BOSException("job def doesn't exist, its id is {" + jobDefId + "}, datacenter: " + this.ctx.getAIS());
        }
        ObjectUuidPK retPk = new ObjectUuidPK(def.getDefId());
        IAppLog appLog = null;
        IObjectPK appLogId = null;
        try {
            appLog = AppLogFactory.getLocalInstance((Context)this.ctx);
            appLogId = this.writeAppLog(this.ctx, appLog, (IObjectPK)retPk, def, START);
        }
        catch (Exception e) {
            log.error((Object)"fail to write AppLog for JobService Operation.", (Throwable)e);
        }
        if (scheduledTime == null) {
            scheduledTime = new Timestamp(System.currentTimeMillis() + 1000L);
        }
        Job job = def.newInstance(this.ctx, param, scheduledTime);
        this.setSelectedServer(jobDefId, job);
        manager.add(job);
        try {
            if (appLogId != null) {
                appLog.upateLogStatus(appLogId);
            }
        }
        catch (Exception e) {
            log.error((Object)"fail to write AppLog for JobService Operation.", (Throwable)e);
        }
        return job.getTitle();
    }

    private void setSelectedServer(String jobDefId, Job job) throws BOSException {
        String triggerId = jobDefId.substring(0, 36) + "BGJOBTRI";
        String sql = "select * from T_JOB_TRIGGER where fid=? or fjobdefid=?";
        int[] types = new int[]{12, 12};
        Object[] values = new Object[]{triggerId, jobDefId};
        ArrayList list = SQL.executeQuery(this.ctx, sql, types, values);
        if (list.size() == 0) {
            return;
        }
        Trigger trigger = Trigger.from(this.ctx.getAIS(), (HashMap)list.get(0));
        String isolationBoundary = trigger.getSelectedServer();
        if (!StringUtils.isEmpty((String)isolationBoundary)) {
            job.setIsolationBoundary(isolationBoundary);
        }
    }

    @Override
    public void cleanWasteJobDef() throws BOSException {
        String sql = "delete from t_job_def where fjobdefid in(select fjobdefid from t_job_trigger where fexpiredtime<=getdate())";
        sql = !StringUtils.isEmpty((String)Configuration.clusterIsolation()) ? sql + " and fcluster = '" + Configuration.clusterIsolation() + "'" : sql + " and fcluster is null";
        SQL.executeUpdate(this.ctx, sql);
        sql = "delete from t_job_trigger where fexpiredtime<=getdate()";
        sql = !StringUtils.isEmpty((String)Configuration.clusterIsolation()) ? sql + " and fcluster = '" + Configuration.clusterIsolation() + "'" : sql + " and fcluster is null";
        SQL.executeUpdate(this.ctx, sql);
    }

    @Override
    public String getServiceConfigInfo(String dc) {
        return Configuration.getConfigInfo(dc);
    }

    @Override
    public JobServiceStatus getServiceStatus() {
        return JobService.getJobServiceStatus();
    }

    public static JobServiceStatus getJobServiceStatus() {
        JobServiceStatus status = new JobServiceStatus();
        status.contextCacheSize = Ctx.cacheSize();
        status.jobDefCacheSize = JobDefCache.cacheSize();
        status.readyJobCount = ReadyJobs.size();
        status.readyJobs = ReadyJobs.dump();
        status.runningJobCount = RunningJobs.size();
        status.runningJobs = RunningJobs.dump();
        status.triggerCacheCount = PulseSource.cachedTriggerCount();
        status.triggers = PulseSource.dumpTriggers();
        status.waitingJobCount = WaitingJobs.size();
        status.waitingJobs = WaitingJobs.dump();
        status.usedTime = ThreadWorker.usedTime();
        status.processedJobCount = ThreadWorker.processedJobCount();
        status.availableTime = ThreadWorker.availableTime();
        status.suspenedTransientJobCacheSize = JobManager.instance().suspendedJobCacheSize();
        status.dataCenterCount = DbConnector.dcCount();
        status.now = new Timestamp(System.currentTimeMillis());
        status.coreJobCount = ThreadWorker.coreJobCount();
        status.coreTimeUsed = ThreadWorker.coreTimeUsed();
        status.clusterStateManger = ClusterStateManager.dump();
        status.exclusiveJobIds = RunningJobs.getExclusiveJobIds();
        status.maximalConcurrency = Configuration.maximalConcurrency();
        return status;
    }

    @Override
    public Job getJobInstance(String id) throws BOSException {
        return Job.load(this.ctx.getAIS(), id);
    }

    @Override
    public boolean reschedule(String jobInstId, int priority) throws BOSException {
        return this.reschedule(jobInstId, priority, null);
    }

    @Override
    public boolean reschedule(String jobInstId, int priority, Date scheduleTime) throws BOSException {
        return this.reschedule(jobInstId, priority, scheduleTime, null);
    }

    @Override
    public boolean reschedule(String jobInstId, int priority, Date scheduleTime, String serverId) throws BOSException {
        Job job = this.load(jobInstId);
        if (priority >= -1000000) {
            JobInstanceConfig cfg = job.getInstanceConfig();
            if (cfg == null) {
                throw new BOSException("\u4f7f\u7528\u540e\u53f0\u4e8b\u52a1\u5b9a\u4e49\u7684\u5b9e\u4f8b\u4e0d\u80fd\u8c03\u6574\u4f18\u5148\u7ea7\uff01");
            }
            cfg.priority = priority;
        }
        if (scheduleTime != null) {
            job.setScheduledTime(scheduleTime);
        }
        if (serverId != null) {
            job.setIsolationBoundary(serverId);
        }
        JobLoader.newJobEnqueued(job.getContext());
        if (job.getState() == JobState.ReScheduled) {
            return JobState.ReScheduled.save(job) == 1;
        }
        return job.setState(JobState.ReScheduled);
    }

    private Job load(String jobInstId) throws BOSException {
        String sql = "select * from T_JOB_INST WITH(READPAST) where fjobinstid='" + jobInstId + "'";
        ArrayList result = SQL.executeQuery(this.ctx, sql);
        if (result.size() == 0) {
            throw new BOSException("\u540e\u53f0\u4e8b\u52a1(" + jobInstId + ")\u4e0d\u5b58\u5728\uff01");
        }
        Job job = Job.from(this.ctx.getAIS(), (HashMap)result.get(0), false);
        if (job.getState().equals(JobState.Running)) {
            throw new BOSException("\u540e\u53f0\u4e8b\u52a1(" + jobInstId + ")\u6b63\u5728\u6267\u884c\uff01");
        }
        if (job.getState().equals(JobState.Complete) || job.getState().equals(JobState.Aborted)) {
            throw new BOSException("\u540e\u53f0\u4e8b\u52a1(" + jobInstId + ")\u5df2\u7ed3\u675f\uff01");
        }
        return job;
    }

    @Override
    public JobState getState(String jobId) throws BOSException {
        String sql = "select fstate from T_JOB_INST WITH(READPAST) where fjobinstid=?";
        int[] types = new int[]{12};
        Object[] values = new Object[]{jobId};
        ArrayList result = SQL.executeQuery(this.ctx, sql, types, values);
        if (result.size() == 0) {
            return null;
        }
        Map map = (Map)result.get(0);
        String state = (String)map.get("fstate");
        return JobState.valueOf(state);
    }

    @Override
    public boolean exists(String jobId) {
        String sql = "select fstate from T_JOB_INST WITH(READPAST) where fjobinstid=?";
        try {
            int[] types = new int[]{12};
            Object[] values = new Object[]{jobId};
            ArrayList result = SQL.executeQuery(this.ctx, sql, types, values);
            return result.size() == 1;
        }
        catch (BOSException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public boolean deleteForExists(String jobId) {
        String sql = "select 1 from T_JOB_INST where fjobinstid=? and fstate in ('Failed','Complete','Suspended','Aborted')";
        try {
            int[] types = new int[]{12};
            Object[] values = new Object[]{jobId};
            ArrayList result = SQL.executeQuery(this.ctx, sql, types, values);
            if (result.size() == 1) {
                this.delete(new String[]{jobId});
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    @Override
    public String getJobThreadDump(String jobId) {
        Job job;
        if (!StringUtils.isEmpty((String)jobId) && (job = RunningJobs.get(jobId + "@" + this.ctx.getAIS())) != null && job.getThread() != null) {
            StackTraceElement[] stack = job.getThread().getStackTrace();
            StringBuilder sb = new StringBuilder(1024);
            sb.append("The job is {" + job.getTitle() + "\uff0c" + job.getId() + "}, and was started at " + job.getThread().getName() + " " + job.getStartedTime() + ".\r\n");
            for (StackTraceElement se : stack) {
                sb.append("at ").append(se.getClassName()).append('.').append(se.getMethodName()).append('(').append(se.getFileName()).append(':').append(se.getLineNumber()).append(")\r\n");
            }
            return sb.toString();
        }
        return "";
    }

    @Override
    public String getJobTitleByMutex(String mutex) {
        Job job = RunningJobs.getJobByMutex(mutex);
        if (job != null) {
            return job.getTitle();
        }
        return null;
    }

    @Override
    public String getNextTriggerTime(String triggerId) {
        Timestamp nextTime = PulseSource.getNextTriggerTime(triggerId);
        if (nextTime != null) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            return sdf.format(nextTime);
        }
        return null;
    }

    @Override
    public Map<String, Object> getThreadPoolSize() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("majorJobSize", JobThreadPoolManager.getInstance().getThreadPool(ReadyJobs.Queue.MajorJobs).getMaximumPoolSize());
        map.put("bigJobSize", JobThreadPoolManager.getInstance().getThreadPool(ReadyJobs.Queue.BigJobs).getMaximumPoolSize());
        map.put("wfJobSize", JobThreadPoolManager.getInstance().getThreadPool(ReadyJobs.Queue.WfJobs).getMaximumPoolSize());
        map.put("nextAdjustTime", new Date(JobThreadPoolManager.getNextAdjustTime()));
        return map;
    }

    @Override
    public boolean setThreadPoolSize(int[] size, long nextAdjustTime) throws BOSException {
        try {
            JobThreadPoolManager.setPoolSize(ReadyJobs.Queue.MajorJobs, size[0]);
            JobThreadPoolManager.setPoolSize(ReadyJobs.Queue.BigJobs, size[1]);
            JobThreadPoolManager.setPoolSize(ReadyJobs.Queue.WfJobs, size[2]);
            JobThreadPoolManager.setNextAdjustTime(nextAdjustTime);
        }
        catch (Throwable e) {
            log.error((Object)("setThreadPoolSize failed! size:" + size), e);
            throw new BOSException("setThreadPoolSize failed! size:" + size, e);
        }
        return true;
    }

    protected IObjectPK writeAppLog(Context ctx, IAppLog appLog, IObjectPK pk, JobDef def, String methodName) throws BOSException {
        IObjectPK appLogId = null;
        if (appLog == null) {
            appLog = AppLogFactory.getLocalInstance((Context)ctx);
        }
        appLogId = appLog.writeLog(methodName, BOSTYPE, pk, def.getName(), MANUAL_DEFAULT_LOGITEM, ContextUtil.getCurrentOrgUnit((Context)ctx).getId().toString(), ResourceBase.getString((String)RESXNAME, (String)methodName, (Locale)ctx.getLocale()) + "(" + ResourceBase.getString((String)RESXNAME, (String)PROCESSTITLE, (Locale)ctx.getLocale()) + ":" + def.getName() + "; jobDefId:" + def.getDefId() + ")");
        return appLogId;
    }

    protected IObjectPK writeAppLog(Context ctx, IAppLog appLog, IObjectPK pk, JobDefInfo jobdefInfo, String methodName) throws BOSException {
        IObjectPK appLogId = null;
        if (appLog == null) {
            appLog = AppLogFactory.getLocalInstance((Context)ctx);
        }
        appLogId = appLog.writeLog(methodName, BOSTYPE, pk, jobdefInfo.getTitle(), MANUAL_DEFAULT_LOGITEM, ContextUtil.getCurrentOrgUnit((Context)ctx).getId().toString(), ResourceBase.getString((String)RESXNAME, (String)methodName, (Locale)ctx.getLocale()) + "(" + ResourceBase.getString((String)RESXNAME, (String)PROCESSTITLE, (Locale)ctx.getLocale()) + ":" + jobdefInfo.getTitle() + "; jobDefId:" + jobdefInfo.getJobdefid() + ")");
        return appLogId;
    }

    protected IObjectPK writeAppLog(Context ctx, IAppLog appLog, IObjectPK pk, Job job, String methodName) throws BOSException {
        IObjectPK appLogId = null;
        if (appLog == null) {
            appLog = AppLogFactory.getLocalInstance((Context)ctx);
        }
        appLogId = appLog.writeLog(methodName, BOSTYPE, pk, job.getTitle(), MANUAL_DEFAULT_LOGITEM, ContextUtil.getCurrentOrgUnit((Context)ctx).getId().toString(), ResourceBase.getString((String)RESXNAME, (String)methodName, (Locale)ctx.getLocale()) + "(" + ResourceBase.getString((String)RESXNAME, (String)TITLE, (Locale)ctx.getLocale()) + ":" + job.getTitle() + "; jobInstId:" + job.getId() + ")");
        return appLogId;
    }

    static {
        failedJobCounter = new Counter(300);
        completedJobCounter = new Counter(300);
        BOSTYPE = new BOSObjectType("F2807CCC");
        try {
            manager = JobManager.instance();
            createJobDef = JobManager.class.getMethod("createJobDef", JobDef.class, Trigger.class, Boolean.TYPE);
            createJobInstance = JobManager.class.getMethod("add", Job.class);
        }
        catch (Throwable e) {
            log.error((Object)"get methods from JobManager failed!", e);
        }
    }
}

