/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.service.job.core;

import com.kingdee.bos.Context;
import com.kingdee.bos.service.job.core.ClusterStateManager;
import com.kingdee.bos.service.job.core.Configuration;
import com.kingdee.bos.service.job.core.IWfJobHandler;
import com.kingdee.bos.service.job.core.Job;
import com.kingdee.bos.service.job.core.JobLog;
import com.kingdee.bos.service.job.core.ReadyJobs;
import com.kingdee.bos.service.job.core.WaitingJobs;
import com.kingdee.bos.service.job.util.Heap;
import com.kingdee.bos.service.job.util.IHeapElement;
import com.kingdee.bos.service.job.util.SQL;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class RunningJobs {
    private static Logger log = Logger.getLogger((String)RunningJobs.class.getName());
    private static HashMap<String, Job> jobs = new HashMap();
    private static HashMap<String, Job> stateErrorJobs = new HashMap();
    private static int bigJobSize = 0;
    private static int majorJobSize = 0;
    private static HashSet<String> mutexes = new HashSet();
    private static HashMap<String, Heap> exclusiveJobs = new HashMap();

    private static void delayExclusiveJob(Job job) {
        Heap list = exclusiveJobs.get(job.getMutex());
        if (list == null) {
            list = new Heap();
            exclusiveJobs.put(job.getMutex(), list);
        }
        list.push(job);
    }

    static synchronized int readyCount() {
        int count = 0;
        for (Heap list : exclusiveJobs.values()) {
            count += list.size();
        }
        return count;
    }

    static synchronized boolean put(Job job) {
        if (jobs.containsKey(job.getKey())) {
            if (Configuration.isDebug()) {
                JobLog msg = new JobLog(JobLog.Type.Warn, "job " + job + " is in running jobs pool now!");
                job.saveMessage(msg);
            }
            return false;
        }
        String mutex = job.getMutex();
        if (mutex != null && mutexes.contains(mutex)) {
            RunningJobs.delayExclusiveJob(job);
            Job runningJob = RunningJobs.getJobByMutex(mutex);
            job.setProgress("Job was delayed because of the runningJob [" + runningJob.getTitle() + "] has the same mutex=" + mutex);
            log.info((Object)("delayExclusiveJob,job=" + job.toString() + " mutex=" + mutex));
            return false;
        }
        if (mutex != null) {
            mutexes.add(mutex);
        }
        jobs.put(job.getKey(), job);
        if (!job.isSmallJob() && !(job.getHandler() instanceof IWfJobHandler)) {
            if (job.getStaticPriority() < 0) {
                ++majorJobSize;
            } else {
                ++bigJobSize;
            }
        }
        return true;
    }

    private static void delayThreadControlJob(Job job) {
        job.setScheduledTime(new Timestamp(2000L + System.currentTimeMillis()));
        if (!WaitingJobs.in(job)) {
            log.error((Object)("delay job " + job + " failed and be ignored!"));
        }
    }

    private static boolean threadLock(Job job) {
        String threadName = job.getThreadName();
        int theadUbound = job.getThreadUBound();
        Context ctx = job.getContext();
        if (ctx == null || threadName == null || theadUbound <= 0) {
            return true;
        }
        if (!ClusterStateManager.get(ctx).isReady()) {
            return false;
        }
        int[] types = new int[]{12};
        Object[] objs = new Object[]{threadName};
        String sql = "select fname from t_job_thread where fname=?";
        try {
            if (SQL.executeQuery(ctx, sql, types, objs).size() == 0) {
                sql = "insert into t_job_thread(fname, fcount, ftime) values('" + threadName + "',0,getdate())";
                SQL.executeUpdate(ctx, sql);
            }
            sql = "update t_job_thread set fcount=fcount+1,ftime=getdate() where fname=? and fcount<?";
            types = new int[]{12, 4};
            objs = new Object[]{threadName, String.valueOf(theadUbound)};
            return SQL.executeUpdate(ctx, sql, types, objs) >= 1;
        }
        catch (Throwable t) {
            log.error((Object)("threadLock job " + job + " failed!"));
            return false;
        }
    }

    private static void threadUnlock(Job job) {
        String threadName = job.getThreadName();
        int theadUbound = job.getThreadUBound();
        Context ctx = job.getContext();
        if (ctx == null || threadName == null || theadUbound <= 0) {
            return;
        }
        try {
            String sql = "update t_job_thread set fcount=fcount-1,ftime=getdate() where fname='" + threadName + "' and fcount>0";
            SQL.executeUpdate(ctx, sql);
        }
        catch (Throwable t) {
            log.error((Object)("threadUnlock job " + job + " failed!"));
        }
    }

    private static void releaseExclusiveJob(Job job) {
        Heap list = exclusiveJobs.get(job.getMutex());
        if (list == null) {
            return;
        }
        if (list.size() > 0) {
            IHeapElement o = list.pop();
            ReadyJobs.in((Job)o);
        }
        if (list.size() == 0) {
            exclusiveJobs.remove(job.getMutex());
        }
    }

    private static void releaseAllExclusiveJobs() {
        if (exclusiveJobs.size() == 0) {
            return;
        }
        for (Heap list : exclusiveJobs.values()) {
            while (list.size() > 0) {
                IHeapElement o = list.pop();
                ReadyJobs.in((Job)o);
            }
        }
        exclusiveJobs.clear();
    }

    static synchronized void dispose(Job job) {
        if (job != null) {
            String mutex;
            jobs.remove(job.getKey());
            if (!job.isSmallJob() && !(job.getHandler() instanceof IWfJobHandler)) {
                if (job.getStaticPriority() < 0) {
                    --majorJobSize;
                } else {
                    --bigJobSize;
                }
            }
            if ((mutex = job.getMutex()) != null) {
                mutexes.remove(mutex);
                RunningJobs.releaseExclusiveJob(job);
            }
        }
        if (jobs.size() == 0) {
            mutexes.clear();
            RunningJobs.releaseAllExclusiveJobs();
        }
    }

    static synchronized Job get(String key) {
        return jobs.get(key);
    }

    public static synchronized int size() {
        return jobs.size();
    }

    public static synchronized int bigJobSize() {
        return bigJobSize;
    }

    public static synchronized int majorJobSize() {
        return majorJobSize;
    }

    static synchronized int size(String dataCenter) {
        if (jobs.size() == 0) {
            return 0;
        }
        Iterator<Job> it = jobs.values().iterator();
        int count = 0;
        while (it.hasNext()) {
            Job job = it.next();
            Context ctx = job.getContext();
            if (ctx == null || !dataCenter.equals(ctx.getAIS())) continue;
            ++count;
        }
        return count;
    }

    static synchronized String dump() {
        Object[] list = jobs.values().toArray();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < list.length; ++i) {
            Job job = (Job)list[i];
            sb.append(i + 1).append(".  ");
            String title = job.getTitle();
            if (title == null) {
                title = job.getHandler().getClass().getName();
                int j = title.lastIndexOf(46);
                title = title.substring(j + 1);
            }
            sb.append(title);
            if (job.getContext() != null) {
                sb.append("; datacenter{").append(job.getContext().getAIS()).append("}");
            }
            sb.append(job.getScheduledTime());
            sb.append(",");
            sb.append(job.getState());
            sb.append("\r\n");
        }
        return sb.toString();
    }

    public static synchronized List<Map<String, Object>> getAllJobs() {
        Object[] list = jobs.values().toArray();
        ArrayList<Map<String, Object>> ret = new ArrayList<Map<String, Object>>();
        for (int i = 0; i < list.length; ++i) {
            Job job = (Job)list[i];
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("id", job.getId());
            String title = job.getTitle();
            if (title == null) {
                title = job.getHandler().getClass().getName();
                int j = title.lastIndexOf(46);
                title = title.substring(j + 1);
            }
            map.put("title", title);
            map.put("handler", job.getHandler() == null ? null : job.getHandler().toString());
            map.put("createdTime", job.getCreatedTime());
            map.put("startedTime", job.getStartedTime());
            map.put("finishTime", job.getFinishTime());
            map.put("scheduledTime", job.getScheduledTime());
            map.put("state", job.getState().toString());
            map.put("priotity", job.getPriority());
            ret.add(map);
        }
        return ret;
    }

    static synchronized Job[] getJobs() {
        return jobs.values().toArray(new Job[jobs.size()]);
    }

    public static synchronized Collection<String> getJobIds() {
        ArrayList<String> list = new ArrayList<String>(RunningJobs.size());
        for (Job o : jobs.values()) {
            list.add(o.getId());
        }
        return list;
    }

    public static synchronized Collection<String> getExclusiveJobIds() {
        ArrayList<String> list = new ArrayList<String>();
        for (Heap exMetas : exclusiveJobs.values()) {
            ArrayList jobsList = exMetas.toArray();
            if (jobsList == null) continue;
            for (Object jobObject : jobsList) {
                Job job = (Job)jobObject;
                list.add(job.getId());
            }
        }
        return list;
    }

    public static synchronized String dumpExclusiveJobIds() {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        for (Heap exMetas : exclusiveJobs.values()) {
            ArrayList jobsList = exMetas.toArray();
            if (jobsList == null) continue;
            for (Object jobObject : jobsList) {
                Job job = (Job)jobObject;
                sb.append(++i).append(".  ");
                String title = job.getTitle();
                if (title == null) {
                    title = job.getHandler().getClass().getName();
                    int j = title.lastIndexOf(46);
                    title = title.substring(j + 1);
                }
                sb.append(title);
                if (job.getContext() != null) {
                    sb.append("; datacenter{").append(job.getContext().getAIS()).append("}");
                }
                sb.append(job.getScheduledTime());
                sb.append(",");
                sb.append(job.getState());
                sb.append("\r\n");
            }
        }
        return sb.toString();
    }

    public static synchronized Job getJobByMutex(String mutex) {
        if (mutex != null) {
            Job[] allJobs = RunningJobs.getJobs();
            for (int i = 0; i < allJobs.length; ++i) {
                Job job = allJobs[i];
                if (!mutex.equals(job.getMutex())) continue;
                return job;
            }
        }
        return null;
    }

    public static synchronized int getMutexJobSize(String mutex) {
        if (mutex != null && exclusiveJobs.containsKey(mutex)) {
            Heap jobsList = exclusiveJobs.get(mutex);
            return jobsList.size();
        }
        return 0;
    }

    public static synchronized void addStateErrorJob(Job job) {
        stateErrorJobs.put(job.getId(), job);
    }

    public static synchronized void removeStateErrorJob(Job job) {
        stateErrorJobs.remove(job.getId());
    }

    public static synchronized Job[] getStateErrorJobs() {
        return stateErrorJobs.values().toArray(new Job[stateErrorJobs.size()]);
    }
}

