/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.service.job.core;

import com.kingdee.bos.service.job.core.Job;
import com.kingdee.bos.service.job.core.JobState;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;

public class WaitingJobsNewBak {
    private static Logger log = Logger.getLogger(WaitingJobsNewBak.class);
    private static List<Job> jobList = new LinkedList<Job>();

    public static boolean in(Job job) {
        if (job.setState(JobState.Waiting)) {
            return WaitingJobsNewBak.innerIn(job);
        }
        return false;
    }

    private static synchronized boolean innerIn(Job job) {
        jobList.add(job);
        WaitingJobsNewBak.class.notifyAll();
        return true;
    }

    static synchronized Job[] out() {
        while (jobList.size() == 0) {
            try {
                WaitingJobsNewBak.class.wait(1000L);
            }
            catch (Throwable throwable) {}
        }
        ArrayList<Job> result = new ArrayList<Job>();
        long minScheduleTime = Long.MAX_VALUE;
        while (true) {
            HashSet<Job> set = new HashSet<Job>();
            Iterator<Job> iter = jobList.iterator();
            while (iter.hasNext()) {
                Job job = iter.next();
                long t = job.getScheduledTime().getTime();
                if (t - System.currentTimeMillis() <= 0L) {
                    if (!set.contains(job)) {
                        set.add(job);
                        result.add(job);
                    }
                    iter.remove();
                    continue;
                }
                if (t >= minScheduleTime) continue;
                minScheduleTime = t;
            }
            if (result.size() > 0) {
                return result.toArray(new Job[result.size()]);
            }
            try {
                long wt = minScheduleTime - System.currentTimeMillis();
                if (wt > 5000L) {
                    wt = 5000L;
                } else if (wt < 0L) {
                    wt = 100L;
                }
                WaitingJobsNewBak.class.wait(wt);
            }
            catch (Throwable throwable) {
            }
        }
    }

    static synchronized Job remove(String key) {
        Iterator<Job> iter = jobList.iterator();
        while (iter.hasNext()) {
            Job job = iter.next();
            if (!job.getKey().equals(key)) continue;
            iter.remove();
            return job;
        }
        return null;
    }

    static synchronized String dump() {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        for (Job job : jobList) {
            sb.append(i + 1).append(".  ");
            String title = job.getTitle();
            if (title == null) {
                title = job.getHandler().getClass().getName();
                int j = title.lastIndexOf(46);
                title = title.substring(j + 1);
            }
            sb.append(title);
            if (job.getContext() != null) {
                sb.append("; datacenter{").append(job.getContext().getAIS()).append("}");
            }
            sb.append(job.getScheduledTime());
            sb.append("\r\n");
        }
        return sb.toString();
    }

    static synchronized int size() {
        return jobList.size();
    }
}

