/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.service.job.core;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.service.job.core.Configuration;
import com.kingdee.bos.service.job.core.Wrapper;
import com.kingdee.bos.service.job.wrapper.FunctionWrapperFactory;
import com.kingdee.bos.service.job.wrapper.InterfaceWrapperFactory;
import com.kingdee.bos.service.job.wrapper.MessageSenderWrapperFactory;
import com.kingdee.bos.service.job.wrapper.MethodWrapperFactory;
import com.kingdee.util.ConfigurationItem;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class WrapperFactory {
    public static final String SEPERATOR = ":";
    private static Logger log = Logger.getLogger((String)WrapperFactory.class.getName());
    private static final HashMap<String, WrapperFactory> factories = new HashMap();
    protected String code;
    protected String source;
    protected String f7;

    public static Wrapper getWrapper(String s) throws BOSException {
        int i = s.indexOf(SEPERATOR);
        if (i < 0) {
            throw new IllegalArgumentException("{" + s + "} has no {" + SEPERATOR + "}, is an illegal wrapper config.");
        }
        String code = s.substring(0, i);
        WrapperFactory fac = factories.get(code);
        if (fac == null) {
            throw new IllegalArgumentException("has no wrapper factory for code of {" + code + "}");
        }
        return fac.parse(s.substring(i + 1));
    }

    private static void loadDefaultWrapperFactory() {
        WrapperFactory fac = new FunctionWrapperFactory();
        factories.put(fac.getCode(), fac);
        fac = new InterfaceWrapperFactory();
        factories.put(fac.getCode(), fac);
        fac = new MessageSenderWrapperFactory();
        factories.put(fac.getCode(), fac);
        fac = new MethodWrapperFactory();
        factories.put(fac.getCode(), fac);
    }

    public String getCode() {
        return this.code;
    }

    public String getSource() {
        return this.source;
    }

    public String getF7() {
        return this.f7;
    }

    public abstract Wrapper parse(String var1) throws BOSException;

    static {
        WrapperFactory.loadDefaultWrapperFactory();
        try {
            List list;
            ConfigurationItem wrappers;
            ConfigurationItem root = Configuration.getConfiguration();
            if (root != null && (wrappers = root.getChild("wrappers")) != null && (list = wrappers.getChildren("wrapper")) != null) {
                for (int i = 0; i < list.size(); ++i) {
                    ConfigurationItem item = (ConfigurationItem)list.get(i);
                    Map map = item.getProperties();
                    String code = (String)map.get("code");
                    String className = (String)map.get("class");
                    String source = (String)map.get("source");
                    String f7 = (String)map.get("f7");
                    try {
                        WrapperFactory fac = (WrapperFactory)Class.forName(className).newInstance();
                        fac.code = code;
                        fac.source = source;
                        fac.f7 = f7;
                        factories.put(code, fac);
                        continue;
                    }
                    catch (Exception e) {
                        log.error((Object)("load job handler wrapper {" + className + "} failed, please check bosconfig.xml!"), (Throwable)e);
                    }
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"read wrapper config from bosconfig.xml failed!", (Throwable)e);
        }
    }
}

