/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.service.job.returns;

import com.kingdee.bos.service.job.core.Job;
import com.kingdee.bos.service.job.core.JobEvent;
import com.kingdee.bos.service.job.core.JobState;
import com.kingdee.bos.service.job.core.Returns;
import java.sql.Timestamp;

public class Delay
extends Returns {
    private long milliseconds;

    public Delay(Object parameters) {
        super(parameters, null, null);
        this.milliseconds = 1000L;
    }

    public Delay(int seconds) {
        super(null, null, null);
        this.milliseconds = seconds * 1000;
    }

    public Delay(long milliseconds) {
        super(null, null, null);
        this.milliseconds = milliseconds;
    }

    public Delay(Object parameters, int seconds) {
        super(parameters, null, null);
        this.milliseconds = seconds * 1000;
    }

    public String toString() {
        return Delay.class.getName() + "{" + this.milliseconds + "}";
    }

    @Override
    protected JobState getTargetState() {
        return JobState.ReScheduled;
    }

    @Override
    protected JobEvent getRaisedEvent() {
        return JobEvent.OnDelayed;
    }

    @Override
    protected boolean handleReturns(Job job) {
        job.setScheduledTime(new Timestamp(System.currentTimeMillis() + this.milliseconds));
        if (!super.handleReturns(job)) {
            return false;
        }
        Delay.send2WaitingJobsQueue(job);
        return true;
    }
}

