/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.service.job.util;

import com.kingdee.bos.service.job.util.CacheNode;
import com.kingdee.bos.service.job.util.CacheedElement;
import com.kingdee.bos.service.job.util.DoubleLinkedList;
import com.kingdee.bos.service.job.util.ICacheElement;
import java.util.HashMap;

public class Cache {
    private HashMap map;
    private DoubleLinkedList list;
    private int capacity;

    public Cache(int capacity) {
        this.capacity = capacity;
        this.map = new HashMap(capacity);
        this.list = new DoubleLinkedList(new CacheNode());
    }

    private boolean isFull() {
        return this.map.size() == this.capacity;
    }

    public synchronized void clear() {
        this.list.clear();
        this.map.clear();
    }

    public synchronized ICacheElement push(ICacheElement obj) {
        CacheNode node = (CacheNode)this.map.get(obj.getKey());
        ICacheElement discard = null;
        if (node != null) {
            discard = node.obj;
            this.list.poll(node);
        } else if (this.isFull()) {
            node = (CacheNode)this.list.poll();
            if (node != null) {
                discard = node.obj;
                this.map.remove(node.key);
            } else {
                node = new CacheNode();
            }
        } else {
            node = new CacheNode();
        }
        node.key = obj.getKey();
        node.obj = obj;
        this.list.push(node);
        this.map.put(node.key, node);
        return discard;
    }

    public synchronized int size() {
        return this.map.size();
    }

    public synchronized ICacheElement get(String key) {
        CacheNode node = (CacheNode)this.map.get(key);
        if (node == null) {
            return null;
        }
        this.list.poll(node);
        this.list.push(node);
        return node.obj;
    }

    public synchronized ICacheElement remove(String key) {
        CacheNode node = (CacheNode)this.map.get(key);
        if (node == null) {
            return null;
        }
        this.list.poll(node);
        this.map.remove(node.key);
        return node.obj;
    }

    public Object pushCachedObject(String key, Object obj) {
        CacheedElement e = new CacheedElement(key, obj);
        ICacheElement c = this.push(e);
        if (c instanceof CacheedElement) {
            return ((CacheedElement)c).getCachedObject();
        }
        return c;
    }

    public Object getCachedObject(String key) {
        ICacheElement c = this.get(key);
        if (c instanceof CacheedElement) {
            return ((CacheedElement)c).getCachedObject();
        }
        return c;
    }
}

