/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.service.job.util;

public class Counter {
    private static final int PRECISION = 101;
    private long[] timestamp = new long[101];
    private int[] value = new int[101];
    private long timeunit;
    private int interval;

    public Counter(int interval) {
        if (interval < 5) {
            throw new IllegalArgumentException("interval<5");
        }
        this.interval = interval;
        this.timeunit = (long)interval * 1000L / 101L;
    }

    public void inc(int n) {
        long now = System.currentTimeMillis();
        long ticket = now / this.timeunit;
        int index = (int)(ticket % 101L);
        if (this.timestamp[index] == ticket) {
            int n2 = index;
            this.value[n2] = this.value[n2] + n;
        } else {
            this.timestamp[index] = ticket;
            this.value[index] = n;
        }
    }

    public int get() {
        long end = System.currentTimeMillis() / this.timeunit;
        long start = end - 101L;
        int count = 0;
        for (int i = 0; i < 101; ++i) {
            long t = this.timestamp[i];
            if (t <= start || t >= end) continue;
            count += this.value[i];
        }
        return count;
    }

    public int getInterval() {
        return this.interval;
    }
}

