/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.service.job.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.service.job.core.ClusterStateManager;
import com.kingdee.bos.service.job.util.Cache;
import com.kingdee.bos.service.job.util.DbConnector;
import com.kingdee.bos.service.job.util.ICacheElement;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.util.PropertyContainer;
import java.lang.reflect.Method;
import java.util.Locale;

public class Ctx {
    private static final Cache cache = new Cache(60 * DbConnector.getDataCenters().length);
    public static final String ADMINISTRATOR_USER_ID = "00000000-0000-0000-0000-00000000000013B7DE7F";

    public static Context getDefaultContext(String datacenter) throws BOSException {
        return Ctx.getContext(datacenter, ADMINISTRATOR_USER_ID, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Context getContext(String datacenter, String userid, String orgid, String clientIP) throws BOSException {
        String key;
        ContextWrapper wrapper;
        if (userid == null || userid.trim().length() == 0) {
            userid = ADMINISTRATOR_USER_ID;
        }
        if ((wrapper = (ContextWrapper)cache.get(key = Ctx.genKey(datacenter, userid, orgid))) == null) {
            Cache cache = Ctx.cache;
            synchronized (cache) {
                wrapper = (ContextWrapper)Ctx.cache.get(key);
                if (wrapper == null) {
                    Context ctx = Ctx.generateContext(datacenter, userid, orgid, clientIP);
                    wrapper = new ContextWrapper(key, ctx);
                    Ctx.cache.push(wrapper);
                }
            }
        }
        return wrapper.ctx;
    }

    private static String genKey(String datacenter, String userid, String orgid) {
        return userid + "|" + orgid + "|" + datacenter;
    }

    public static Context generateContext(String datacenter, String userid, String orgid, String clientIP) throws BOSException {
        Context ctx = new Context((IObjectPK)new ObjectUuidPK(userid), DbConnector.getSolution(), datacenter, new Locale("l2"));
        ctx.setClientHostIP(clientIP);
        try {
            Class<?> contextUtilsClass = Class.forName("com.kingdee.bos.workflow.util.ScheduleContextUtil");
            Method method = contextUtilsClass.getMethod("loadUserContext", Context.class, String.class);
            ctx = (Context)method.invoke(contextUtilsClass, ctx, orgid);
            return ctx;
        }
        catch (Exception e) {
            try {
                ClusterStateManager cm = ClusterStateManager.get(datacenter);
                cm.pauseUntilRefresh();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw new BOSException("generate context failed for datacenter{" + datacenter + "}, userid='" + userid + "'!", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Context getShadowContext(String datacenter) {
        ContextWrapper wrapper = (ContextWrapper)cache.get(datacenter);
        if (wrapper == null) {
            Cache cache = Ctx.cache;
            synchronized (cache) {
                wrapper = (ContextWrapper)Ctx.cache.get(datacenter);
                if (wrapper == null) {
                    Context ctx = Ctx.newShadowContext(datacenter);
                    wrapper = new ContextWrapper(datacenter, ctx);
                    Ctx.cache.push(wrapper);
                }
            }
        }
        return wrapper.ctx;
    }

    public static Context newShadowContext(String datacenter) {
        return Ctx.newShadowContext(datacenter, ADMINISTRATOR_USER_ID);
    }

    public static Context newShadowContext(String datacenter, String userId) {
        return Ctx.newShadowContext(DbConnector.getSolution(), datacenter, userId);
    }

    public static Context newShadowContext(String solution, String datacenter, String userId) {
        if (userId == null || userId.trim().length() == 0) {
            userId = ADMINISTRATOR_USER_ID;
        }
        Context ctx = new Context((IObjectPK)new ObjectUuidPK(userId), solution, datacenter, new Locale("l2"));
        try {
            Class<?> clazz = Class.forName("com.kingdee.eas.base.permission.UserInfo");
            PropertyContainer pc = (PropertyContainer)clazz.newInstance();
            pc.put("id", (Object)BOSUuid.read((String)userId));
            ctx.put((Object)"UserInfo", (Object)pc);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return ctx;
    }

    public static Context toShadowContext(Context ctx) {
        return Ctx.getShadowContext(ctx.getAIS());
    }

    public static Context toDispatchShadowContext(Context ctx) {
        return Ctx.getShadowContextForLocal(ctx.getAIS(), ctx.getLocale().getLanguage());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Context getShadowContextForLocal(String datacenter, String Language) {
        String key = datacenter + "|" + Language;
        ContextWrapper wrapper = (ContextWrapper)cache.get(key);
        if (wrapper == null) {
            Cache cache = Ctx.cache;
            synchronized (cache) {
                wrapper = (ContextWrapper)Ctx.cache.get(key);
                if (wrapper == null) {
                    Context ctx = Ctx.newShadowContext(datacenter);
                    ctx.setLocale(new Locale(Language));
                    wrapper = new ContextWrapper(key, ctx);
                    Ctx.cache.push(wrapper);
                }
            }
        }
        return wrapper.ctx;
    }

    public static int cacheSize() {
        return cache.size();
    }

    private static class ContextWrapper
    implements ICacheElement {
        private final String key;
        final Context ctx;

        ContextWrapper(String key, Context ctx) {
            this.ctx = ctx;
            this.key = key;
        }

        @Override
        public String getKey() {
            return this.key;
        }
    }
}

