/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.service.job.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.service.job.core.ClusterStateManager;
import com.kingdee.bos.service.job.util.Ctx;
import com.kingdee.bos.service.scheduler.util.SchedulerUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;

public class DbConnector {
    private static Logger log = Logger.getLogger((String)DbConnector.class.getName());
    private static final List<DataCenterChangedListener> listeners = new ArrayList<DataCenterChangedListener>(2);
    private static String solution;
    private static final HashMap<String, DbConnector> connectors;
    private final String datacenter;

    public static String getSolution() {
        return solution;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DbConnector getDbConnector(String datacenter) {
        DbConnector cn;
        boolean isAddnew = false;
        HashMap<String, DbConnector> hashMap = connectors;
        synchronized (hashMap) {
            cn = connectors.get(datacenter);
            if (cn == null) {
                isAddnew = true;
                cn = new DbConnector(datacenter);
                connectors.put(datacenter, cn);
            }
        }
        if (isAddnew) {
            for (DataCenterChangedListener l : listeners) {
                l.onAddnew(datacenter);
            }
        }
        return cn;
    }

    public static Connection getConnection(String datacenter) throws BOSException {
        return DbConnector.getDbConnector(datacenter).getConnection();
    }

    public static String[] getDataCenters() {
        return connectors.keySet().toArray(new String[0]);
    }

    public static int dcCount() {
        return connectors.size();
    }

    public static void init() {
        String[][] aisInfo = SchedulerUtils.getDataCenterInfos();
        if (aisInfo == null) {
            return;
        }
        for (int i = 0; i < aisInfo.length; ++i) {
            solution = aisInfo[i][6];
            String jndiUrl = aisInfo[i][2];
            if (jndiUrl == null) {
                jndiUrl = "jdbc/" + aisInfo[i][0];
            }
            if (jndiUrl.endsWith("_Query")) continue;
            DbConnector.getDbConnector(aisInfo[i][0]);
        }
        log.debug((Object)"scheduler init jndiconnector finished!");
    }

    private DbConnector(String datacenter) {
        this.datacenter = datacenter;
    }

    public Connection getConnection() throws BOSException {
        Context ctx = Ctx.getShadowContext(this.datacenter);
        return DbConnector.getConnection(ctx);
    }

    public static Connection getConnection(Context ctx) throws BOSException {
        if (ctx == null) {
            throw new RuntimeException("Context\u4e0d\u53ef\u4e3a\u7a7a\uff01");
        }
        try {
            return EJBFactory.getConnection((Context)ctx);
        }
        catch (SQLException e) {
            try {
                ClusterStateManager cm = ClusterStateManager.get(ctx);
                cm.pauseUntilRefresh();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new BOSException("get connection for {" + ctx.getAIS() + "} failed!", (Throwable)e);
        }
    }

    public static void registerDataCenterChangedListener(DataCenterChangedListener l) {
        listeners.add(l);
    }

    static {
        connectors = new HashMap(4);
    }

    public static interface DataCenterChangedListener {
        public void onAddnew(String var1);
    }
}

