/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.service.job.util;

import com.kingdee.bos.service.job.util.DoubleLinkedNode;

public class DoubleLinkedList {
    private DoubleLinkedNode m_header;
    private int m_size;

    public DoubleLinkedList(DoubleLinkedNode header) {
        this.init(header);
    }

    private void init(DoubleLinkedNode header) {
        this.m_header = header;
        this.m_size = 0;
        this.m_header.next = this.m_header.prior = this.m_header;
    }

    public int size() {
        return this.m_size;
    }

    public DoubleLinkedNode header() {
        return this.m_header;
    }

    public void clear() {
        this.m_header.prior.next = null;
        DoubleLinkedNode p = this.m_header.next;
        while (p != null) {
            DoubleLinkedNode q = p.next;
            p.next = null;
            p.prior = null;
            p = q;
        }
        this.init(this.m_header);
    }

    public void push(DoubleLinkedNode node) {
        node.next = this.m_header;
        node.prior = this.m_header.prior;
        this.m_header.prior.next = node;
        this.m_header.prior = node;
        ++this.m_size;
    }

    public DoubleLinkedNode poll() {
        if (this.m_size == 0) {
            return null;
        }
        return this.poll(this.m_header.next);
    }

    public DoubleLinkedNode poll(DoubleLinkedNode node) {
        node.next.prior = node.prior;
        node.prior.next = node.next;
        node.prior = null;
        node.next = null;
        --this.m_size;
        return node;
    }

    public DoubleLinkedNode peak() {
        if (this.m_size == 0) {
            return null;
        }
        return this.m_header.next;
    }
}

