/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.service.job.wrapper;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.service.job.core.IJobHandler;
import com.kingdee.bos.service.job.core.Job;
import com.kingdee.bos.service.job.core.JobLog;
import com.kingdee.bos.service.job.core.Wrapper;
import com.kingdee.bos.service.job.util.IListener;
import com.kingdee.bos.service.job.util.SQL;
import com.kingdee.bos.service.job.util.Xml;
import com.kingdee.bos.service.message.Message;
import com.kingdee.bos.service.message.agent.MessageFactory;
import com.kingdee.bos.service.message.agent.MessageSender;
import com.kingdee.bos.service.message.agent.Sender;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MessageSenderWrapper
extends Wrapper
implements IListener,
IJobHandler {
    private static final long serialVersionUID = -3566296756037713860L;
    private static Logger logger = Logger.getLogger((String)MessageSenderWrapper.class.getName());
    private MessageReceiver[] receivers;
    private MessageTemplate[] templates;
    private boolean sendMail;
    private boolean sendSMS;

    public MessageSenderWrapper(MessageReceiver[] receivers, MessageTemplate[] templates, boolean sendMail, boolean sendSMS) {
        this(receivers, templates);
        this.sendMail = sendMail;
        this.sendSMS = sendSMS;
    }

    public MessageSenderWrapper(MessageReceiver[] receivers, MessageTemplate[] templates) {
        this.receivers = receivers;
        this.templates = templates;
    }

    MessageSenderWrapper(String xml) throws BOSException {
        Document doc = Xml.parse(xml);
        this.receivers = MessageReceiver.parse(doc);
        this.templates = MessageTemplate.parse(doc);
        this.sendMail = false;
        this.sendSMS = false;
        NamedNodeMap map = doc.getElementsByTagName("doc").item(0).getAttributes();
        if (map != null) {
            Node node = map.getNamedItem("sendMail");
            if (node != null) {
                this.sendMail = "true".equals(node.getNodeValue());
            }
            if ((node = map.getNamedItem("sendSMS")) != null) {
                this.sendSMS = "true".equals(node.getNodeValue());
            }
        }
    }

    @Override
    public IJobHandler toHandler() {
        return this;
    }

    @Override
    public IListener toListener() {
        return this;
    }

    @Override
    public String toString() {
        return "message:<doc sendMail='" + this.sendMail + "' sendSMS='" + this.sendSMS + "'>" + MessageReceiver.toXml(this.receivers) + "\r\n" + MessageTemplate.toXml(this.templates) + "</doc>";
    }

    @Override
    public void handle(Object o) throws Exception {
        Job job = (Job)o;
        this.sendMessage(job, this.getPersonIds());
    }

    private String[] getPersonIds() {
        if (this.receivers == null) {
            return null;
        }
        String[] personIds = new String[this.receivers.length];
        for (int i = 0; i < personIds.length; ++i) {
            personIds[i] = this.receivers[i].personId;
        }
        return personIds;
    }

    @Override
    public Object execute(Job job) throws Exception {
        Object p = job.getParameters();
        String[] personIds = null;
        if (p instanceof String) {
            personIds = new String[]{(String)p};
        } else if (p instanceof String[]) {
            personIds = (String[])p;
        } else if (p != null) {
            throw new IllegalArgumentException("{" + p.getClass().getName() + ":" + p.toString() + "} isn't a valid message receiver parameters.");
        }
        this.sendMessage(job, personIds == null ? this.getPersonIds() : personIds);
        return null;
    }

    private void sendMessage(Job job, String[] receivers) throws Exception {
        String userids = MessageSenderWrapper.getUserIds(job, receivers, true);
        if (userids == null) {
            JobLog m = new JobLog(JobLog.Type.Warn, "has no receivers or receivers has no corresponding users.");
            job.saveMessage(m);
            return;
        }
        Message msg = this.createMessage(job);
        msg.setStringHeader("receiver", userids);
        String title = null;
        for (int i = 0; i < this.templates.length; ++i) {
            MessageTemplate t = this.templates[i];
            String tmp = MessageSenderWrapper.conver(job, t.title);
            if (title == null) {
                title = tmp;
            }
            msg.setLocaleStringHeader("title", tmp, t.locale);
            msg.setLocaleStringHeader("body", MessageSenderWrapper.conver(job, t.body), t.locale);
        }
        Sender sender = MessageSender.getInstance();
        sender.sendMessage(msg);
        JobLog log = new JobLog(JobLog.Type.Info, "\u53d1\u9001\u901a\u77e5\uff0c\u6807\u9898\uff1a" + title + "  \u5177\u4f53\u63a5\u6536\u4eba\u8bf7\u67e5\u770b\u65e5\u5fd7");
        job.saveMessage(log);
        logger.error((Object)("\u53d1\u9001\u901a\u77e5\uff0c\u6807\u9898\uff1a" + title + "  \u63a5\u6536\u4eba\uff1a" + userids));
        if (this.sendMail || this.sendSMS) {
            String tmp;
            MessageTemplate t;
            userids = MessageSenderWrapper.getUserIds(job, receivers, false);
            if (this.sendMail) {
                msg = this.createMessage(job);
                for (int i = 0; i < this.templates.length; ++i) {
                    t = this.templates[i];
                    tmp = MessageSenderWrapper.conver(job, t.title);
                    if (title == null) {
                        title = tmp;
                    }
                    msg.setLocaleStringHeader("title", tmp, t.locale);
                    msg.setLocaleStringHeader("body", MessageSenderWrapper.conver(job, t.body), t.locale);
                }
                msg.setStringHeader("receiver", userids);
                msg.setBooleanHeader("isSendEmail", true);
                msg.setBooleanHeader("isSendMobile", false);
                msg.setBooleanHeader("isSendCommon", false);
                sender.sendMessage(msg);
                log = new JobLog(JobLog.Type.Info, "\u53d1\u9001\u90ae\u4ef6\uff0c\u6807\u9898\uff1a" + title + "  \u63a5\u6536\u4eba\uff1a" + userids);
                job.saveMessage(log);
            }
            if (this.sendSMS) {
                msg = this.createMessage(job);
                for (int i = 0; i < this.templates.length; ++i) {
                    t = this.templates[i];
                    tmp = MessageSenderWrapper.conver(job, t.title);
                    if (title == null) {
                        title = tmp;
                    }
                    msg.setLocaleStringHeader("title", tmp, t.locale);
                    msg.setLocaleStringHeader("body", MessageSenderWrapper.conver(job, t.body), t.locale);
                }
                msg.setStringHeader("receiver", userids);
                msg.setBooleanHeader("isSendEmail", false);
                msg.setBooleanHeader("isSendMobile", true);
                msg.setBooleanHeader("isSendCommon", false);
                sender.sendMessage(msg);
                log = new JobLog(JobLog.Type.Info, "\u53d1\u9001\u77ed\u4fe1\uff0c\u6807\u9898\uff1a" + title + "  \u63a5\u6536\u4eba\uff1a" + userids);
                job.saveMessage(log);
            }
        }
    }

    private Message createMessage(Job job) {
        Message message = MessageFactory.newMessage();
        message.setIntHeader("type", 0);
        message.setIntHeader("bizType", 50);
        if (job.getStaticPriority() == 0) {
            message.setIntHeader("priority", 20);
        } else if (job.getStaticPriority() == 500) {
            message.setIntHeader("priority", 10);
        } else {
            message.setIntHeader("priority", 0);
        }
        message.setIntHeader("sourceStatus", 0);
        message.setStringHeader("sender", "BgJob");
        message.setLocaleStringHeader("sender", "BgJob", new Locale("l1"));
        message.setLocaleStringHeader("sender", "\u540e\u53f0\u4e8b\u52a1", new Locale("l2"));
        message.setLocaleStringHeader("sender", "\u540e\u81fa\u4e8b\u52d9", new Locale("l3"));
        message.setStringHeader("databaseCenter", job.getContext().getAIS());
        message.setStringHeader("solution", job.getContext().getSolution());
        message.setBooleanHeader("isSendEmail", false);
        message.setBooleanHeader("isSendMobile", false);
        message.setBooleanHeader("isSendCommon", true);
        message.setStringHeader("sourceID", job.getId());
        return message;
    }

    private static String getUserIds(Job job, String[] receivers, boolean all) throws BOSException {
        if (receivers == null || receivers.length == 0) {
            return null;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select fid,fpersonid from t_pm_user where fpersonid in(");
        for (int i = 0; i < receivers.length; ++i) {
            if (i > 0) {
                sql.append(",");
            }
            sql.append("'").append(receivers[i]).append("'");
        }
        sql.append(")");
        ArrayList items = SQL.executeQuery(job.getContext(), sql.toString());
        if (items.size() == 0) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        HashSet<String> set = new HashSet<String>();
        for (int i = 0; i < items.size(); ++i) {
            String s = ((HashMap)items.get(i)).get("fpersonid").toString();
            if (!all && set.contains(s)) continue;
            set.add(s);
            if (i > 0) {
                sb.append(";");
            }
            sb.append(((HashMap)items.get(i)).get("fid"));
        }
        return sb.toString();
    }

    private static String conver(Job job, String template) {
        int j;
        int i;
        StringBuffer sb = new StringBuffer();
        int k = 0;
        while ((i = template.indexOf("<%", k)) >= 0 && (j = template.indexOf("%>", i)) >= 0) {
            if (k == 0) {
                sb.append(template.substring(0, i));
            } else {
                sb.append(template.substring(k, i));
            }
            String field = template.substring(i + 2, j).trim().toLowerCase();
            Object value = MessageSenderWrapper.getField(job, field);
            sb.append(value);
            k = j + 2;
        }
        if (k < template.length()) {
            sb.append(template.substring(k));
        }
        return sb.toString();
    }

    private static Object getField(Job job, String field) {
        if ("Title".equalsIgnoreCase(field)) {
            return job.getTitle();
        }
        if ("Schedule Time".equalsIgnoreCase(field)) {
            return job.getScheduledTime();
        }
        if ("Start Time".equalsIgnoreCase(field)) {
            return job.getStartedTime();
        }
        if ("Created Time".equalsIgnoreCase(field)) {
            return job.getCreatedTime();
        }
        if ("Exception Stack".equalsIgnoreCase(field)) {
            return job.getException();
        }
        if ("Execute server".equalsIgnoreCase(field)) {
            return job.getHolderId();
        }
        if ("State".equalsIgnoreCase(field)) {
            return job.getState().toString();
        }
        if ("Status".equalsIgnoreCase(field)) {
            return job.getState().toString();
        }
        if ("\u6807\u9898".equals(field)) {
            return job.getTitle();
        }
        if ("\u8ba1\u5212\u8c03\u5ea6\u65f6\u95f4".equals(field)) {
            return job.getScheduledTime();
        }
        if ("\u5f00\u59cb\u65f6\u95f4".equals(field)) {
            return job.getStartedTime();
        }
        if ("\u521b\u5efa\u65f6\u95f4".equals(field)) {
            return job.getCreatedTime();
        }
        if ("\u5f02\u5e38\u5806\u6808".equals(field)) {
            return job.getException();
        }
        if ("\u6267\u884c\u670d\u52a1\u5668".equals(field)) {
            return job.getHolderId();
        }
        if ("\u72b6\u6001".equals(field)) {
            return job.getState().getText();
        }
        if ("\u6a19\u984c".equals(field)) {
            return job.getTitle();
        }
        if ("\u8a08\u5283\u8abf\u5ea6\u6642\u9593".equals(field)) {
            return job.getScheduledTime();
        }
        if ("\u958b\u59cb\u6642\u9593".equals(field)) {
            return job.getStartedTime();
        }
        if ("\u5275\u5efa\u6642\u9593".equals(field)) {
            return job.getCreatedTime();
        }
        if ("\u7570\u5e38\u5806\u68e7".equals(field)) {
            return job.getException();
        }
        if ("\u57f7\u884c\u670d\u52d9\u5668".equals(field)) {
            return job.getHolderId();
        }
        if ("\u72c0\u614b".equals(field)) {
            return job.getState().getText();
        }
        return "<%" + field + "%>";
    }

    public static class MessageTemplate
    implements Serializable {
        private static final long serialVersionUID = -1754581176558106817L;
        public Locale locale;
        public String title;
        public String body;

        public MessageTemplate(Locale locale, String title, String body) {
            this.locale = locale;
            this.title = title;
            this.body = body;
        }

        public String toXml() {
            StringBuffer sb = new StringBuffer();
            sb.append("<template");
            sb.append(" locale='").append(Xml.escape(this.locale.toString())).append("'");
            sb.append(" title='").append(Xml.escape(this.title)).append("'");
            sb.append(" body='").append(Xml.escape(this.body)).append("'");
            sb.append("/>");
            return sb.toString();
        }

        public String toString() {
            return this.toXml();
        }

        public static String toXml(MessageTemplate[] templates) {
            if (templates == null || templates.length == 0) {
                return "";
            }
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < templates.length; ++i) {
                sb.append("\r\n\t").append(templates[i].toXml());
            }
            return sb.toString();
        }

        public static MessageTemplate[] parse(Document doc) {
            NodeList list = doc.getElementsByTagName("template");
            MessageTemplate[] templates = new MessageTemplate[list.getLength()];
            for (int i = 0; i < list.getLength(); ++i) {
                Node node = list.item(i);
                NamedNodeMap attributes = node.getAttributes();
                String locale = attributes.getNamedItem("locale").getNodeValue();
                String title = attributes.getNamedItem("title").getNodeValue();
                String body = attributes.getNamedItem("body").getNodeValue();
                templates[i] = new MessageTemplate(new Locale(locale), title, body);
            }
            return templates;
        }
    }

    public static class MessageReceiver
    implements Serializable {
        private static final long serialVersionUID = -8891338503527858601L;
        public String personId;
        public String personName;

        public MessageReceiver(String personId) {
            this(personId, null);
        }

        public MessageReceiver(String personId, String personName) {
            if (personId == null || personId.trim().length() == 0) {
                throw new IllegalArgumentException("person id couldn't be null or empty!");
            }
            this.personId = personId;
            this.personName = personName;
        }

        public String toXml() {
            StringBuffer sb = new StringBuffer();
            sb.append("<receiver");
            sb.append(" personId='").append(Xml.escape(this.personId)).append("'");
            sb.append(" personName='").append(Xml.escape(this.personName)).append("'");
            sb.append("/>");
            return sb.toString();
        }

        public String toString() {
            return this.toXml();
        }

        public static String toXml(MessageReceiver[] receivers) {
            if (receivers == null || receivers.length == 0) {
                return "";
            }
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < receivers.length; ++i) {
                sb.append("\r\n\t").append(receivers[i].toXml());
            }
            return sb.toString();
        }

        public static MessageReceiver[] parse(Document doc) {
            NodeList list = doc.getElementsByTagName("receiver");
            MessageReceiver[] receivers = new MessageReceiver[list.getLength()];
            for (int i = 0; i < list.getLength(); ++i) {
                Node node = list.item(i);
                NamedNodeMap attributes = node.getAttributes();
                String id = attributes.getNamedItem("personId").getNodeValue();
                String name = attributes.getNamedItem("personName").getNodeValue();
                receivers[i] = new MessageReceiver(id, name);
            }
            return receivers;
        }
    }
}

