/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.service.scheduler.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.service.job.util.SQL;
import com.kingdee.bos.service.scheduler.util.IWorkCalendarProvider;
import com.kingdee.eas.util.StringUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class DefaultWorkCalendarProvider
implements IWorkCalendarProvider {
    private static Logger log = Logger.getLogger((String)"com.kingdee.bos.service.scheduler.util.DefaultWorkCalendarProvider");

    @Override
    public boolean isWorkDay(Context ctx, String orgUnitID, Date d, boolean isCastBack) throws BOSException {
        return this.isWorkDay(ctx, orgUnitID, isCastBack, d);
    }

    private Connection getConnection(Context ctx) throws SQLException {
        return EJBFactory.getConnection((Context)ctx);
    }

    public Date getNowWorkDay(Context ctx, String orgId) throws BOSException {
        Date d = DefaultWorkCalendarProvider.getDayBegin();
        d = this.getWorkDay(ctx, orgId, d);
        return d;
    }

    private static Date getDayBegin() {
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    private Date getWorkDay(Context ctx, String orgId, Date d) throws BOSException {
        while (!this.isWorkDay(ctx, orgId, true, d)) {
            d = DefaultWorkCalendarProvider.getNextDay(d);
        }
        return d;
    }

    private static Date getNextDay(Date date) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        cal.set(5, cal.get(5) + 1);
        return cal.getTime();
    }

    private boolean isWorkDay(Context ctx, String orgUnitID, boolean isCastBack, Date d) throws BOSException {
        if (StringUtils.isEmpty((String)orgUnitID) || "null".equalsIgnoreCase(orgUnitID)) {
            String orgId;
            orgUnitID = orgId = "00000000-0000-0000-0000-000000000000CCE7AED4";
        }
        StringBuffer kSql = new StringBuffer();
        if (!isCastBack) {
            return this.isWorkDayNoCastBack(ctx, orgUnitID, d);
        }
        String orgUnitLongNumber = "";
        kSql.setLength(0);
        kSql.append("select FLongNumber from T_Org_Admin where fid = '").append(orgUnitID).append("'");
        ResultSet rs = null;
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            conn = this.getConnection(ctx);
            stmt = this.prepareStatement(kSql, conn);
            rs = stmt.executeQuery();
            if (rs.next()) {
                orgUnitLongNumber = rs.getString("FLongNumber");
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQL.close(rs, stmt, conn);
                throw throwable;
            }
        }
        SQL.close(rs, stmt, conn);
        return this.isWorkDayCastBack(ctx, orgUnitLongNumber, d);
    }

    private PreparedStatement prepareStatement(StringBuffer kSql, Connection conn) throws SQLException {
        return conn.prepareStatement(kSql.toString());
    }

    public boolean isWorkDay(Context ctx, String orgId, Date date) throws BOSException {
        return this.isWorkDay(ctx, orgId, true, date);
    }

    private boolean isWorkDayBySysCalendar(Date d) {
        Calendar cl = Calendar.getInstance();
        cl.setTime(d);
        int value = cl.get(7);
        return value != 7 && value != 1;
    }

    private boolean isWorkDayCastBack(Context ctx, String orgUnitLongNumber, Date d) throws BOSException {
        String workCalendarId;
        PreparedStatement stmt2;
        Connection conn2;
        PreparedStatement stmt;
        Connection conn;
        ResultSet rs2;
        ResultSet rs;
        block9: {
            boolean bl;
            block12: {
                String fid;
                block10: {
                    block11: {
                        if (StringUtils.isEmpty((String)orgUnitLongNumber)) {
                            return this.isWorkDayBySysCalendar(d);
                        }
                        StringBuffer kSql = new StringBuffer();
                        StringTokenizer tokenizer = new StringTokenizer(orgUnitLongNumber, "!", false);
                        StringBuffer allOrgNumbers = new StringBuffer("(");
                        while (tokenizer.hasMoreElements()) {
                            allOrgNumbers.append("'").append(tokenizer.nextToken()).append("',");
                        }
                        allOrgNumbers.deleteCharAt(allOrgNumbers.lastIndexOf(","));
                        allOrgNumbers.append(")");
                        kSql.setLength(0);
                        kSql.append("select top 1 a.fid as fid from T_WorkCalendar a, T_Org_Admin b where a.FOrgUnitID = b.fid and b.fnumber in ").append(allOrgNumbers).append(" order by b.flongnumber desc ");
                        rs = null;
                        rs2 = null;
                        conn = null;
                        stmt = null;
                        conn2 = null;
                        stmt2 = null;
                        workCalendarId = null;
                        conn = this.getConnection(ctx);
                        stmt = this.prepareStatement(kSql, conn);
                        rs = stmt.executeQuery();
                        if (!rs.next()) break block9;
                        workCalendarId = fid = rs.getString("fid");
                        kSql.setLength(0);
                        Calendar cl = Calendar.getInstance();
                        cl.setTime(d);
                        String dStr = cl.get(1) + "-" + (cl.get(2) + 1) + "-" + cl.get(5);
                        kSql.append("select distinct b.FDateType as dateType from T_WorkCalendar a, T_WorkCalendarDayEntry b  ").append(" where a.fid = b.FWorkCanlendarID  and a.fid  ='").append(fid).append("' and year(b.FWorkDate)=year(to_date('").append(dStr).append("'))").append(" and dayofyear(b.FWorkDate) = dayofyear(to_date('").append(dStr).append("'))");
                        conn2 = this.getConnection(ctx);
                        stmt2 = this.prepareStatement(kSql, conn);
                        rs2 = stmt2.executeQuery();
                        if (!rs2.next()) break block9;
                        int value = rs2.getInt("dateType");
                        if (value == 1) break block10;
                        if (value != 4) break block11;
                        workCalendarId = rs.getString("fid");
                        boolean bl2 = this.isWorkTimeForWorkCalendarId(ctx, workCalendarId, d, false, 4);
                        SQL.close(rs, stmt, conn);
                        SQL.close(rs2, stmt2, conn2);
                        return bl2;
                    }
                    boolean bl3 = false;
                    SQL.close(rs, stmt, conn);
                    SQL.close(rs2, stmt2, conn2);
                    return bl3;
                }
                boolean isWorkTime = this.isWorkTimeForWorkCalendarId(ctx, fid, d, false, 1);
                if (isWorkTime) break block12;
                boolean bl4 = false;
                SQL.close(rs, stmt, conn);
                SQL.close(rs2, stmt2, conn2);
                return bl4;
            }
            try {
                bl = true;
            }
            catch (SQLException e) {
                try {
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    SQL.close(rs, stmt, conn);
                    SQL.close(rs2, stmt2, conn2);
                    throw throwable;
                }
            }
            SQL.close(rs, stmt, conn);
            SQL.close(rs2, stmt2, conn2);
            return bl;
        }
        SQL.close(rs, stmt, conn);
        SQL.close(rs2, stmt2, conn2);
        return this.isWorkTimeForWorkCalendarId(ctx, workCalendarId, d, true, 1);
    }

    private boolean isWorkDayNoCastBack(Context ctx, String orgUnitID, Date d) throws BOSException {
        PreparedStatement stmt;
        Connection conn;
        ResultSet rs;
        String workCalendarId;
        block9: {
            block12: {
                block10: {
                    block11: {
                        workCalendarId = null;
                        Calendar cl = Calendar.getInstance();
                        cl.setTime(d);
                        String dStr = cl.get(1) + "-" + (cl.get(2) + 1) + "-" + cl.get(5);
                        StringBuffer kSql = new StringBuffer();
                        kSql.append("select distinct b.FDateType as dateType,a.fid as fid from T_WorkCalendar a, T_WorkCalendarDayEntry b ").append(" where a.fid = b.FWorkCanlendarID  and a.FOrgUnitID ='").append(orgUnitID).append("' and year(b.FWorkDate)=year(to_date('").append(dStr).append("'))").append(" and dayofyear(b.FWorkDate) = dayofyear(to_date('").append(dStr).append("'))");
                        rs = null;
                        conn = null;
                        stmt = null;
                        conn = this.getConnection(ctx);
                        stmt = this.prepareStatement(kSql, conn);
                        rs = stmt.executeQuery();
                        if (!rs.next()) break block9;
                        int value = rs.getInt("dateType");
                        if (value == 1) break block10;
                        if (value != 4) break block11;
                        workCalendarId = rs.getString("fid");
                        boolean bl = this.isWorkTimeForWorkCalendarId(ctx, workCalendarId, d, false, 4);
                        SQL.close(rs);
                        SQL.close((Statement)stmt);
                        SQL.close(conn);
                        return bl;
                    }
                    boolean bl = false;
                    SQL.close(rs);
                    SQL.close((Statement)stmt);
                    SQL.close(conn);
                    return bl;
                }
                workCalendarId = rs.getString("fid");
                boolean isWorkTime = this.isWorkTimeForWorkCalendarId(ctx, workCalendarId, d, false, 1);
                if (isWorkTime) break block12;
                boolean bl = false;
                SQL.close(rs);
                SQL.close((Statement)stmt);
                SQL.close(conn);
                return bl;
            }
            boolean bl = true;
            SQL.close(rs);
            SQL.close((Statement)stmt);
            SQL.close(conn);
            return bl;
        }
        try {
            StringBuffer sql = new StringBuffer();
            sql.append("select a.fid from T_WorkCalendar a ");
            sql.append(" where a.FOrgUnitID = ? ");
            IRowSet tIRowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{orgUnitID});
            if (tIRowSet.next()) {
                workCalendarId = tIRowSet.getString(1);
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQL.close(rs);
                SQL.close(stmt);
                SQL.close(conn);
                throw throwable;
            }
        }
        SQL.close(rs);
        SQL.close((Statement)stmt);
        SQL.close(conn);
        return this.isWorkTimeForWorkCalendarId(ctx, workCalendarId, d, true, 1);
    }

    public boolean isWorkTimeForWorkCalendarId(Context ctx, String workCalendarId, Date date, boolean idDefaultweekend, int workType) {
        if (StringUtils.isEmpty((String)workCalendarId)) {
            return true;
        }
        Calendar currentDate = Calendar.getInstance();
        currentDate.setTime(date);
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("HH:mm");
            int currentHour = currentDate.get(11);
            int currentMinute = currentDate.get(12);
            Date currentTime = sdf.parse(String.valueOf(currentHour + ":" + currentMinute));
            String beginTimeAM = null;
            String endTimeAM = null;
            String beginTimePM = null;
            String endTimePM = null;
            String defaultweekend = null;
            StringBuffer sb = new StringBuffer();
            sb.append("select a.fbegintimeam,a.fendtimeam,a.fbegintimepm,a.fendtimepm ,a.fdefaultweekend from T_WorkCalendar a ");
            sb.append(" where a.fid = ? ");
            IRowSet tIRowSet = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])new Object[]{workCalendarId});
            if (tIRowSet.next()) {
                beginTimeAM = tIRowSet.getString(1);
                endTimeAM = tIRowSet.getString(2);
                beginTimePM = tIRowSet.getString(3);
                endTimePM = tIRowSet.getString(4);
                defaultweekend = tIRowSet.getString(5);
            }
            if (beginTimeAM == null || endTimeAM == null || beginTimePM == null || endTimePM == null) {
                log.error((Object)"-----query----T_WorkCalendar---error---");
                return true;
            }
            if (idDefaultweekend) {
                int value = currentDate.get(7);
                if (defaultweekend == null) {
                    return true;
                }
                if (defaultweekend.indexOf(String.valueOf(value)) > -1) {
                    return false;
                }
            }
            String[] valuesBA = StringUtil.split((String)beginTimeAM, (String)"-");
            Date bTimeAM = sdf.parse(String.valueOf(valuesBA[0] + ":" + valuesBA[1]));
            String[] valuesEA = StringUtil.split((String)endTimeAM, (String)"-");
            Date eTimeAM = sdf.parse(String.valueOf(valuesEA[0] + ":" + valuesEA[1]));
            String[] valuesBP = StringUtil.split((String)beginTimePM, (String)"-");
            Date bTimePM = sdf.parse(String.valueOf(valuesBP[0] + ":" + valuesBP[1]));
            String[] valuesEP = StringUtil.split((String)endTimePM, (String)"-");
            Date eTimePM = sdf.parse(String.valueOf(valuesEP[0] + ":" + valuesEP[1]));
            if ((currentTime.equals(bTimeAM) || currentTime.after(bTimeAM)) && (currentTime.equals(eTimeAM) || currentTime.before(eTimeAM))) {
                return true;
            }
            return !(!currentTime.equals(bTimePM) && !currentTime.after(bTimePM) || !currentTime.equals(eTimePM) && !currentTime.before(eTimePM) || workType == 4);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return true;
    }
}

