/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.service.scheduler.util;

import com.kingdee.bos.Context;
import com.kingdee.bos.service.scheduler.util.DefaultWorkCalendar;
import com.kingdee.bos.service.scheduler.util.IWorkCalendar;
import com.kingdee.bos.service.scheduler.util.TimeSpan;
import com.kingdee.bos.service.scheduler.util.WorkCalendarSchema;
import com.kingdee.bos.spi.SPManager;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class WorkCalendarUtil {
    public static final int HOLIDAY_MAX_DAYS = 90;
    private static volatile IWorkCalendar calendar;

    public static IWorkCalendar getWorkCalendar() {
        if (calendar != null) {
            return calendar;
        }
        Object o = SPManager.getInstance().getSeviceProviderInstance("NewWorkCalendar");
        calendar = o instanceof IWorkCalendar ? (IWorkCalendar)o : new DefaultWorkCalendar();
        return calendar;
    }

    public static Date nextOffTime(Context ctx, IWorkCalendar proxy, String orgId, Date when) throws Exception {
        TimeSpan[] spans = proxy.getWorkingTimes(ctx, orgId, when);
        if (spans.length == 0) {
            return when;
        }
        if (when.before(spans[0].getFrom())) {
            return when;
        }
        Date found = when;
        for (TimeSpan span : spans) {
            Date ubound = span.getTo();
            if (span.getFrom().after(when) || ubound.before(when) || !found.before(ubound)) continue;
            found = ubound;
        }
        return found;
    }

    public static Date nextWorkingTime(Context ctx, IWorkCalendar proxy, String orgId, Date when) throws Exception {
        Date current = when;
        Calendar calendar = Calendar.getInstance();
        int holiday_count = 0;
        while (true) {
            TimeSpan[] spans = proxy.getWorkingTimes(ctx, orgId, current);
            holiday_count = WorkCalendarUtil.checkHoliday(current, holiday_count, spans);
            Date time = WorkCalendarUtil.getWorkingTime(when, spans);
            if (time != null) {
                return time;
            }
            current = WorkCalendarUtil.getNextDay(current, calendar);
        }
    }

    public static Date timeAdd(Context ctx, IWorkCalendar proxy, String orgId, Date time, long interval) throws Exception {
        Date offTime = time;
        if (interval < 0L) {
            throw new IllegalArgumentException("\u589e\u52a0\u7684\u65f6\u95f4\u8de8\u5ea6\u5c0f\u4e8e\uff10.");
        }
        Date workingTime;
        long used;
        while ((used = (offTime = WorkCalendarUtil.nextOffTime(ctx, proxy, orgId, workingTime = WorkCalendarUtil.nextWorkingTime(ctx, proxy, orgId, offTime))).getTime() - workingTime.getTime()) < interval) {
            interval -= used;
        }
        return new Date(workingTime.getTime() + interval);
    }

    public static Date timeAdd(Context ctx, String orgId, Date time, int year, int month, int day, int hour, int minute, int second) throws Exception {
        Calendar c = Calendar.getInstance();
        c.setTime(time);
        c.add(1, year);
        c.add(2, month);
        WorkCalendarSchema schema = WorkCalendarUtil.getWorkCalendar().getWorkCalendarSchema(ctx, orgId);
        long milliseconds = schema.getWorkTime() * (long)day + (long)((hour * 3600 + minute * 60 + second) * 1000);
        return WorkCalendarUtil.timeAdd(ctx, WorkCalendarUtil.getWorkCalendar(), orgId, c.getTime(), milliseconds);
    }

    public static Date timeAdd(Context ctx, String orgId, Date time, long interval) throws Exception {
        return WorkCalendarUtil.timeAdd(ctx, WorkCalendarUtil.getWorkCalendar(), orgId, time, interval);
    }

    public static long timeSpan(Context ctx, IWorkCalendar proxy, String orgId, Date from, Date to) throws Exception {
        Date workTime;
        if (from.after(to)) {
            throw new IllegalArgumentException("\u7ed3\u675f\u65f6\u95f4\u65e9\u4e8e\u5f00\u59cb\u65f6\u95f4\uff01");
        }
        long count = 0L;
        Date offTime = from;
        while ((offTime = WorkCalendarUtil.nextOffTime(ctx, proxy, orgId, workTime = WorkCalendarUtil.nextWorkingTime(ctx, proxy, orgId, offTime))).before(to)) {
            count += offTime.getTime() - workTime.getTime();
        }
        return count += to.getTime() - workTime.getTime();
    }

    private static Date getNextDay(Date current, Calendar calendar) {
        calendar.setTime(current);
        calendar.add(5, 1);
        current = calendar.getTime();
        return current;
    }

    private static Date getWorkingTime(Date when, TimeSpan[] spans) {
        Date time = null;
        for (TimeSpan span : spans) {
            Date from = span.getFrom();
            Date to = span.getTo();
            if (!from.before(when)) {
                time = from;
                break;
            }
            if (!to.after(when)) continue;
            time = when;
            break;
        }
        return time;
    }

    private static int checkHoliday(Date when, int holiday_count, TimeSpan[] spans) {
        int n = holiday_count = spans.length > 0 ? 0 : holiday_count + 1;
        if (holiday_count > 90) {
            String date = new SimpleDateFormat().format(when);
            throw new RuntimeException("{" + date + "}\u4e4b\u540e\u7684\u65e5\u5386\u672a\u5b9a\u4e49\uff01");
        }
        return holiday_count;
    }
}

