/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.support.quartz;

import com.kingdee.bos.framework.config.AISChangedEvent;
import com.kingdee.bos.framework.config.AISDeployInfo;
import com.kingdee.bos.framework.config.ConfigurationChangedListener;
import com.kingdee.bos.framework.config.ConfigurationEvent;
import com.kingdee.bos.framework.config.SolutionDeployInfo;
import com.kingdee.bos.service.scheduler.IORMScheduler;
import com.kingdee.bos.service.scheduler.MultiSchedulerFactory1;
import com.kingdee.bos.service.scheduler.ORMScheduler;
import com.kingdee.bos.service.scheduler.util.SchedulerUtils;
import org.apache.log4j.Logger;
import org.quartz.SchedulerException;

public class AISChangedListener
implements ConfigurationChangedListener {
    private static Logger logger = Logger.getLogger(AISChangedListener.class);

    public void valueChanged(ConfigurationEvent e) {
        if (!SchedulerUtils.isEnableScheduler()) {
            return;
        }
        if (e == null) {
            throw new IllegalArgumentException();
        }
        if (!(e instanceof AISChangedEvent)) {
            return;
        }
        AISChangedEvent aisChangedEvent = (AISChangedEvent)e;
        SolutionDeployInfo solutionDeployInfo = aisChangedEvent.getSolutionDeployInfo();
        if (solutionDeployInfo == null) {
            throw new IllegalArgumentException();
        }
        String solutionName = solutionDeployInfo.getName();
        AISDeployInfo aisDeployInfo = aisChangedEvent.getAisDeployInfo();
        if (aisDeployInfo == null) {
            throw new IllegalArgumentException();
        }
        String aisName = aisDeployInfo.getName();
        int type = aisChangedEvent.getType();
        if (AISChangedEvent.ADD == type) {
            MultiSchedulerFactory1 factory = MultiSchedulerFactory1.getInstance();
            factory.createScheduler(aisName, solutionName);
        } else if (AISChangedEvent.DELETE == type) {
            try {
                IORMScheduler scheduler = ORMScheduler.getInstance(aisName, solutionName);
                if (scheduler == null) {
                    return;
                }
                scheduler.shutdown(false);
            }
            catch (SchedulerException exception) {
                logger.error((Object)exception);
            }
        }
        logger.info((Object)("AISChangedListener:" + solutionName + ":" + aisName + ":" + type));
    }
}

