/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.support.quartz;

import com.kingdee.bos.framework.config.AISChangedEvent;
import com.kingdee.bos.framework.config.AISChangedListener;
import com.kingdee.bos.framework.config.AISDeployInfo;
import com.kingdee.bos.framework.config.SolutionDeployInfo;
import com.kingdee.bos.service.scheduler.IORMScheduler;
import com.kingdee.bos.service.scheduler.MultiSchedulerFactory1;
import com.kingdee.bos.service.scheduler.ORMScheduler;
import com.kingdee.bos.service.scheduler.util.SchedulerUtils;
import org.apache.log4j.Logger;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.impl.SchedulerRepository;

public class SchedulerAISChangedListener
implements AISChangedListener {
    private static Logger logger = Logger.getLogger(SchedulerAISChangedListener.class);

    public void valueChanged(AISChangedEvent e) {
        if (!SchedulerUtils.isEnableScheduler()) {
            return;
        }
        if (e == null) {
            throw new IllegalArgumentException();
        }
        SolutionDeployInfo solutionDeployInfo = e.getSolutionDeployInfo();
        if (solutionDeployInfo == null) {
            throw new IllegalArgumentException();
        }
        String solutionName = solutionDeployInfo.getName();
        AISDeployInfo aisDeployInfo = e.getAisDeployInfo();
        if (aisDeployInfo == null) {
            throw new IllegalArgumentException();
        }
        String aisName = aisDeployInfo.getName();
        int type = e.getType();
        if (AISChangedEvent.ADD == type) {
            MultiSchedulerFactory1 factory = MultiSchedulerFactory1.getInstance();
            factory.createScheduler(aisName, solutionName);
            try {
                IORMScheduler scheduler = ORMScheduler.getInstance(aisName, solutionName);
                if (scheduler != null) {
                    scheduler.start();
                }
            }
            catch (SchedulerException exception) {
                logger.error((Object)exception);
            }
        } else if (AISChangedEvent.DELETE == type) {
            try {
                SchedulerRepository repository = SchedulerRepository.getInstance();
                String schedulerKey = SchedulerUtils.getSchedulerKey(aisName, solutionName);
                Scheduler scheduler = repository.lookup(schedulerKey);
                if (scheduler == null) {
                    return;
                }
                scheduler.shutdown(false);
            }
            catch (SchedulerException exception) {
                logger.error((Object)exception);
            }
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("SchedulerAISChangedListener:");
        buffer.append(solutionName);
        buffer.append(":");
        buffer.append(aisName);
        buffer.append(":");
        buffer.append(type);
        String message = buffer.toString();
        logger.info((Object)message);
    }
}

