/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.support.quartz;

import com.kingdee.bos.framework.config.AISDeployInfo;
import com.kingdee.bos.framework.config.SolutionChangedEvent;
import com.kingdee.bos.framework.config.SolutionChangedListener;
import com.kingdee.bos.framework.config.SolutionDeployInfo;
import com.kingdee.bos.service.scheduler.IORMScheduler;
import com.kingdee.bos.service.scheduler.MultiSchedulerFactory1;
import com.kingdee.bos.service.scheduler.ORMScheduler;
import com.kingdee.bos.service.scheduler.util.SchedulerUtils;
import java.util.List;
import org.apache.log4j.Logger;
import org.quartz.SchedulerException;

public class SchedulerSolutionChangedListener
implements SolutionChangedListener {
    private static Logger logger = Logger.getLogger(SchedulerSolutionChangedListener.class);

    public void valueChanged(SolutionChangedEvent e) {
        List aisList;
        if (!SchedulerUtils.isEnableScheduler()) {
            return;
        }
        if (e == null) {
            throw new IllegalArgumentException();
        }
        SolutionDeployInfo solutionDeployInfo = e.getSolutionDeployInfo();
        if (solutionDeployInfo == null) {
            throw new IllegalArgumentException();
        }
        String solutionName = solutionDeployInfo.getName();
        int type = e.getType();
        if (SolutionChangedEvent.ADD == type) {
            aisList = solutionDeployInfo.getAISInfos();
            for (AISDeployInfo ais : aisList) {
                String aisName = ais.getName();
                MultiSchedulerFactory1 factory = MultiSchedulerFactory1.getInstance();
                factory.createScheduler(aisName, solutionName);
            }
        } else if (SolutionChangedEvent.DELETE == type) {
            aisList = solutionDeployInfo.getAISInfos();
            for (AISDeployInfo ais : aisList) {
                String aisName = ais.getName();
                this.shutdown(solutionName, aisName);
            }
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("SchedulerSolutionChangedListener:");
        buffer.append(solutionName);
        buffer.append(":");
        buffer.append(type);
        String message = buffer.toString();
        logger.info((Object)message);
    }

    private void shutdown(String solution, String ais) {
        try {
            IORMScheduler scheduler = ORMScheduler.getInstance(ais, solution);
            if (scheduler == null) {
                return;
            }
            scheduler.shutdown(false);
        }
        catch (SchedulerException exception) {
            logger.error((Object)exception);
        }
    }
}

