/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.support.quartz;

import com.kingdee.bos.framework.config.AISDeployInfo;
import com.kingdee.bos.framework.config.ConfigurationChangedListener;
import com.kingdee.bos.framework.config.ConfigurationEvent;
import com.kingdee.bos.framework.config.SolutionChangedEvent;
import com.kingdee.bos.framework.config.SolutionDeployInfo;
import com.kingdee.bos.service.scheduler.IORMScheduler;
import com.kingdee.bos.service.scheduler.MultiSchedulerFactory1;
import com.kingdee.bos.service.scheduler.ORMScheduler;
import com.kingdee.bos.service.scheduler.util.SchedulerUtils;
import java.util.List;
import org.apache.log4j.Logger;
import org.quartz.SchedulerException;

public class SolutionChangedListener
implements ConfigurationChangedListener {
    private static Logger logger = Logger.getLogger(SolutionChangedListener.class);

    public void valueChanged(ConfigurationEvent e) {
        if (!SchedulerUtils.isEnableScheduler()) {
            return;
        }
        if (e == null) {
            throw new IllegalArgumentException();
        }
        if (!(e instanceof SolutionChangedEvent)) {
            return;
        }
        SolutionChangedEvent solutionChangedEvent = (SolutionChangedEvent)e;
        SolutionDeployInfo solutionDeployInfo = solutionChangedEvent.getSolutionDeployInfo();
        if (solutionDeployInfo == null) {
            throw new IllegalArgumentException();
        }
        String solutionName = solutionDeployInfo.getName();
        int type = solutionChangedEvent.getType();
        if (SolutionChangedEvent.ADD == type) {
            List aisList = solutionDeployInfo.getAISInfos();
            for (AISDeployInfo ais : aisList) {
                String aisName = ais.getName();
                MultiSchedulerFactory1 factory = MultiSchedulerFactory1.getInstance();
                factory.createScheduler(aisName, solutionName);
            }
        } else if (SolutionChangedEvent.DELETE == type) {
            List aisList = solutionDeployInfo.getAISInfos();
            for (AISDeployInfo ais : aisList) {
                String aisName = ais.getName();
                this.shutdown(solutionName, aisName);
            }
        }
        logger.info((Object)("SolutionChangedListener:" + solutionName));
    }

    private void shutdown(String solution, String ais) {
        try {
            IORMScheduler scheduler = ORMScheduler.getInstance(ais, solution);
            if (scheduler == null) {
                return;
            }
            scheduler.shutdown(false);
        }
        catch (SchedulerException exception) {
            logger.error((Object)exception);
        }
    }
}

