/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.support.quartz.impl;

import com.kingdee.bos.support.quartz.impl.JobStoreHelper;
import com.kingdee.bos.support.quartz.impl.JobWrapper;
import com.kingdee.bos.support.quartz.impl.TriggerWrapper;
import com.kingdee.util.ObjectUtils;
import java.util.Arrays;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.quartz.Calendar;
import org.quartz.JobDetail;
import org.quartz.JobPersistenceException;
import org.quartz.Trigger;

public abstract class BatchUpdater
implements JobStoreHelper {
    private static final Logger logger = Logger.getLogger(BatchUpdater.class);
    private final Object recordMonitor = new Object();
    protected long recordSequence = 0L;
    private final HashMap records = new HashMap();
    private boolean onlyStates = true;
    private final Object updateMonitor = new Object();
    private final DelayUpdater delayUpdater = new DelayUpdater();
    protected long delayUpdateInterval = 0L;
    protected Exception delayUpdateException = null;

    protected abstract void finalUpdateTriggerState(String var1, String var2, int var3) throws Exception;

    protected abstract void finalUpdateTrigger(Trigger var1, int var2) throws Exception;

    protected abstract void finalDeleteTrigger(String var1, String var2) throws Exception;

    protected abstract void finalCheckTrigger(String var1, String var2) throws Exception;

    protected abstract void finalUpdateJob(JobDetail var1) throws Exception;

    protected abstract void finalDeleteJob(String var1, String var2) throws Exception;

    protected abstract void finalUpdateCalendar(String var1, Calendar var2) throws Exception;

    protected abstract void finalDeleteCalendar(String var1) throws Exception;

    protected void commitTrans() throws Exception {
    }

    protected void rollbackTrans() throws Exception {
    }

    private TriggerRecord updateForTrigger(TriggerWrapper tw) {
        String key = "Trigger_" + tw.key;
        TriggerRecord rec = (TriggerRecord)this.records.get(key);
        if (rec == null) {
            rec = new TriggerRecord(tw.trigger.getKey().getGroup(), tw.trigger.getKey().getName());
            this.records.put(key, rec);
        }
        rec.updateIndex();
        return rec;
    }

    private JobRecord updateForJob(JobWrapper jw) {
        String key = "Job_" + jw.key;
        JobRecord rec = (JobRecord)this.records.get(key);
        if (rec == null) {
            rec = new JobRecord(jw.jobDetail.getKey().getGroup(), jw.jobDetail.getKey().getName());
            this.records.put(key, rec);
        }
        rec.updateIndex();
        return rec;
    }

    private CalendarRecord updateForCalendar(String name) {
        String key = "Calendar_" + name;
        CalendarRecord rec = (CalendarRecord)this.records.get(key);
        if (rec == null) {
            rec = new CalendarRecord(name);
            this.records.put(key, rec);
        }
        rec.updateIndex();
        return rec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateTriggerState(TriggerWrapper tw, int state) throws Exception {
        Object object = this.recordMonitor;
        synchronized (object) {
            TriggerRecord rec = this.updateForTrigger(tw);
            rec.state = state;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateTrigger(TriggerWrapper tw, int method) throws Exception {
        Object object = this.recordMonitor;
        synchronized (object) {
            this.onlyStates = false;
            TriggerRecord rec = this.updateForTrigger(tw);
            if (method == 3) {
                rec.method = 3;
            } else {
                rec.trigger = (Trigger)ObjectUtils.createCopy((Object)tw.trigger);
                rec.state = tw.state;
                rec.method = 2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateJob(JobWrapper jw, int method) throws Exception {
        Object object = this.recordMonitor;
        synchronized (object) {
            this.onlyStates = false;
            JobRecord rec = this.updateForJob(jw);
            if (method == 3) {
                rec.method = 3;
            } else {
                rec.job = (JobDetail)jw.jobDetail.clone();
                rec.method = 2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateCalendar(String name, Calendar cal, int method) throws Exception {
        Object object = this.recordMonitor;
        synchronized (object) {
            this.onlyStates = false;
            CalendarRecord rec = this.updateForCalendar(name);
            if (method == 3) {
                rec.method = 3;
            } else {
                rec.calendar = cal;
                rec.method = 2;
            }
        }
    }

    private void updateRecord(UpdateRecord rec) throws Exception {
        if (rec instanceof TriggerRecord) {
            TriggerRecord tr = (TriggerRecord)rec;
            switch (tr.method) {
                case 0: {
                    logger.debug((Object)("updateTriggerState group=" + tr.group + " name=" + tr.name + " state=" + TriggerWrapper.stateName(tr.state)));
                    this.finalUpdateTriggerState(tr.group, tr.name, tr.state);
                    break;
                }
                case 3: {
                    logger.debug((Object)("deleteTrigger group=" + tr.group + " name=" + tr.name));
                    this.finalDeleteTrigger(tr.group, tr.name);
                    break;
                }
                case 2: {
                    logger.debug((Object)("updateTrigger group=" + tr.group + " name=" + tr.name + " state=" + TriggerWrapper.stateName(tr.state)));
                    this.finalUpdateTrigger(tr.trigger, tr.state);
                    break;
                }
                default: {
                    assert (false);
                    {
                        break;
                    }
                }
            }
        } else if (rec instanceof JobRecord) {
            JobRecord jr = (JobRecord)rec;
            switch (jr.method) {
                case 3: {
                    logger.debug((Object)("deleteJob group=" + jr.group + " name=" + jr.name));
                    this.finalDeleteJob(jr.group, jr.name);
                    break;
                }
                case 2: {
                    logger.debug((Object)("updateJob group=" + jr.group + " name=" + jr.name));
                    this.finalUpdateJob(jr.job);
                    break;
                }
                default: {
                    assert (false);
                    {
                        break;
                    }
                }
            }
        } else if (rec instanceof CalendarRecord) {
            CalendarRecord cr = (CalendarRecord)rec;
            switch (cr.method) {
                case 3: {
                    logger.debug((Object)("deleteCalendar name=" + cr.name));
                    this.finalDeleteCalendar(cr.name);
                    break;
                }
                case 2: {
                    logger.debug((Object)("updateCalendar name=" + cr.name));
                    this.finalUpdateCalendar(cr.name, cr.calendar);
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int updateAll(boolean commit, boolean update_when_only_states) throws Exception {
        Object[] recs = null;
        Object object = this.recordMonitor;
        synchronized (object) {
            if (this.onlyStates && !update_when_only_states) {
                return 0;
            }
            if (this.records.size() == 0) {
                return 0;
            }
            recs = this.records.values().toArray();
            this.records.clear();
            this.recordSequence = 0L;
            this.onlyStates = true;
        }
        if (recs == null || recs.length == 0) {
            return 0;
        }
        if (!commit) {
            return recs.length;
        }
        Arrays.sort(recs);
        object = this.updateMonitor;
        synchronized (object) {
            boolean succeeded = false;
            try {
                for (int i = 0; i < recs.length; ++i) {
                    this.updateRecord((UpdateRecord)recs[i]);
                }
                this.commitTrans();
                succeeded = true;
            }
            finally {
                if (!succeeded) {
                    this.rollbackTrans();
                }
            }
        }
        return recs.length;
    }

    @Override
    public void commit() throws Exception {
        this.delayUpdater.commit();
    }

    @Override
    public void rollback() {
        try {
            this.updateAll(false, true);
        }
        catch (Throwable e) {
            logger.error((Object)"rollback()", e);
        }
    }

    @Override
    public void shutdown() {
        this.delayUpdater.shutdown();
    }

    public void setDelayUpdateInterval(long val) {
        this.delayUpdateInterval = val;
    }

    private class DelayUpdater
    extends Thread {
        boolean toBeShutdown;

        DelayUpdater() {
            super("Delay-Updater");
            this.toBeShutdown = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void commit() throws Exception {
            if (BatchUpdater.this.delayUpdateInterval <= 0L) {
                BatchUpdater.this.updateAll(true, true);
            } else {
                DelayUpdater delayUpdater = this;
                synchronized (delayUpdater) {
                    if (BatchUpdater.this.delayUpdateException != null) {
                        throw new JobPersistenceException("Error occured when delay update.", (Throwable)BatchUpdater.this.delayUpdateException);
                    }
                    if (!this.isAlive()) {
                        this.start();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        synchronized void shutdown() {
            block6: {
                try {
                    if (BatchUpdater.this.delayUpdateInterval <= 0L) {
                        BatchUpdater.this.updateAll(true, true);
                        break block6;
                    }
                    DelayUpdater delayUpdater = this;
                    synchronized (delayUpdater) {
                        this.toBeShutdown = true;
                        this.notify();
                    }
                    this.join();
                }
                catch (Exception e) {
                    logger.error((Object)"Error occured when shutdown.", (Throwable)e);
                }
            }
        }

        synchronized boolean toBeShutdown() {
            return this.toBeShutdown;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            logger.debug((Object)"Delay Updater start.");
            try {
                while (!this.toBeShutdown()) {
                    DelayUpdater delayUpdater = this;
                    synchronized (delayUpdater) {
                        this.wait(BatchUpdater.this.delayUpdateInterval);
                    }
                    BatchUpdater.this.updateAll(true, false);
                }
                BatchUpdater.this.updateAll(true, true);
            }
            catch (Exception e) {
                BatchUpdater.this.delayUpdateException = e;
            }
        }
    }

    private class CalendarRecord
    extends UpdateRecord {
        final String name;
        Calendar calendar;
        int method;

        CalendarRecord(String _name) {
            this.calendar = null;
            this.method = 0;
            this.name = _name;
        }
    }

    private class JobRecord
    extends UpdateRecord {
        final String group;
        final String name;
        JobDetail job;
        int method;

        JobRecord(String _group, String _name) {
            this.job = null;
            this.method = 0;
            this.group = _group;
            this.name = _name;
        }
    }

    private class TriggerRecord
    extends UpdateRecord {
        final String group;
        final String name;
        int state;
        Trigger trigger;
        int method;

        TriggerRecord(String _group, String _name) {
            this.state = 0;
            this.trigger = null;
            this.method = 0;
            this.group = _group;
            this.name = _name;
        }
    }

    private abstract class UpdateRecord
    implements Comparable {
        long recordIndex = 0L;

        private UpdateRecord() {
        }

        void updateIndex() {
            this.recordIndex = BatchUpdater.this.recordSequence++;
        }

        public int compareTo(Object x) {
            long index = ((UpdateRecord)x).recordIndex;
            if (this.recordIndex > index) {
                return 1;
            }
            if (this.recordIndex < index) {
                return -1;
            }
            assert (false);
            return 0;
        }
    }
}

