/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tool.utils;

import com.kingdee.bos.tool.exceptions.MissingBundleException;
import java.util.Hashtable;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

public class ResourceUtil {
    private static Hashtable bundleMap = new Hashtable();
    private static Hashtable resourceBundleMap = new Hashtable();
    private static Hashtable instanceMap = new Hashtable();
    private String symbolicName = null;

    private ResourceUtil(String symbolicName) {
        this.symbolicName = symbolicName;
    }

    public static ResourceUtil getInstance(String bundleSymbolicName) {
        ResourceUtil instance = (ResourceUtil)instanceMap.get(bundleSymbolicName);
        if (instance == null) {
            instance = ResourceUtil.init(bundleSymbolicName);
        }
        return instance;
    }

    public String getResourceString(String key) {
        try {
            return this.getResourceBundle().getString(key);
        }
        catch (Exception ex) {
            return key;
        }
    }

    public Bundle getBundle() {
        return (Bundle)bundleMap.get(this.symbolicName);
    }

    private static ResourceUtil init(String bundleSymbolicName) {
        Bundle bundle = (Bundle)bundleMap.get(bundleSymbolicName);
        if (bundle == null && (bundle = Platform.getBundle((String)bundleSymbolicName)) == null) {
            throw new MissingBundleException(bundleSymbolicName);
        }
        return ResourceUtil.synchronizeMap(bundleSymbolicName, bundle);
    }

    private static ResourceUtil synchronizeMap(String bundleSymbolicName, Bundle bundle) {
        assert (bundle != null && bundleSymbolicName != null);
        ResourceUtil instance = new ResourceUtil(bundleSymbolicName);
        instanceMap.put(bundleSymbolicName, instance);
        bundleMap.put(bundleSymbolicName, bundle);
        if (resourceBundleMap.contains(bundleSymbolicName)) {
            resourceBundleMap.remove(bundleSymbolicName);
        }
        return instance;
    }

    private ResourceBundle getResourceBundle() {
        assert (this.symbolicName != null);
        ResourceBundle resourceBundle = (ResourceBundle)resourceBundleMap.get(this.symbolicName);
        if (resourceBundle == null) {
            Bundle bundle = (Bundle)bundleMap.get(this.symbolicName);
            assert (bundle != null);
            resourceBundle = Platform.getResourceBundle((Bundle)bundle);
            resourceBundleMap.put(this.symbolicName, resourceBundle);
        }
        return resourceBundle;
    }
}

