/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.md.actions.base;

import com.kingdee.bos.md.actions.base.ActionSetting;
import com.kingdee.bos.md.actions.base.BaseAction;
import com.kingdee.util.StringUtils;
import java.util.HashMap;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.actions.ActionGroup;

public abstract class BaseActionGroup
extends ActionGroup {
    protected IViewPart viewPart;
    protected final ActionSetting[] actionSettings;
    protected final String groupName;

    protected abstract ActionSetting[] getActionSettings();

    protected abstract String getGroupName();

    public BaseActionGroup(IViewPart part) {
        this.viewPart = part;
        IWorkbenchPartSite fSite = part.getSite();
        this.groupName = this.getGroupName();
        this.actionSettings = this.getActionSettings();
        ISelectionProvider provider = fSite.getSelectionProvider();
        for (int i = 0; i < this.actionSettings.length; ++i) {
            ActionSetting at = this.actionSettings[i];
            if (at.action == null) continue;
            if (at.action instanceof ISelectionChangedListener) {
                provider.addSelectionChangedListener((ISelectionChangedListener)at.action);
            }
            if (at.action instanceof BaseAction) {
                ((BaseAction)at.action).setView(part);
            }
            if (!StringUtils.isEmpty((String)at.action.getDescription())) continue;
            at.action.setDescription(at.action.getClass().getName());
        }
    }

    public final void fillActionBars(IActionBars actionBar) {
        for (int i = 0; i < this.actionSettings.length; ++i) {
            ActionSetting at = this.actionSettings[i];
            if (at.actionId == null) continue;
            actionBar.setGlobalActionHandler(at.actionId, at.action);
        }
        super.fillActionBars(actionBar);
    }

    public final void fillContextMenu(IMenuManager menu) {
        HashMap<String, IMenuManager> map = new HashMap<String, IMenuManager>();
        for (int i = 0; i < this.actionSettings.length; ++i) {
            IMenuManager newSubmenu;
            ActionSetting at = this.actionSettings[i];
            if (at.action == null) {
                if (at.subMenu != null) {
                    newSubmenu = (IMenuManager)map.get(at.subMenu);
                    if (newSubmenu == null) continue;
                    newSubmenu.add((IContributionItem)new Separator());
                    continue;
                }
                BaseActionGroup.appendToGroup(this.groupName, menu, (IContributionItem)new Separator());
                continue;
            }
            if (!at.showInContext || !at.action.isEnabled()) continue;
            if (at.subMenu != null) {
                newSubmenu = (IMenuManager)map.get(at.subMenu);
                if (newSubmenu == null) {
                    newSubmenu = new MenuManager(at.subMenu);
                    menu.appendToGroup(this.groupName, (IContributionItem)newSubmenu);
                    map.put(at.subMenu, newSubmenu);
                }
                newSubmenu.add(at.action);
                continue;
            }
            BaseActionGroup.appendToGroup(this.groupName, menu, at.action);
        }
        super.fillContextMenu(menu);
    }

    public void dispose() {
        ISelectionProvider provider = this.viewPart.getSite().getSelectionProvider();
        for (int i = 0; i < this.actionSettings.length; ++i) {
            ActionSetting at = this.actionSettings[i];
            if (!(at.action instanceof ISelectionChangedListener)) continue;
            provider.removeSelectionChangedListener((ISelectionChangedListener)at.action);
        }
        super.dispose();
    }

    public static boolean appendToGroup(String groupName, IMenuManager menu, IAction action) {
        if (action == null) {
            return false;
        }
        if (action.isEnabled()) {
            menu.appendToGroup(groupName, action);
            return true;
        }
        return false;
    }

    public static boolean appendToGroup(String groupName, IMenuManager menu, IContributionItem item) {
        if (item == null) {
            return false;
        }
        menu.appendToGroup(groupName, item);
        return true;
    }
}

