/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.md.cache;

import com.kingdee.bos.md.cache.CacheItem;
import com.kingdee.bos.tool.FileUtils;
import com.kingdee.bos.tool.LogTool;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public class CacheMonitorThread
extends Thread {
    private int maxSize = -1;
    private File cacheFile = null;
    private Vector cacheItems = null;
    private long interval = 30000L;

    public CacheMonitorThread(Vector cacheItems, File cacheFile) {
        super("Cache Monitor " + cacheFile);
        this.cacheItems = cacheItems;
        this.cacheFile = cacheFile;
        this.setDaemon(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            block28: {
                ZipFile zip = null;
                try {
                    File tempFile;
                    if (!this.cacheFile.exists()) {
                        this.cacheFile.getParentFile().mkdirs();
                        ZipOutputStream zout = null;
                        try {
                            zout = new ZipOutputStream(new FileOutputStream(this.cacheFile));
                            zout.putNextEntry(new ZipEntry("META-INF"));
                            zout.flush();
                        }
                        catch (Throwable throwable) {
                            FileUtils.close(zout);
                            throw throwable;
                        }
                        FileUtils.close(zout);
                    }
                    if ((zip = new ZipFile(this.cacheFile)) == null || this.cacheItems.isEmpty()) break block28;
                    ArrayList<CacheItem> list = new ArrayList<CacheItem>();
                    Vector vector = this.cacheItems;
                    synchronized (vector) {
                        while (!this.cacheItems.isEmpty()) {
                            CacheItem item = (CacheItem)this.cacheItems.remove(0);
                            list.add(item);
                        }
                    }
                    if (list.isEmpty()) break block28;
                    CacheItem[] items = list.toArray(new CacheItem[list.size()]);
                    ZipOutputStream zout = null;
                    try {
                        tempFile = new File(this.cacheFile.getAbsolutePath() + "_temp");
                        zout = this.getOutputStream(zip, items, tempFile);
                        for (int i = 0; i < items.length; ++i) {
                            ZipEntry entry = new ZipEntry(items[i].getPath());
                            try {
                                zout.putNextEntry(entry);
                                zout.write(this.getBytes(items[i]));
                                continue;
                            }
                            catch (Exception ex) {
                                LogTool.logError("Write to Zip File failed", ex);
                            }
                        }
                        zout.flush();
                    }
                    catch (Throwable throwable) {
                        FileUtils.close(zout);
                        throw throwable;
                    }
                    FileUtils.close(zout);
                    this.rename(tempFile, this.cacheFile);
                }
                catch (Exception ex) {
                    LogTool.logError("Create Zip File failed", ex);
                }
                finally {
                    if (zip != null) {
                        try {
                            zip.close();
                        }
                        catch (Exception ex) {
                            LogTool.logError("Close Zip File Faild", ex);
                        }
                    }
                }
            }
            try {
                Thread.sleep(this.interval);
                continue;
            }
            catch (InterruptedException e) {
                LogTool.logError("", e);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ZipOutputStream getOutputStream(ZipFile zip, CacheItem[] items, File file) throws IOException {
        ZipOutputStream zout;
        ArrayList<ZipEntry> entries = new ArrayList<ZipEntry>();
        Enumeration<? extends ZipEntry> ens = zip.entries();
        while (ens.hasMoreElements()) {
            ZipEntry tEn = ens.nextElement();
            if (this.include(items, tEn)) continue;
            entries.add(tEn);
        }
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            zout = new ZipOutputStream(fileOutputStream);
            int size = entries.size() - 1;
            for (int i = 0; i <= size && (this.maxSize == -1 || i < this.maxSize); ++i) {
                ZipEntry tEn = (ZipEntry)entries.get(size - i);
                zout.putNextEntry(tEn);
                InputStream zin = zip.getInputStream(tEn);
                byte[] bs = new byte[2048];
                int len = zin.read(bs);
                while (len != -1) {
                    zout.write(bs, 0, len);
                    len = zin.read(bs);
                }
                zin.close();
            }
        }
        catch (Throwable throwable) {
            FileUtils.close(fileOutputStream);
            throw throwable;
        }
        FileUtils.close(fileOutputStream);
        return zout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rename(File srcFile, File destFile) throws IOException {
        destFile.delete();
        if (!srcFile.renameTo(destFile)) {
            FileInputStream input = null;
            FileOutputStream out = null;
            try {
                input = new FileInputStream(srcFile);
                out = new FileOutputStream(destFile);
                byte[] bs = new byte[2048];
                int len = input.read(bs);
                while (len != -1) {
                    out.write(bs, 0, len);
                    len = input.read(bs);
                }
                out.flush();
            }
            catch (Throwable throwable) {
                FileUtils.close(input);
                FileUtils.close(out);
                throw throwable;
            }
            FileUtils.close(input);
            FileUtils.close(out);
        }
        srcFile.delete();
    }

    private boolean include(CacheItem[] items, ZipEntry entry) {
        String name = entry.getName();
        for (int i = 0; i < items.length; ++i) {
            if (!items[i].getPath().equals(name)) continue;
            return true;
        }
        return false;
    }

    private byte[] getBytes(CacheItem info) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        ObjectOutputStream oout = new ObjectOutputStream(bout);
        oout.writeObject(info);
        byte[] bs = bout.toByteArray();
        bout.close();
        oout.close();
        return bs;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
    }

    public long getInterval() {
        return this.interval;
    }

    public void setInterval(long interval) {
        this.interval = interval;
    }
}

