/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.md.cache;

import com.kingdee.bos.md.cache.CacheInfo;
import com.kingdee.bos.md.cache.MDSimpleObject;
import com.kingdee.bos.md.cache.SimpleMDUtil;
import com.kingdee.bos.tool.FileUtils;
import com.kingdee.bos.tool.LogTool;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class SimleMDStoreThread
extends Thread {
    private File cacheRoot;
    private SimpleMDUtil util;

    public SimleMDStoreThread(SimpleMDUtil util) {
        super("SimpleMDStore for " + util.project.getName());
        this.util = util;
        this.cacheRoot = new File(util.project.toFile(), "cache");
        if (!this.cacheRoot.exists()) {
            this.cacheRoot.mkdirs();
        }
        this.setDaemon(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            if (!this.util.changedSet.isEmpty()) {
                File file;
                ArrayList list = new ArrayList();
                Set set = this.util.changedSet;
                synchronized (set) {
                    list.addAll(this.util.changedSet);
                    this.util.changedSet.clear();
                }
                HashMap<File, ArrayList<MDSimpleObject>> map = new HashMap<File, ArrayList<MDSimpleObject>>();
                for (int i = 0; i < list.size(); ++i) {
                    MDSimpleObject obj = (MDSimpleObject)list.get(i);
                    file = this.getCacheFile(obj.getPath());
                    ArrayList<MDSimpleObject> l = (ArrayList<MDSimpleObject>)map.get(file);
                    if (l == null) {
                        l = new ArrayList<MDSimpleObject>();
                        map.put(file, l);
                    }
                    l.add(obj);
                }
                for (File cacheFile : map.keySet()) {
                    List l = (List)map.get(cacheFile);
                    if (cacheFile.exists()) {
                        ObjectInputStream in = null;
                        try {
                            in = new ObjectInputStream(new FileInputStream(cacheFile));
                            MDSimpleObject cache = (MDSimpleObject)in.readObject();
                            while (cache != null) {
                                if (l.contains(cache)) continue;
                                l.add(cache);
                            }
                        }
                        catch (Exception ex) {
                            LogTool.logError("\u88c5\u8f7d\u5143\u7f13\u5b58\u4fe1\u606f\u65f6\u62a5\u9519", ex);
                            continue;
                        }
                        finally {
                            if (in == null) continue;
                            try {
                                in.close();
                            }
                            catch (IOException e) {
                                LogTool.logError("\u88c5\u8f7d\u5143\u7f13\u5b58\u4fe1\u606f\u65f6\u62a5\u9519", e);
                            }
                            continue;
                        }
                    }
                    ObjectOutputStream out = null;
                    try {
                        out = new ObjectOutputStream(new FileOutputStream(cacheFile));
                        for (int i = 0; i < l.size(); ++i) {
                            out.writeObject(l.get(i));
                        }
                        out.flush();
                    }
                    catch (Exception ex) {
                        LogTool.logError("\u88c5\u8f7d\u5143\u7f13\u5b58\u4fe1\u606f\u65f6\u62a5\u9519", ex);
                    }
                    finally {
                        if (out == null) continue;
                        try {
                            out.close();
                        }
                        catch (IOException e) {
                            LogTool.logError("\u88c5\u8f7d\u5143\u7f13\u5b58\u4fe1\u606f\u65f6\u62a5\u9519", e);
                        }
                    }
                }
                Map m = this.util.caches;
                Properties prop = new Properties();
                for (String path : m.keySet()) {
                    CacheInfo info = (CacheInfo)m.get(path);
                    prop.put(path, String.valueOf(info.getLastActiveTime()));
                }
                file = new File(this.util.project.toFile(), "cache/simpleMDUtil.index");
                FileOutputStream fileOutputStream = null;
                try {
                    fileOutputStream = new FileOutputStream(file);
                    prop.store(fileOutputStream, null);
                }
                catch (IOException e) {
                    try {
                        LogTool.logError("\u4fdd\u5b58\u7d22\u5f15\u4fe1\u606f\u65f6\u51fa\u9519", e);
                    }
                    catch (Throwable throwable) {
                        FileUtils.close(fileOutputStream);
                        throw throwable;
                    }
                    FileUtils.close(fileOutputStream);
                }
                FileUtils.close(fileOutputStream);
            }
            try {
                Thread.sleep(60000L);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MDSimpleObject loadFromCache(String path) throws IOException, ClassNotFoundException {
        File cacheFile = this.getCacheFile(path);
        if (!cacheFile.exists()) {
            return null;
        }
        try (ObjectInputStream in = new ObjectInputStream(new FileInputStream(cacheFile));){
            MDSimpleObject obj = (MDSimpleObject)in.readObject();
            while (obj != null) {
                if (path.equals(obj.getPath())) {
                    MDSimpleObject mDSimpleObject = obj;
                    return mDSimpleObject;
                }
                obj = (MDSimpleObject)in.readObject();
            }
        }
        return null;
    }

    private File getCacheFile(String path) {
        File cacheFile = new File(this.cacheRoot, "smdcache");
        int index = path.lastIndexOf(46);
        if (index == -1) {
            String ext = path.substring(index + 1).trim();
            cacheFile = new File(cacheFile.getAbsolutePath() + ext);
        }
        return cacheFile;
    }
}

