/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.md.dao;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.xml.Utils;
import com.kingdee.bos.engine.IDevMetadataLoader;
import com.kingdee.bos.engine.MDNotFoundException;
import com.kingdee.bos.engine.MDSaveException;
import com.kingdee.bos.md.cache.MDSimpleObject;
import com.kingdee.bos.md.cache.SimpleMDUtil;
import com.kingdee.bos.md.command.MDCopyCommand;
import com.kingdee.bos.md.command.MDCreateFileCommand;
import com.kingdee.bos.md.command.MDCreatePackageCommand;
import com.kingdee.bos.md.mdfs.IMDFile;
import com.kingdee.bos.md.mdfs.IMDProject;
import com.kingdee.bos.md.mdfs.MDResourceUtil;
import com.kingdee.bos.metadata.AbstractMetaDataValue;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.bizunit.AbstractBizUnitCtrl;
import com.kingdee.bos.metadata.bizunit.BizUnitInfo;
import com.kingdee.bos.metadata.management.PackageInfo;
import com.kingdee.bos.metadata.management.SolutionInfo;
import com.kingdee.bos.metadata.util.ContextManager;
import com.kingdee.bos.service.log.LogUtils;
import com.kingdee.bos.service.log.define.LogInfo;
import com.kingdee.bos.service.permission.PermissionUtils;
import com.kingdee.bos.service.permission.metadata.PermissionInfo;
import com.kingdee.bos.tool.FileUtils;
import com.kingdee.bos.tool.common.IDEException;
import com.kingdee.bos.tool.dao.ICommand;
import com.kingdee.bos.tool.dao.MetaDataRunner;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.util.StringUtils;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public abstract class MDORMUtil {
    public static MDSimpleObject getSimpleObject(IMDFile mdFile) {
        return SimpleMDUtil.getSimpleObject(mdFile);
    }

    public static IObjectValue load(IMDFile file) throws MDNotFoundException {
        IMDProject project = file.getMDProject();
        ContextManager.setContext((Context)project.getORMContext());
        ContextManager.setContext2((Context)project.getORMContext());
        AbstractMetaDataValue ov = project.getMetadataLoader().loadMetadata(file.getBOSType(), (IMetaDataPK)file.getMetaDataPK(), false);
        if (ov == null) {
            return null;
        }
        ov.setDefaultLocale(project.getLocale());
        if (ov instanceof PermissionInfo) {
            PermissionUtils.processPermission((PermissionInfo)((PermissionInfo)ov));
        } else if (ov instanceof LogInfo) {
            LogUtils.processLog((LogInfo)((LogInfo)ov));
        }
        return ov;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void store(IMDProject project, IObjectValue model, IProgressMonitor monitor) throws IDEException {
        IDevMetadataLoader loader = project.getMetadataLoader();
        if (model instanceof SolutionInfo) {
            loader.initSolution((SolutionInfo)model);
        }
        try {
            AbstractMetaDataValue value = (AbstractMetaDataValue)model;
            String path = value.getRealFullName().replaceAll("\\.", "/") + Utils.getMetaDataSuffix((BOSObjectType)value.getBOSType());
            File meta_file = project.getMDFile(path);
            if (!meta_file.exists()) {
                meta_file.getParentFile().mkdirs();
            }
            FileOutputStream fileOutputStream = null;
            BufferedOutputStream output = null;
            try {
                fileOutputStream = new FileOutputStream(meta_file);
                output = new BufferedOutputStream(fileOutputStream);
                loader.saveMetadata(value, (OutputStream)output);
            }
            catch (Throwable throwable) {
                FileUtils.close(fileOutputStream);
                FileUtils.close(output);
                throw throwable;
            }
            FileUtils.close(fileOutputStream);
            FileUtils.close(output);
        }
        catch (MDSaveException e) {
            throw new IDEException(e.getMessage(), (Throwable)e);
        }
        catch (FileNotFoundException e) {
            throw new IDEException(e.getMessage(), (Throwable)e);
        }
    }

    public static void loadFullBizUnit(IMDProject project, BizUnitInfo info, boolean isClearCache) throws IDEException {
        boolean isOpenCache = false;
        try {
            Context ctx = project.getORMContext();
            AbstractBizUnitCtrl ctrl = (AbstractBizUnitCtrl)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)info.getBOSType());
            isOpenCache = project.getMetadataLoader().isOpenCache();
            if (!isOpenCache) {
                project.getMetadataLoader().openCache();
            }
            ctrl.loadAll(info, isClearCache);
            if (!isOpenCache) {
                project.getMetadataLoader().closeCache();
            }
        }
        catch (BOSException e) {
            throw new IDEException((Throwable)e);
        }
    }

    public static void createPackage(IMDProject project, PackageInfo info, IProgressMonitor monitor) throws IDEException {
        ICommand[] commands = new ICommand[]{new MDCreatePackageCommand(project, info)};
        MDORMUtil.executeRunner(commands, monitor);
    }

    public static IMDFile createFile(IMDProject project, IObjectValue model, IProgressMonitor monitor) throws IDEException {
        ICommand[] commands = new ICommand[]{new MDCreateFileCommand(project, model)};
        MDORMUtil.executeRunner(commands, monitor);
        return MDResourceUtil.getFile(project, model);
    }

    public static IMDFile copy(IMDFile file, String packageName, String name, IProgressMonitor monitor) throws IDEException {
        ICommand[] commands = new ICommand[]{new MDCopyCommand(file, packageName, name)};
        MDORMUtil.executeRunner(commands, monitor);
        String path = StringUtils.replace((String)packageName, (String)".", (String)"/") + "/" + name;
        return file.getMDProject().getRoot().getChildFile(path);
    }

    public static void executeRunner(ICommand[] commands, IProgressMonitor monitor) throws IDEException {
        try {
            MetaDataRunner runner = new MetaDataRunner(commands);
            ResourcesPlugin.getWorkspace().run((IWorkspaceRunnable)runner, monitor);
        }
        catch (CoreException e) {
            throw new IDEException("metadata access error", (Throwable)e);
        }
    }

    public static IObjectValue getObjectValue(IMDProject project, IMetaDataPK pk, BOSObjectType bosType, String str) throws IDEException {
        try {
            IMDFile file = MDResourceUtil.getFile(project, pk, bosType);
            file.create(new ByteArrayInputStream(str.getBytes("UTF-8")));
            return MDORMUtil.load(file);
        }
        catch (Exception e) {
            throw new IDEException("", (Throwable)e);
        }
    }
}

