/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.md.mdfs;

import com.kingdee.bos.dao.xml.Utils;
import com.kingdee.bos.md.mdfs.IMDFile;
import com.kingdee.bos.md.mdfs.IMDProject;
import com.kingdee.bos.md.mdfs.MDResource;
import com.kingdee.bos.md.mdfs.MDZipInputStream;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.tool.FileUtils;
import com.kingdee.bos.tool.LogTool;
import com.kingdee.bos.tool.PFileUtils;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.util.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;

public class MDFile
extends MDResource
implements IMDFile {
    MDFile(IMDProject project, String path) {
        super(project, path);
    }

    MDFile(IMDProject project, String path, Iterator iter) {
        super(project, path, iter);
    }

    @Override
    public InputStream getContent() throws IOException {
        InputStream in = this.getLocalContent();
        if (in != null) {
            return in;
        }
        return this.getLibContent();
    }

    @Override
    public InputStream getLibContent() throws IOException {
        File[] files = this.project.getLibFiles(this.path);
        if (files == null) {
            return null;
        }
        return new MDZipInputStream(files[0], this.path);
    }

    @Override
    public InputStream getLocalContent() throws IOException {
        if (this.toFile().exists()) {
            return new FileInputStream(this.toFile());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void create(InputStream input) throws IOException {
        File f = this.toFile();
        if (!f.exists()) {
            f.mkdirs();
            f.createNewFile();
        }
        byte[] bs = new byte[2048];
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(f);
            int len = input.read(bs);
            while (len != -1) {
                ((OutputStream)out).write(bs, 0, len);
                len = input.read(bs);
            }
            out.flush();
        }
        catch (Throwable throwable) {
            FileUtils.close(out);
            throw throwable;
        }
        FileUtils.close(out);
    }

    @Override
    public String getExtension() {
        String name = this.getName();
        int index = name.indexOf(46);
        if (index == -1) {
            return null;
        }
        return name.substring(index + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public BOSObjectType getBOSType() {
        String ext = this.getExtension();
        if (ext == null) {
            return null;
        }
        ext = Utils.getBOSTypeBySuffix((String)ext);
        BOSObjectType type = null;
        if (ext != null) {
            type = BOSObjectType.create((String)ext);
        }
        if (MetaDataTypeList.ABSTRACTTABLE.equals((Object)type)) {
            InputStream content2 = null;
            try {
                content2 = this.getContent();
                String content = PFileUtils.getContent(content2);
                if (content == null) return type;
                if (content.indexOf("<dataTable xmlns=\"com.kingdee.bos.metadata\">") != -1) {
                    type = MetaDataTypeList.DATATABLE;
                    return type;
                }
                if (content.indexOf("<crossTable xmlns=\"com.kingdee.bos.metadata\">") != -1) {
                    type = MetaDataTypeList.CROSSTABLE;
                    return type;
                }
                if (content.indexOf("<extendedTable xmlns=\"com.kingdee.bos.metadata\">") == -1) return type;
                type = MetaDataTypeList.EXTENDEDTABLE;
                return type;
            }
            catch (Throwable e) {
                LogTool.logError("\u8bfb\u53d6\u6587\u4ef6\u65f6\u51fa\u9519", e);
                return type;
            }
            finally {
                FileUtils.close(content2);
            }
        }
        if (!MetaDataTypeList.BASEQUERY.equals((Object)type)) return type;
        InputStream content2 = null;
        try {
            content2 = this.getContent();
            String content = PFileUtils.getContent(content2);
            if (content == null) return type;
            if (content.indexOf("<joinQuery xmlns=\"com.kingdee.bos.metadata\">") != -1) {
                type = MetaDataTypeList.JOINQUERY;
                return type;
            } else {
                if (content.indexOf("<unionQuery xmlns=\"com.kingdee.bos.metadata\">") == -1) return type;
                type = MetaDataTypeList.UNIONQUERY;
            }
            return type;
        }
        catch (Throwable e) {
            LogTool.logError("\u8bfb\u53d6\u6587\u4ef6\u65f6\u51fa\u9519", e);
            return type;
        }
        finally {
            FileUtils.close(content2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] toBytes() throws IOException {
        int tLen = 0;
        int size = 2048;
        byte[] bs = new byte[size];
        InputStream in = null;
        try {
            in = this.getContent();
            int len = in.read(bs);
            while (len != -1) {
                byte[] nbs = new byte[(tLen += len) + size];
                System.arraycopy(bs, 0, nbs, 0, tLen);
                bs = nbs;
                len = in.read(bs, tLen, size);
            }
        }
        finally {
            FileUtils.close(in);
        }
        byte[] nbs = new byte[tLen];
        System.arraycopy(bs, 0, nbs, 0, tLen);
        return nbs;
    }

    @Override
    public MetaDataPK getMetaDataPK() {
        String fullName = this.path;
        int index = fullName.indexOf(46);
        if (index != -1) {
            fullName = fullName.substring(0, index);
        }
        fullName = StringUtils.replace((String)fullName, (String)"/", (String)".");
        return new MetaDataPK(fullName);
    }

    @Override
    public void copyTo(File file) throws IOException {
        if (!file.exists() && file.getParentFile() != null) {
            file.getParentFile().mkdirs();
        }
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(file);
            out.write(this.toBytes());
            out.flush();
        }
        catch (Throwable throwable) {
            FileUtils.close(out);
            throw throwable;
        }
        FileUtils.close(out);
    }
}

