/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.md.multipageeditor;

import com.kingdee.bos.md.mdfs.IMDFile;
import com.kingdee.bos.md.multipageeditor.IMDFileEditorInput;
import com.kingdee.bos.tool.multipageeditor.AbstractPage;
import com.kingdee.bos.tool.multipageeditor.common.CommonEditor;
import com.kingdee.bos.tool.utils.EditorHelper;
import com.kingdee.bos.utils.FileAccessSupport;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;

public abstract class AbstractMDEditor
extends CommonEditor {
    private boolean modify = false;
    private boolean needSync = false;
    private boolean isAccessWriteEnabled = true;
    protected int currentPage = 0;
    protected IMDFile file;

    @Override
    public void doSaveAs() {
    }

    protected abstract void createTabPages();

    public void setNeedSync(boolean needSync) {
        this.needSync = needSync;
    }

    public boolean isNeedSync() {
        return this.needSync;
    }

    public boolean isModify() {
        return this.modify;
    }

    public void setModify(boolean modify) {
        if (this.isAccessWriteEnabled) {
            this.modify = modify;
            this.firePropertyChange(257);
        }
    }

    protected final void createPages() {
        this.createTabPages();
    }

    public boolean isDirty() {
        return this.modify;
    }

    public void refreshPages() {
        if (this.fPages == null) {
            return;
        }
        for (int i = 0; i < this.fPages.size(); ++i) {
            if (!(this.fPages.get(i) instanceof AbstractPage)) continue;
            ((AbstractPage)this.fPages.get(i)).refreshPage();
        }
    }

    @Override
    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        input = EditorHelper.transEditor(input);
        String title = null;
        String titleTip = null;
        title = input.getName();
        titleTip = input.getToolTipText();
        this.file = ((IMDFileEditorInput)input).getFile();
        this.isAccessWriteEnabled = this.canWrite(this.file);
        if (title != null) {
            title = title + (this.isAccessWriteEnabled ? "" : "[\u53ea\u8bfb]");
            this.setPartName(title);
        }
        super.init(site, input);
    }

    private boolean canWrite(IMDFile file) {
        return FileAccessSupport.getInstance(file.getMDProject()).canWrite(file);
    }

    public String getTitleToolTip() {
        if (!this.isAccessWriteEnabled) {
            return super.getTitleToolTip() + "[\u53ea\u8bfb]";
        }
        return super.getTitleToolTip();
    }

    @Override
    protected void pageChange(int newPageIndex) {
        super.pageChange(newPageIndex);
        if (newPageIndex > this.getPageCount()) {
            newPageIndex = this.getPageCount() - 1;
        }
        this.currentPage = newPageIndex;
        if (this.isNeedSync()) {
            this.refreshPages();
            this.setNeedSync(false);
        }
    }

    @Override
    public void doSave(IProgressMonitor monitor) {
        this.setModify(false);
        this.setNeedSync(false);
    }

    public IMDFile getFile() {
        return this.file;
    }

    @Override
    protected int getCurrentPage() {
        return this.currentPage;
    }

    @Override
    public boolean isSaveAsAllowed() {
        return true;
    }

    public boolean isSaveOnCloseNeeded() {
        return super.isSaveOnCloseNeeded();
    }
}

