/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.md.ui;

import com.kingdee.bos.md.mdfs.IMDFile;
import com.kingdee.bos.md.mdfs.IMDFolder;
import com.kingdee.bos.md.mdfs.IMDObject;
import com.kingdee.bos.md.mdfs.IMDProject;
import com.kingdee.bos.md.mdfs.IMDResource;
import com.kingdee.bos.md.mdfs.MDFolder;
import com.kingdee.bos.md.mdfs.MDObjectAdapter;
import com.kingdee.bos.md.mdfs.MDProject;
import com.kingdee.bos.md.mdfs.MDResourceUtil;
import com.kingdee.bos.tool.views.ResourceContentProvider;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IMemento;

public abstract class MDTreeContentProvider
extends ResourceContentProvider {
    protected static final Object[] NO_CHILDREN = new Object[0];
    protected boolean useSingleRoot = true;
    Set set = new HashSet();
    Set srcSet = new HashSet();
    private static final String TAG_HIDE_FOLDER_REG = "hidefolder";
    private static final String TAG_HIDE_FILE_REG = "hidefile";
    private static final String TAG_SHOW_FOLDER_REG = "showfolder";
    private static final String TAG_SHOW_FILE_REG = "showfile";
    private static final String TAG_SHOW_ONLY_SRC = "showonlysrc";
    private static final String TAG_ENABLE_FOLDER_FILTER = "enablefolderfilter";
    private static final String TAG_ENABLE_FILE_FILTER = "enablefilefilter";
    private static final String TAG_HIDE_TAIL = "ishidetail";
    private static final String TAG_HIDE_HEAD = "ishidehead";
    private static final String TAG_HIDE_EMPTY = "ishideempty";
    private static final String TAG_SINGLE_ROOT = "singleroot";
    protected String[] hideFolderRegexs = null;
    protected String[] hideFileRegexs = null;
    protected String[] showFolderRegexs = null;
    protected String[] showFileRegexs = null;
    protected boolean enableFolderFilter = true;
    protected boolean enableFileFilter = true;
    protected boolean isHideTail = true;
    protected boolean isHideHead = true;
    protected boolean hideEmptySubFolder = false;
    protected boolean isOnlySrc = false;

    public Object[] getChildren(Object element) {
        if (element instanceof IWorkspaceRoot) {
            IWorkspaceRoot root = (IWorkspaceRoot)element;
            IMDObject[] ps = this.getChildren(root);
            this.set.clear();
            this.srcSet.clear();
            return this.createAdapter(ps, false);
        }
        if (element instanceof IMDProject) {
            IMDObject[] ps = new IMDProject[]{(IMDProject)element};
            this.set.clear();
            this.srcSet.clear();
            return this.createAdapter(ps, false);
        }
        if (element instanceof MDObjectAdapter) {
            MDObjectAdapter adapter = (MDObjectAdapter)element;
            if (adapter.getModel() instanceof IMDProject) {
                if (!adapter.getProject().isOpen()) {
                    return NO_CHILDREN;
                }
                ArrayList<IMDObject> list = new ArrayList<IMDObject>();
                for (IMDObject obj : this.set) {
                    if (!obj.getMDProject().equals(adapter.getModel())) continue;
                    list.add(obj);
                }
                this.set.removeAll(list);
                list.clear();
                for (IMDObject obj : this.srcSet) {
                    if (!obj.getMDProject().equals(adapter.getModel())) continue;
                    list.add(obj);
                }
                this.srcSet.removeAll(list);
                return this.getProjectChildren(adapter);
            }
            if (adapter.getModel() instanceof IMDFolder) {
                IMDFolder folder = (IMDFolder)adapter.getModel();
                ArrayList<IMDObject> list = new ArrayList<IMDObject>();
                for (IMDObject obj : this.set) {
                    if (!obj.getMDProject().equals(folder.getMDProject()) || !(obj instanceof IMDResource) || !folder.isParentOf(((IMDResource)obj).getPath(), false)) continue;
                    list.add(obj);
                }
                this.set.removeAll(list);
                list.clear();
                for (IMDObject obj : this.srcSet) {
                    if (!obj.getMDProject().equals(folder.getMDProject()) || !(obj instanceof IMDResource) || !folder.isParentOf(((IMDResource)obj).getPath(), false)) continue;
                    list.add(obj);
                }
                this.srcSet.removeAll(list);
                return this.getFolderChildren(adapter);
            }
        }
        return new Object[0];
    }

    public MDObjectAdapter[] getParentObjectInTree(IMDResource resource) {
        IMDFolder f;
        IMDFolder folder;
        for (folder = resource.getParent(); folder != null && !folder.isRoot() && !this.set.contains(folder); folder = folder.getParent()) {
        }
        if (folder.isRoot() && this.useSingleRoot) {
            return new MDObjectAdapter[]{new MDObjectAdapter(folder.getMDProject())};
        }
        MDObjectAdapter adapter = new MDObjectAdapter(folder);
        if (this.useSingleRoot) {
            return new MDObjectAdapter[]{adapter};
        }
        for (f = resource.getParent(); f != null && !f.isRoot() && !this.srcSet.contains(f); f = f.getParent()) {
        }
        MDObjectAdapter a = new MDObjectAdapter(f);
        a.setInSrcBranch(true);
        return new MDObjectAdapter[]{adapter, a};
    }

    private MDObjectAdapter[] createAdapter(IMDObject[] objects, boolean isSrcBranch) {
        if (objects == null) {
            return null;
        }
        MDObjectAdapter[] adapters = new MDObjectAdapter[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            this.set.add(objects[i]);
            adapters[i] = new MDObjectAdapter(objects[i]);
            adapters[i].setInSrcBranch(isSrcBranch);
            if (!isSrcBranch) continue;
            this.srcSet.add(objects[i]);
        }
        return adapters;
    }

    protected MDObjectAdapter[] getFolderChildren(MDObjectAdapter folderAdapter) {
        int i;
        String prefix;
        IMDFolder mdFolder = (IMDFolder)folderAdapter.getModel();
        if (mdFolder.isRoot() && this.isHideHead && !StringUtils.isEmpty((String)(prefix = mdFolder.getMDProject().getPrefix()))) {
            mdFolder = mdFolder.getChildFolder(StringUtils.replace((String)prefix, (String)".", (String)"/"));
            MDObjectAdapter newAdapter = new MDObjectAdapter(mdFolder);
            newAdapter.setInSrcBranch(folderAdapter.isInSrcBranch());
            return this.getFolderChildren(newAdapter);
        }
        ArrayList<IMDResource> list = new ArrayList<IMDResource>();
        IMDResource[] children = mdFolder.listChildren(null);
        if (folderAdapter.isInSrcBranch()) {
            for (i = 0; i < children.length; ++i) {
                IMDResource child = children[i];
                if (!child.isModified() || !this.isVisible(child)) continue;
                list.add(child);
            }
        } else if (this.useSingleRoot) {
            for (i = 0; i < children.length; ++i) {
                if (!this.isVisible(children[i])) continue;
                list.add(children[i]);
            }
        } else {
            for (i = 0; i < children.length; ++i) {
                if (!children[i].isInLib() || !this.isVisible(children[i])) continue;
                list.add(children[i]);
            }
        }
        IMDObject[] res = list.toArray(new IMDResource[list.size()]);
        return this.createAdapter(res, folderAdapter.isInSrcBranch());
    }

    protected MDObjectAdapter[] getProjectChildren(MDObjectAdapter project) {
        if (this.useSingleRoot) {
            return this.getFolderChildren(new MDObjectAdapter(project.getModel().getMDProject().getRoot()));
        }
        IMDFolder root = project.getModel().getMDProject().getRoot();
        MDObjectAdapter adapter1 = new MDObjectAdapter(root);
        adapter1.setInSrcBranch(true);
        MDObjectAdapter adapter2 = new MDObjectAdapter(((MDFolder)root).createBaseMetasFolder());
        this.set.add(root);
        this.srcSet.add(root);
        return new MDObjectAdapter[]{adapter1, adapter2};
    }

    protected abstract IMDProject[] getChildren(IWorkspaceRoot var1);

    public void restoreState(IMemento memento) {
        if (memento == null) {
            return;
        }
        this.showFileRegexs = MDTreeContentProvider.getArray(memento, TAG_SHOW_FILE_REG);
        this.hideFileRegexs = MDTreeContentProvider.getArray(memento, TAG_HIDE_FILE_REG);
        this.showFolderRegexs = MDTreeContentProvider.getArray(memento, TAG_SHOW_FOLDER_REG);
        this.hideFolderRegexs = MDTreeContentProvider.getArray(memento, TAG_HIDE_FOLDER_REG);
        this.enableFileFilter = this.getBoolean(memento, TAG_ENABLE_FILE_FILTER);
        this.enableFolderFilter = this.getBoolean(memento, TAG_ENABLE_FOLDER_FILTER);
        this.isHideHead = this.getBoolean(memento, TAG_HIDE_HEAD);
        this.isHideTail = this.getBoolean(memento, TAG_HIDE_TAIL);
        this.hideEmptySubFolder = this.getBoolean(memento, TAG_HIDE_EMPTY);
        this.isOnlySrc = this.getBoolean(memento, TAG_SHOW_ONLY_SRC);
        this.useSingleRoot = this.getBoolean(memento, TAG_SINGLE_ROOT);
    }

    private boolean getBoolean(IMemento memento, String key) {
        Boolean value = memento.getBoolean(key);
        if (value != null) {
            return value;
        }
        return false;
    }

    public void storeState(IMemento memento) {
        if (memento == null) {
            return;
        }
        if (this.showFileRegexs != null) {
            memento.putString(TAG_SHOW_FILE_REG, StringUtils.arrayToString((Object[])this.showFileRegexs, (String)","));
        }
        memento.putString(TAG_HIDE_FILE_REG, StringUtils.arrayToString((Object[])this.hideFileRegexs, (String)","));
        memento.putString(TAG_SHOW_FOLDER_REG, StringUtils.arrayToString((Object[])this.showFolderRegexs, (String)","));
        if (this.hideFolderRegexs != null) {
            memento.putString(TAG_HIDE_FOLDER_REG, StringUtils.arrayToString((Object[])this.hideFolderRegexs, (String)","));
        }
        memento.putBoolean(TAG_ENABLE_FILE_FILTER, this.enableFileFilter);
        memento.putBoolean(TAG_ENABLE_FOLDER_FILTER, this.enableFolderFilter);
        memento.putBoolean(TAG_HIDE_HEAD, this.isHideHead);
        memento.putBoolean(TAG_HIDE_TAIL, this.isHideTail);
        memento.putBoolean(TAG_HIDE_EMPTY, this.hideEmptySubFolder);
        memento.putBoolean(TAG_SHOW_ONLY_SRC, this.isOnlySrc);
        memento.putBoolean(TAG_SINGLE_ROOT, this.useSingleRoot);
    }

    private static String[] getArray(IMemento memento, String key) {
        String value = memento.getString(key);
        if (StringUtils.isEmpty((String)value)) {
            return null;
        }
        return StringUtils.split((String)value, (int)44);
    }

    public String getShowRegexs(boolean forFolder, boolean show) {
        Object[] array = null;
        if (forFolder) {
            array = show ? this.showFolderRegexs : this.hideFolderRegexs;
        } else {
            Object[] objectArray = array = show ? this.showFileRegexs : this.hideFileRegexs;
        }
        if (array == null) {
            return "";
        }
        return StringUtils.arrayToString((Object[])array, (String)",");
    }

    public boolean isVisible(Object resource) {
        IMDResource r;
        String name = null;
        IMDProject project = null;
        if (resource instanceof IMDResource) {
            r = (IMDResource)resource;
            if (this.isOnlySrc && !r.isModified()) {
                return false;
            }
            name = r.getName();
            project = r.getMDProject();
        } else if (resource instanceof IResource) {
            r = (IResource)resource;
            name = r.getName();
            project = MDResourceUtil.toMDProject(r.getProject());
        }
        if (name == null) {
            return true;
        }
        if (this.filterDotStartFileName(name)) {
            return false;
        }
        if (resource instanceof IMDFolder || resource instanceof IFolder) {
            IMDFolder folder;
            if (Pattern.matches("CVS", name)) {
                return false;
            }
            if (Pattern.matches(".svn", name)) {
                return false;
            }
            if (this.enableFolderFilter) {
                if (this.hideFolderRegexs != null && MDTreeContentProvider.matches(this.hideFolderRegexs, name)) {
                    return false;
                }
                if (this.showFolderRegexs != null && !MDTreeContentProvider.matches(this.showFolderRegexs, name)) {
                    return false;
                }
            }
            if (this.isHideTail && this.containSuffix(project, name)) {
                return false;
            }
            if (this.hideEmptySubFolder && (folder = (IMDFolder)resource).listChildren(null).length == 0) {
                return false;
            }
        } else {
            if (resource instanceof IMDFile) {
                name = ((IMDFile)resource).getExtension();
            } else if (resource instanceof IFile) {
                name = ((IFile)resource).getFileExtension();
            }
            if (this.enableFileFilter) {
                if (this.hideFileRegexs != null && MDTreeContentProvider.matches(this.hideFileRegexs, name)) {
                    return false;
                }
                if (this.showFileRegexs != null && !MDTreeContentProvider.matches(this.showFileRegexs, name)) {
                    return false;
                }
            }
        }
        return true;
    }

    private boolean containSuffix(IMDProject project, String name) {
        return project.getSuffixes() != null && project.getSuffixes().containsValue(name);
    }

    protected boolean filterDotStartFileName(String name) {
        return name != null && name.startsWith(".");
    }

    private static boolean matches(String[] regexs, String str) {
        for (int i = 0; i < regexs.length; ++i) {
            if (!regexs[i].equals(str)) continue;
            return true;
        }
        return false;
    }

    public String[] getHideFolderRegexs() {
        return this.hideFolderRegexs;
    }

    public void setHideFolderRegexs(String[] hideFolderRegexs) {
        this.hideFolderRegexs = hideFolderRegexs;
        this.adjustRegexs(this.hideFolderRegexs);
    }

    public String[] getHideFileRegexs() {
        return this.hideFileRegexs;
    }

    public void setHideFileRegexs(String[] hideFileRegexs) {
        this.hideFileRegexs = hideFileRegexs;
        this.adjustRegexs(this.hideFileRegexs);
    }

    public String[] getShowFolderRegexs() {
        return this.showFolderRegexs;
    }

    public void setShowFolderRegexs(String[] showFolderRegexs) {
        this.showFolderRegexs = showFolderRegexs;
        this.adjustRegexs(this.showFolderRegexs);
    }

    public String[] getShowFileRegexs() {
        return this.showFileRegexs;
    }

    public void setShowFileRegexs(String[] showFileRegexs) {
        this.showFileRegexs = showFileRegexs;
        this.adjustRegexs(this.showFileRegexs);
    }

    public void adjustRegexs(String[] regexs) {
    }

    public boolean isEnableFolderFilter() {
        return this.enableFolderFilter;
    }

    public void setEnableFolderFilter(boolean enableFolderFilter) {
        this.enableFolderFilter = enableFolderFilter;
    }

    public boolean isEnableFileFilter() {
        return this.enableFileFilter;
    }

    public void setEnableFileFilter(boolean enableFileFilter) {
        this.enableFileFilter = enableFileFilter;
    }

    public boolean isHideTail() {
        return this.isHideTail;
    }

    public void setHideTail(boolean isHideTail) {
        this.isHideTail = isHideTail;
    }

    public boolean isHideHead() {
        return this.isHideHead;
    }

    public void setHideHead(boolean isHideHead) {
        this.isHideHead = isHideHead;
    }

    public boolean isHideEmptySubFolder() {
        return this.hideEmptySubFolder;
    }

    public void setHideEmptySubFolder(boolean hideEmptySubFolder) {
        this.hideEmptySubFolder = hideEmptySubFolder;
    }

    public boolean isOnlySrc() {
        return this.isOnlySrc;
    }

    public void setOnlySrc(boolean isOnlySrc) {
        this.isOnlySrc = isOnlySrc;
    }

    public boolean isUseSingleRoot() {
        return this.useSingleRoot;
    }

    public void setUseSingleRoot(boolean useSingleRoot) {
        this.useSingleRoot = useSingleRoot;
    }

    public void _resourceChanged(IResourceChangeEvent event) {
        Control ctrl;
        final IResourceDelta delta = event.getDelta();
        if (delta != null) {
            PostChangeVisitor visitor = new PostChangeVisitor();
            try {
                delta.accept((IResourceDeltaVisitor)visitor);
                if (!visitor.isNeedRefresh()) {
                    return;
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        if ((ctrl = this.viewer.getControl()) != null && !ctrl.isDisposed()) {
            ctrl.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    MDTreeContentProvider.this.viewer.getControl().setRedraw(false);
                    NeedRefreshResource needRefreshResource = new NeedRefreshResource();
                    MDTreeContentProvider.this._processDelta(delta, needRefreshResource);
                    MDTreeContentProvider.this.refresh(MDTreeContentProvider.this.viewer, needRefreshResource);
                    MDTreeContentProvider.this.viewer.getControl().setRedraw(true);
                }
            });
        }
    }

    protected void _processDelta(IResourceDelta delta, NeedRefreshResource needRefreshResource) {
        Control ctrl = this.viewer.getControl();
        if (ctrl == null || ctrl.isDisposed()) {
            return;
        }
        IResource resource = delta.getResource();
        IResourceDelta[] affectedChildren = delta.getAffectedChildren(4);
        for (int i = 0; i < affectedChildren.length; ++i) {
            if ((affectedChildren[i].getFlags() & 0x8000) == 0 && !(affectedChildren[i].getResource() instanceof IProject) || this.viewer.getControl().isVisible() || (affectedChildren[i].getFlags() & 0x4000) == 0) continue;
            needRefreshResource.addItem(RefreshType.refreshOnlyItemsType, resource);
            return;
        }
        int changeFlags = delta.getFlags();
        if ((changeFlags & 0x14000) != 0) {
            needRefreshResource.addItem(RefreshType.updateItemsType, resource);
        }
        if ((changeFlags & 0x40000) != 0) {
            needRefreshResource.addItem(RefreshType.refreshWithTrueItemsType, resource);
            return;
        }
        for (int i = 0; i < affectedChildren.length; ++i) {
            this._processDelta(affectedChildren[i], needRefreshResource);
        }
        affectedChildren = delta.getAffectedChildren(2);
        if (affectedChildren.length > 0) {
            needRefreshResource.addItem(RefreshType.refreshOnlyItemsType, resource);
        }
        if ((affectedChildren = delta.getAffectedChildren(1)).length > 0) {
            needRefreshResource.addItem(RefreshType.refreshOnlyItemsType, resource);
        }
    }

    public MDObjectAdapter getMDObjectAdapter(IResource resource) {
        if (this.viewer.getControl() instanceof Tree) {
            String name = resource.getProjectRelativePath().removeFirstSegments(1).toPortableString();
            Tree tree = (Tree)this.viewer.getControl();
            TreeItem root = this.findTreeItem(tree.getItems(), resource);
            if (root == null) {
                return null;
            }
            MDObjectAdapter adapter = this.find(root, name);
            if (adapter == null) {
                for (IContainer parent = resource.getParent(); parent != null && (adapter = this.find(root, parent.getProjectRelativePath().removeFirstSegments(1).toPortableString())) == null; parent = parent.getParent()) {
                }
            }
            return adapter;
        }
        return null;
    }

    private TreeItem findTreeItem(TreeItem[] items, IResource resource) {
        if (items == null) {
            return null;
        }
        for (TreeItem item : items) {
            IMDObject mdobj;
            if (!(item.getData() instanceof MDObjectAdapter) || (mdobj = ((MDObjectAdapter)item.getData()).getModel()) == null || mdobj.getMDProject() == null || resource.getProject() == null || !mdobj.getMDProject().getName().equals(resource.getProject().getName())) continue;
            return item;
        }
        return null;
    }

    private MDObjectAdapter find(TreeItem item, String name) {
        IMDObject mdobj;
        if (item.getData() instanceof MDObjectAdapter && ((mdobj = ((MDObjectAdapter)item.getData()).getModel()) instanceof MDProject ? name.equals(((MDObjectAdapter)item.getData()).getModel().getName()) : ((IMDResource)mdobj).getPath().replaceFirst("/$", "").equalsIgnoreCase(name))) {
            return (MDObjectAdapter)item.getData();
        }
        for (int i = 0; i < item.getItemCount(); ++i) {
            MDObjectAdapter obj = this.find(item.getItem(i), name);
            if (obj == null) continue;
            return obj;
        }
        return null;
    }

    private void refresh(Viewer viewer, NeedRefreshResource resources) {
        if (resources.isContainsRefreshRoot()) {
            ((StructuredViewer)viewer).refresh(null);
            return;
        }
        block5: for (Map.Entry<RefreshType, Set<MDObjectAdapter>> entry : resources.getAdapter().entrySet()) {
            switch (entry.getKey()) {
                case updateItemsType: {
                    for (MDObjectAdapter adapter : entry.getValue()) {
                        ((StructuredViewer)viewer).update((Object)adapter, null);
                    }
                    continue block5;
                }
                case refreshWithTrueItemsType: {
                    for (MDObjectAdapter adapter : entry.getValue()) {
                        ((StructuredViewer)viewer).refresh((Object)adapter, true);
                    }
                    continue block5;
                }
                case refreshOnlyItemsType: {
                    for (MDObjectAdapter adapter : entry.getValue()) {
                        ((StructuredViewer)viewer).refresh((Object)adapter);
                    }
                    break;
                }
            }
        }
    }

    class PostChangeVisitor
    implements IResourceDeltaVisitor {
        private boolean needRefresh = false;

        PostChangeVisitor() {
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            if (delta == null) {
                return false;
            }
            IResource res = delta.getResource();
            switch (res.getType()) {
                case 8: {
                    break;
                }
                case 4: {
                    if ((delta.getFlags() & 0x4000) == 0) break;
                    this.needRefresh = true;
                    break;
                }
                case 2: {
                    String dir = delta.getProjectRelativePath().segment(0);
                    if ("metadata".equalsIgnoreCase(dir)) {
                        this.needRefresh = true;
                    }
                    return false;
                }
            }
            return !this.needRefresh;
        }

        public boolean isNeedRefresh() {
            return this.needRefresh;
        }
    }

    class NeedRefreshResource {
        private Map<RefreshType, Set<IResource>> items = new HashMap<RefreshType, Set<IResource>>();
        private Map<RefreshType, Set<MDObjectAdapter>> mdObjectAdapters = new HashMap<RefreshType, Set<MDObjectAdapter>>();
        private boolean isTransform = false;

        NeedRefreshResource() {
        }

        public void addItem(RefreshType type, IResource resource) {
            if (this.items.get((Object)type) == null) {
                this.items.put(type, new HashSet());
            }
            this.items.get((Object)type).add(resource);
        }

        private void transform() {
            for (RefreshType type : RefreshType.values()) {
                if (this.items.get((Object)type) == null) continue;
                for (IResource res : this.items.get((Object)type)) {
                    MDObjectAdapter adapter = MDTreeContentProvider.this.getMDObjectAdapter(res);
                    if (adapter == null) {
                        this.mdObjectAdapters = null;
                        return;
                    }
                    if (this.mdObjectAdapters.get((Object)type) == null) {
                        this.mdObjectAdapters.put(type, new HashSet());
                    }
                    this.mdObjectAdapters.get((Object)type).add(adapter);
                }
            }
            this.isTransform = true;
        }

        public Map<RefreshType, Set<MDObjectAdapter>> getAdapter() {
            if (!this.isTransform) {
                this.transform();
            }
            return this.mdObjectAdapters;
        }

        public boolean isContainsRefreshRoot() {
            if (!this.isTransform) {
                this.transform();
            }
            return this.mdObjectAdapters == null;
        }
    }

    private static enum RefreshType {
        updateItemsType,
        refreshWithTrueItemsType,
        refreshOnlyItemsType;

    }
}

