/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.server.module;

import com.kingdee.bos.tool.function.Func1;
import com.kingdee.bos.tool.function.Func1V;
import com.kingdee.bos.tool.function.Lists;
import com.kingdee.bos.tool.function.Predicate;
import com.kingdee.bos.tool.function.Strings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;

public class ServerModuleGroupHelper {
    private static final String MODULE_IDS = "moduleIDs";
    private static List<Map<String, String>> groupList = null;

    public static List<Map<String, String>> getModuleGroup() {
        if (groupList == null) {
            groupList = new ArrayList<Map<String, String>>();
            IExtensionPoint extPoint = Platform.getExtensionRegistry().getExtensionPoint("com.kingdee.bos.tool.toolcommon.bizgroup");
            if (extPoint != null) {
                IExtension[] exts = extPoint.getExtensions();
                for (int i = 0; i < exts.length; ++i) {
                    IConfigurationElement[] groups;
                    for (IConfigurationElement group_ele : groups = exts[i].getConfigurationElements()) {
                        HashMap<String, String> group = new HashMap<String, String>();
                        for (String name : group_ele.getAttributeNames()) {
                            group.put(name, group_ele.getAttribute(name));
                        }
                        List<String> ids = Lists.transform(group_ele.getChildren(), new Func1<String, IConfigurationElement>(){

                            @Override
                            public String invoke(IConfigurationElement e) {
                                return e.getAttribute("moduleID");
                            }
                        });
                        group.put(MODULE_IDS, Strings.join(ids, ","));
                        groupList.add(group);
                    }
                }
            }
        }
        return groupList;
    }

    public static String[] getModuleIDs(final String[] groupNames) {
        List<Map<String, String>> selectList = Lists.findAll(ServerModuleGroupHelper.getModuleGroup(), new Predicate<Map<String, String>>(){

            @Override
            public boolean apply(final Map<String, String> map) {
                return null != Lists.findFirst(groupNames, new Predicate<String>(){

                    @Override
                    public boolean apply(String name) {
                        return name.equals(map.get("name"));
                    }
                });
            }
        });
        final HashSet ids_set = new HashSet();
        Lists.foreach(selectList, new Func1V<Map<String, String>>(){

            @Override
            public void invoke(Map<String, String> group) {
                if (group.containsKey(ServerModuleGroupHelper.MODULE_IDS)) {
                    String[] ids;
                    for (String id : ids = group.get(ServerModuleGroupHelper.MODULE_IDS).split(",")) {
                        ids_set.add(id);
                    }
                }
            }
        });
        return ids_set.toArray(new String[0]);
    }
}

