/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.server.module;

import com.kingdee.bos.server.module.InstallerContext;
import com.kingdee.bos.tool.function.Functions;
import com.kingdee.bos.tool.function.Strings;
import java.util.HashMap;

public class UpdateTask
extends HashMap<String, Object> {
    private static final String SELECT_MODULE_NAMES = "select_module_names";
    private static final long serialVersionUID = 1L;
    private static final String TASK_TYPE = "task_type";
    private static final String TASK_NAME = "task_name";
    private transient InstallerContext installContext;
    public static final String STATE = "state";

    public static UpdateTask newUpdateTask(String taskName, Type taskType, String[] moduleNames) {
        UpdateTask task = new UpdateTask();
        task.put(TASK_NAME, taskName);
        task.put(TASK_TYPE, taskType);
        task.setSelectServerModuleNames(moduleNames);
        return task;
    }

    public String getTaskName() {
        return (String)this.get(TASK_NAME);
    }

    public Type getTaskType() {
        return (Type)((Object)this.get(TASK_TYPE));
    }

    public void setTaskState(State state) {
        this.put(STATE, state);
    }

    public State getTaskState() {
        return Functions.nullAsDefault((State)((Object)this.get(STATE)), State.WAIT);
    }

    public String[] getSelectServerModuleNames() {
        return this.get(SELECT_MODULE_NAMES).toString().split(";");
    }

    public void setSelectServerModuleNames(String[] module_names) {
        this.put(SELECT_MODULE_NAMES, Strings.join(module_names, ";"));
    }

    public void setInstallerContext(InstallerContext context) {
        this.installContext = context;
    }

    public InstallerContext getInstallerContext() {
        return this.installContext;
    }

    public boolean isRun() {
        return State.RUN.equals(this.get(STATE));
    }

    public boolean isFinish() {
        return State.FINISH.equals(this.get(STATE));
    }

    @Override
    public String toString() {
        return Strings.format("task:%s,type:%s,state: %s", new Object[]{this.getTaskName(), this.getTaskType(), this.getTaskState()});
    }

    public static enum Type {
        IMPORT,
        UPDATE;

    }

    public static enum State {
        WAIT,
        RUN,
        FINISH,
        ERROR,
        STOP;

    }
}

