/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tool;

import com.kingdee.bos.tool.ToolCommonPlugin;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class LogTool {
    private static Logger logger = Logger.getLogger(LogTool.class);
    private static boolean inEclipse = false;
    private static ThreadLocal TIME_THREAD_LOCAL;

    public static boolean isDebug() {
        return "true".equals(System.getProperty("mic.debug"));
    }

    public static void debug(String s) {
        if (LogTool.isDebug()) {
            LogTool.logInfo(s, new Exception());
        }
    }

    public static void debug(String s, Throwable t) {
        if (LogTool.isDebug()) {
            LogTool.logInfo(s, t);
        }
    }

    public static void logError(String s, Throwable t) {
        LogTool.log(s, t, 4);
    }

    public static void logInfo(String s, Throwable t) {
        LogTool.log(s, t, 1);
    }

    public static void logWarn(String s, Throwable t) {
        LogTool.log(s, t, 2);
    }

    private static void log(String s, Throwable t, int level) {
        if (t == null) {
            t = new Exception();
        }
        if (inEclipse) {
            LogTool.logInEclipse(s, t, level);
        } else {
            logger.error((Object)t);
        }
    }

    private static void logInEclipse(String s, Throwable t, int level) {
        Status status = new Status(level, ToolCommonPlugin.class.getName(), s, t);
        if (ToolCommonPlugin.getDefault() != null && ToolCommonPlugin.getDefault().getLog() != null) {
            ToolCommonPlugin.getDefault().getLog().log((IStatus)status);
        } else {
            logger.error((Object)t);
        }
    }

    public static void main(String[] args) {
        LogTool.logError("test", new Exception("Test Error"));
    }

    public static void watch(String message) {
        if (!LogTool.isDebug()) {
            return;
        }
        Long t = (Long)TIME_THREAD_LOCAL.get();
        if (t != null && message != null) {
            LogTool.debug(message + " cost:" + (System.currentTimeMillis() - t));
        }
        t = new Long(System.currentTimeMillis());
        TIME_THREAD_LOCAL.set(t);
    }

    static {
        try {
            Class.forName("org.eclipse.ui.plugin.AbstractUIPlugin");
            inEclipse = true;
        }
        catch (Throwable t) {
            inEclipse = false;
        }
        TIME_THREAD_LOCAL = new ThreadLocal();
    }
}

