/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tool;

import com.kingdee.bos.md.mdfs.IMDFolder;
import com.kingdee.bos.md.mdfs.IMDObject;
import com.kingdee.bos.md.mdfs.IMDProject;
import com.kingdee.bos.md.mdfs.IMDResource;
import com.kingdee.bos.md.mdfs.MDObjectAdapter;
import com.kingdee.bos.md.ui.MDTreeContentProvider;
import java.util.ArrayList;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;

public abstract class PartHelper {
    public static void setTreeSelection(TreeViewer tree, IMDObject[] objs, boolean expend) {
        MDTreeContentProvider provider;
        if (tree.getTree().isDisposed() || !tree.getTree().isVisible() || objs == null || objs.length == 0 || !(tree.getContentProvider() instanceof MDTreeContentProvider)) {
            return;
        }
        IMDResource obj = null;
        for (int i = 0; i < objs.length; ++i) {
            if (!(objs[i] instanceof IMDResource)) continue;
            obj = (IMDResource)objs[i];
            break;
        }
        if (!(provider = (MDTreeContentProvider)tree.getContentProvider()).isVisible(obj)) {
            return;
        }
        boolean inSrcBranch = obj.toFile().exists() && !provider.isUseSingleRoot();
        MDObjectAdapter adapter = new MDObjectAdapter(obj);
        adapter.setInSrcBranch(inSrcBranch);
        StructuredSelection newSelection = new StructuredSelection((Object)adapter);
        if (tree.getSelection().equals(newSelection)) {
            return;
        }
        if (expend) {
            MDObjectAdapter p;
            IMDFolder parent;
            ArrayList<MDObjectAdapter> list = new ArrayList<MDObjectAdapter>();
            list.add(adapter);
            IMDFolder root = null;
            root = provider.isHideHead() ? obj.getMDProject().getPrefixRoot() : obj.getMDProject().getRoot();
            for (parent = obj.getParent(); parent != null && !parent.equals(root); parent = parent.getParent()) {
                p = new MDObjectAdapter(parent);
                p.setInSrcBranch(inSrcBranch);
                list.add(0, p);
            }
            if (parent != null) {
                if (!provider.isUseSingleRoot()) {
                    p = new MDObjectAdapter(obj.getMDProject().getRoot());
                    p.setInSrcBranch(inSrcBranch);
                    list.add(0, p);
                }
                list.add(0, new MDObjectAdapter(obj.getMDProject()));
                TreePath[] oldPath = tree.getExpandedTreePaths();
                TreePath[] newPath = new TreePath[oldPath.length + 1];
                System.arraycopy(oldPath, 0, newPath, 0, oldPath.length);
                newPath[newPath.length - 1] = new TreePath(list.toArray(new Object[list.size()]));
                tree.setExpandedTreePaths(newPath);
            }
        }
        tree.setSelection((ISelection)newSelection, true);
    }

    public static void updateTree(TreeViewer tree, IMDObject[] objects) {
        if (tree.getTree().isDisposed() || !tree.getTree().isVisible() || objects == null || objects.length == 0 || !(tree.getContentProvider() instanceof MDTreeContentProvider)) {
            return;
        }
        MDTreeContentProvider provider = (MDTreeContentProvider)tree.getContentProvider();
        for (int i = 0; i < objects.length; ++i) {
            IMDObject obj = objects[i];
            if (!provider.isVisible(obj)) continue;
            if (!(obj instanceof IMDResource)) {
                tree.update((Object)obj, null);
            } else {
                IMDResource res = (IMDResource)obj;
                MDObjectAdapter adapter = new MDObjectAdapter(res);
                tree.update((Object)adapter, null);
                if (!provider.isUseSingleRoot() && res.toFile().exists()) {
                    adapter.setInSrcBranch(true);
                    tree.update((Object)adapter, null);
                }
            }
            tree.update((Object)objects[i], null);
        }
    }

    public static void refreshTree(TreeViewer tree, IMDObject[] objects) {
        if (tree.getTree().isDisposed() || !tree.getTree().isVisible() || objects == null || objects.length == 0 || !(tree.getContentProvider() instanceof MDTreeContentProvider)) {
            return;
        }
        MDTreeContentProvider provider = (MDTreeContentProvider)tree.getContentProvider();
        tree.getControl().setRedraw(false);
        for (int i = 0; i < objects.length; ++i) {
            IMDObject obj = objects[i];
            if (obj.toFile().exists() && !provider.isVisible(obj)) continue;
            if (obj instanceof IMDResource) {
                MDObjectAdapter[] adapters = provider.getParentObjectInTree((IMDResource)obj);
                for (int j = 0; j < adapters.length; ++j) {
                    tree.refresh((Object)adapters[j]);
                }
                continue;
            }
            tree.refresh((Object)new MDObjectAdapter(obj));
        }
        tree.getControl().setRedraw(true);
    }

    public static boolean removeProjectNode(TreeViewer tree, IMDProject project) {
        tree.refresh();
        return true;
    }
}

