/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tool.check;

import com.kingdee.bos.metadata.management.application.MetaDataInfo;
import com.kingdee.bos.tool.ToolBasePlugin;
import com.kingdee.bos.tool.check.IVerifyListener;
import com.kingdee.bos.tool.console.IUserStream;
import com.kingdee.bos.tool.console.UserStreamManager;
import com.kingdee.util.DateTimeUtils;
import java.util.Date;
import org.eclipse.swt.graphics.Color;

public class ConsoleVerifyListener
implements IVerifyListener {
    IUserStream stream = null;

    public ConsoleVerifyListener(String s) {
        String id = s + " (" + DateTimeUtils.format((Date)new Date(System.currentTimeMillis())) + ")";
        this.stream = ToolBasePlugin.getDefault().getUserStream(id);
    }

    public ConsoleVerifyListener(IUserStream stream) {
        assert (stream != null) : "Parameter IUserStream cann't be null";
        this.stream = stream;
    }

    public IUserStream getUserStream() {
        return this.stream;
    }

    @Override
    public void addError(MetaDataInfo md, String msg) {
        Color c = UserStreamManager.ERROR_COLOR;
        this.stream.println(msg, c);
    }

    @Override
    public void addWarning(MetaDataInfo md, String msg) {
        Color c = UserStreamManager.NORMAL_COLOR;
        this.stream.println(msg, c);
    }

    @Override
    public void addFatal(MetaDataInfo md, String msg) {
        Color c = UserStreamManager.ERROR_COLOR;
        this.stream.println(msg, c);
    }

    @Override
    public void addInfo(MetaDataInfo md, String msg) {
        Color c = UserStreamManager.NORMAL_COLOR;
        this.stream.println(msg, c);
    }

    public void close() {
        if (this.stream != null) {
            this.stream.close();
        }
    }
}

