/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tool.connection;

import com.kingdee.bos.tool.ToolCommonPlugin;
import com.kingdee.bos.tool.connection.GroupExtensionPointProcess;
import com.kingdee.bos.tool.connection.IConnection;
import com.kingdee.bos.tool.connection.IGroup;
import com.kingdee.bos.tool.connection.Property;
import com.kingdee.bos.tool.utils.XMLResourceManager;
import com.kingdee.util.StringUtils;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.util.SafeRunnable;
import org.jdom2.Content;
import org.jdom2.Element;
import org.osgi.framework.Bundle;

public class ConnectionManager {
    public static final String CONNECTION_FILE_NAME = "connections.xml";
    public static final String E_CONFIG = "config";
    public static final String E_CONNECTION_SET = "connections";
    public static final String E_GROUP = "group";
    public static final String E_CONNECTION = "connection";
    public static final String E_NAME = "name";
    public static final String E_ID = "id";
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.bos.tool.connection.ConnectionManager");
    private static Map connections = new HashMap();

    public static void load() {
        connections.clear();
        connections = ConnectionManager.load(ConnectionManager.getDefaultFilePath());
    }

    public static Map load(String filePath) {
        HashMap<String, Map> map = new HashMap<String, Map>();
        Map groups = GroupExtensionPointProcess.getGroups();
        for (String groupId : groups.keySet()) {
            map.put(groupId, new HashMap());
        }
        if (StringUtils.isEmpty((String)filePath)) {
            return map;
        }
        Element eroot = XMLResourceManager.loadFromXML((String)filePath);
        if (eroot == null) {
            return map;
        }
        Element dses = eroot.getChild(E_CONNECTION_SET);
        if (dses == null || dses.getChildren().isEmpty()) {
            return map;
        }
        for (Element el : dses.getChildren()) {
            String groupId = el.getAttributeValue(E_ID);
            IGroup group = (IGroup)GroupExtensionPointProcess.getGroups().get(groupId);
            if (group == null) continue;
            map.put(groupId, ConnectionManager.getGroup(el, group));
        }
        return map;
    }

    public static boolean store() {
        return ConnectionManager.store(ConnectionManager.getDefaultFilePath());
    }

    public static boolean store(String filePath) {
        Element eset;
        if (StringUtils.isEmpty((String)filePath)) {
            return false;
        }
        Element eroot = XMLResourceManager.loadFromXML((String)filePath);
        if (eroot == null) {
            eroot = new Element(E_CONFIG);
        }
        if ((eset = eroot.getChild(E_CONNECTION_SET)) == null) {
            eset = new Element(E_CONNECTION_SET);
            eroot.addContent((Content)eset);
        }
        eset.removeChildren(null, null);
        for (String groupId : connections.keySet()) {
            Element egroup = new Element(E_GROUP);
            egroup.setAttribute(E_ID, groupId);
            eset.addContent((Content)egroup);
            Map map = (Map)connections.get(groupId);
            IGroup group = (IGroup)GroupExtensionPointProcess.getGroups().get(groupId);
            for (String connectionName : map.keySet()) {
                Element econ = new Element(E_CONNECTION);
                econ.setAttribute(E_NAME, connectionName);
                egroup.addContent((Content)econ);
                IConnection connection = (IConnection)map.get(connectionName);
                for (int i = 0; i < group.getProperties().length; ++i) {
                    Property property = group.getProperties()[i];
                    String value = connection.getValue(property.getId()).toString();
                    if (value == null) continue;
                    Element eprop = new Element(property.getId());
                    eprop.setText(value);
                    econ.addContent((Content)eprop);
                }
            }
        }
        int issuccess = XMLResourceManager.saveToXML((Element)eroot, (String)filePath);
        return issuccess == 0;
    }

    public static Map getConnections() {
        return connections;
    }

    public static Map getConnectionByGroup(String groupId) {
        Object obj = connections.get(groupId);
        if (obj == null) {
            return new HashMap();
        }
        return (Map)obj;
    }

    public static IConnection makeConnection(final IGroup group) {
        final IConnection[] connection = new IConnection[]{null};
        Platform.run((ISafeRunnable)new SafeRunnable(){

            public void run() {
                try {
                    Bundle bundle = group.getCurrentBundle();
                    Class classInstance = bundle.loadClass(group.getClassName());
                    connection[0] = (IConnection)classInstance.newInstance();
                    for (int k = 0; k < group.getProperties().length; ++k) {
                        Property prop = group.getProperties()[k];
                        if (prop.getType().equalsIgnoreCase("int")) {
                            connection[0].setValue(prop.getId(), new Integer(0));
                        } else if (prop.getType().equalsIgnoreCase("string")) {
                            connection[0].setValue(prop.getId(), "");
                        } else if (prop.getType().equalsIgnoreCase("boolean")) {
                            connection[0].setValue(prop.getId(), new Boolean(false));
                        } else {
                            String type = prop.getType();
                            String value = type.substring(0, type.indexOf(","));
                            connection[0].setValue(prop.getId(), value);
                        }
                        connection[0].initValue();
                    }
                }
                catch (Exception e) {
                    logger.error((Object)("instance IConnection '" + group.getClassName() + "' failed"), (Throwable)e);
                }
            }
        });
        return connection[0];
    }

    private static String getDefaultFilePath() {
        IPath path = ToolCommonPlugin.getDefault().getStateLocation();
        path = path.append(CONNECTION_FILE_NAME);
        return path.toOSString();
    }

    private static Map getGroup(Element el, IGroup group) {
        HashMap<String, IConnection> cg = new HashMap<String, IConnection>();
        Map map = ConnectionManager.getPropertyMap(group);
        for (Element child : el.getChildren()) {
            IConnection connection = ConnectionManager.makeConnection(group);
            if (connection == null) continue;
            String connectionName = child.getAttributeValue(E_NAME);
            connection.setName(connectionName);
            for (Element eprop : child.getChildren()) {
                String key = eprop.getName();
                if (!map.keySet().contains(key)) continue;
                String value = eprop.getTextTrim();
                String type = ((Property)map.get(key)).getType();
                Object v = type.equalsIgnoreCase("int") ? new Integer(value) : (type.equalsIgnoreCase("boolean") ? new Boolean(value) : value);
                connection.setValue(key, v);
            }
            cg.put(connectionName, connection);
        }
        return cg;
    }

    private static Map getPropertyMap(IGroup group) {
        HashMap<String, Property> map = new HashMap<String, Property>();
        for (int i = 0; i < group.getProperties().length; ++i) {
            map.put(group.getProperties()[i].getId(), group.getProperties()[i]);
        }
        return map;
    }

    static {
        GroupExtensionPointProcess.getGroups();
        ConnectionManager.load();
    }
}

