/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tool.dao;

import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.xml.Utils;
import com.kingdee.bos.md.mdfs.IMDProject;
import com.kingdee.bos.md.mdfs.MDResourceUtil;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPKFactory;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.management.PackageInfo;
import com.kingdee.bos.metadata.management.SolutionInfo;
import com.kingdee.bos.metadata.management.application.AppViewInfo;
import com.kingdee.bos.metadata.management.application.MetaDataInfo;
import com.kingdee.bos.service.log.define.LogInfo;
import com.kingdee.bos.service.mutex.MutexInfo;
import com.kingdee.bos.tool.common.IDEException;
import com.kingdee.bos.tool.context.IToolContext;
import com.kingdee.bos.tool.context.ToolContextManager;
import com.kingdee.bos.tool.dao.CopyCommand;
import com.kingdee.bos.tool.dao.CreateFileCommand;
import com.kingdee.bos.tool.dao.CreatePackageCommand;
import com.kingdee.bos.tool.dao.ICommand;
import com.kingdee.bos.tool.dao.MetaDataRunner;
import com.kingdee.bos.tool.dao.ORMStudioBridger;
import com.kingdee.bos.tool.dao.RenameCommand;
import com.kingdee.bos.tool.dao.UpdateFileCommand;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;

public class ORMUtil {
    public static final String DEFAULT_PACKAGE_NAME = "default";
    public static final String SERVICE_NAME = "service";
    public static final String SERVICE_ROOT_PACKAGE = "";

    public static void createServices(IFolder folder, IProgressMonitor monitor) throws IDEException {
        ICommand[] commands = new ICommand[]{ORMUtil.createLog(folder), ORMUtil.createMutex(folder)};
        ORMUtil.executeRunner(commands, monitor);
    }

    private static ICommand createLog(IFolder folder) {
        LogInfo model = new LogInfo();
        model.setPackage(SERVICE_ROOT_PACKAGE);
        model.setName(SERVICE_NAME);
        IFile file = ORMUtil.getFile(folder, (IObjectValue)model);
        return new CreateFileCommand((IObjectValue)model, file);
    }

    private static ICommand createMutex(IFolder folder) {
        MutexInfo model = new MutexInfo();
        model.setPackage(SERVICE_ROOT_PACKAGE);
        model.setName(SERVICE_NAME);
        IFile file = ORMUtil.getFile(folder, (IObjectValue)model);
        return new CreateFileCommand((IObjectValue)model, file);
    }

    public static AppViewInfo getAppViewInfo(IProject project) throws IDEException {
        IMetaDataPK pk = MetaDataPKFactory.getMetaDataPK((String)"bos");
        IFile file = ORMUtil.getFile(project, MetaDataTypeList.APPVIEW, pk);
        return (AppViewInfo)ORMUtil.load(file);
    }

    public static SolutionInfo getSolution(IProject project) throws IDEException {
        return MDResourceUtil.toMDProject(project).getSolutionInfo();
    }

    public static IFile getFile(IFolder folder, IObjectValue value) {
        String pkName = value.getString("package");
        String name = value.getString("name");
        IMetaDataPK pk = MetaDataPKFactory.getMetaDataPK((String)(pkName + "." + name));
        BOSObjectType bosType = value.getBOSType();
        if (value instanceof MetaDataInfo) {
            MetaDataInfo mdi = (MetaDataInfo)value;
            String type = mdi.getMetaDataType();
            bosType = BOSObjectType.create((String)type);
        }
        return ORMUtil.getFile(folder, bosType, pk);
    }

    public static IFile getFile(IProject project, IObjectValue value) {
        IToolContext ctx = ToolContextManager.getContext(project);
        IFolder folder = project.getFolder(ctx.getSrcName());
        return ORMUtil.getFile(folder, value);
    }

    public static IFile getFile(IFolder folder, BOSObjectType type, IMetaDataPK pk) {
        String extension = Utils.getMetaDataSuffix((BOSObjectType)type);
        String pkName = pk.getPackage();
        String objName = pk.getName();
        if (!StringUtils.isEmpty((String)pkName)) {
            StringTokenizer tokenizer = new StringTokenizer(pkName, ".");
            while (tokenizer.hasMoreElements()) {
                String token = (String)tokenizer.nextElement();
                folder = folder.getFolder(token);
            }
        }
        return folder.getFile(objName + extension);
    }

    public static IFile getFile(IProject project, BOSObjectType type, IMetaDataPK pk) {
        IToolContext ctx = ToolContextManager.getContext(project);
        IFolder folder = project.getFolder(ctx.getSrcName());
        return ORMUtil.getFile(folder, type, pk);
    }

    public static IFile getFile(IProject project, BOSObjectType type, String pk) {
        IMetaDataPK mpk;
        IToolContext ctx = ToolContextManager.getContext(project);
        IFolder folder = project.getFolder(ctx.getSrcName());
        IFile ret = ORMUtil.getFile(folder, type, mpk = MetaDataPKFactory.getMetaDataPK((String)pk));
        if (!ret.exists() && ctx.isExtSolution()) {
            Vector stds = ctx.getStdDirs();
            int size = stds.size();
            for (int i = 0; i < size && !(ret = ORMUtil.getFile(folder = project.getFolder((String)stds.get(i)), type, mpk)).exists(); ++i) {
            }
        }
        return ORMUtil.getFile(folder, type, mpk);
    }

    public static IFolder getPackageFolder(IProject project, String packageName) {
        IToolContext ctx = ToolContextManager.getContext(project);
        IFolder folder = project.getFolder(ctx.getSrcName());
        if (!StringUtils.isEmpty((String)packageName)) {
            StringTokenizer tokenizer = new StringTokenizer(packageName, ".");
            while (tokenizer.hasMoreElements()) {
                String token = (String)tokenizer.nextElement();
                folder = folder.getFolder(token);
            }
        }
        return folder;
    }

    public static IFile getFile(IFolder folder, MetaDataInfo metaInfo) {
        BOSObjectType type = BOSObjectType.create((String)metaInfo.getMetaDataType());
        String objFullName = metaInfo.getFullName();
        IMetaDataPK pk = MetaDataPKFactory.getMetaDataPK((String)objFullName);
        return ORMUtil.getFile(folder, type, pk);
    }

    public static IFile getFile(String absolutePath) {
        Path path = new Path(absolutePath);
        IWorkspace ws = ResourcesPlugin.getWorkspace();
        IFile[] files = ws.getRoot().findFilesForLocation((IPath)path);
        if (files.length > 0) {
            return files[0];
        }
        return null;
    }

    public static BOSObjectType getType(String fileName) {
        int dot = fileName.lastIndexOf(".");
        if (dot != -1) {
            String extension = fileName.substring(dot + 1);
            return BOSObjectType.create((String)Utils.getBOSTypeBySuffix((String)extension));
        }
        return null;
    }

    public static void executeRunner(ICommand[] commands, IProgressMonitor monitor) throws IDEException {
        try {
            MetaDataRunner runner = new MetaDataRunner(commands);
            ResourcesPlugin.getWorkspace().run((IWorkspaceRunnable)runner, monitor);
        }
        catch (CoreException e) {
            throw new IDEException("metadata access error", (Throwable)e);
        }
    }

    public static IObjectValue load(IFile file) throws IDEException {
        try {
            return ORMStudioBridger.load(file);
        }
        catch (Exception e) {
            throw new IDEException("\u88c5\u8f7d\u5143\u6570\u636e\u6587\u4ef6\u65f6\u51fa\u9519" + file, (Throwable)e);
        }
    }

    public static void rename(IFile file, String packageName, String name, IProgressMonitor monitor) throws IDEException {
        ICommand[] commands = new ICommand[]{new RenameCommand(file, packageName, name)};
        ORMUtil.executeRunner(commands, monitor);
    }

    public static void copy(IFile file, String packageName, String name, IProgressMonitor monitor) throws IDEException {
        ICommand[] commands = new ICommand[]{new CopyCommand(file, packageName, name)};
        ORMUtil.executeRunner(commands, monitor);
    }

    public static void store(IObjectValue model, IFile file, IProgressMonitor monitor) throws IDEException {
        ICommand[] commands = new ICommand[]{new UpdateFileCommand(model, file)};
        ORMUtil.executeRunner(commands, monitor);
    }

    public static void createFile(IObjectValue model, IFile file, IProgressMonitor monitor) throws IDEException {
        ICommand[] commands = new ICommand[]{new CreateFileCommand(model, file)};
        ORMUtil.executeRunner(commands, monitor);
    }

    public static void createFile(IObjectValue model, IMDProject project, IProgressMonitor monitor) throws IDEException {
        ICommand[] commands = new ICommand[]{new CreateFileCommand(model, MDResourceUtil.toIFile(MDResourceUtil.getFile(project, model)))};
        ORMUtil.executeRunner(commands, monitor);
    }

    public static void createPackage(IFolder folder, PackageInfo info, IProgressMonitor monitor) throws IDEException {
        ICommand[] commands = new ICommand[]{new CreatePackageCommand(folder, info)};
        ORMUtil.executeRunner(commands, monitor);
    }

    public static void createPackage(IProject project, PackageInfo info, IProgressMonitor monitor) throws IDEException {
        IToolContext ctx = ToolContextManager.getContext(project);
        IFolder folder = project.getFolder(ctx.getSrcName());
        ICommand[] commands = new ICommand[]{new CreatePackageCommand(folder, info)};
        ORMUtil.executeRunner(commands, monitor);
    }

    public static IObjectValue getObjectValue(IFolder folder, IMetaDataPK pk, BOSObjectType bosType, String str) throws IDEException {
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(str.getBytes("UTF-8"));
            IFile file = ORMStudioBridger.getFileByPK(folder, pk, bosType);
            file.setContents((InputStream)in, true, true, null);
            return ORMStudioBridger.load(file);
        }
        catch (UnsupportedEncodingException e) {
            throw new IDEException(SERVICE_ROOT_PACKAGE, (Throwable)e);
        }
        catch (CoreException e) {
            throw new IDEException(SERVICE_ROOT_PACKAGE, (Throwable)e);
        }
    }

    public static MetaDataInfo getMetaData(IFile file) {
        IMetaDataPK pk = ORMStudioBridger.getFilePK((IResource)file);
        String type = Utils.getBOSTypeBySuffix((String)file.getFileExtension());
        MetaDataInfo md = new MetaDataInfo();
        md.setPackage(pk.getPackage());
        md.setName(pk.getName());
        md.setMetaDataType(type);
        return md;
    }

    public static boolean isMetaDataFile(IFile file) {
        String type = Utils.getBOSTypeBySuffix((String)file.getFileExtension());
        if (type == null || type.length() == 0) {
            return false;
        }
        IToolContext ctx = ToolContextManager.getContext(file.getProject());
        if (ctx == null) {
            return false;
        }
        IFolder root = ORMStudioBridger.getFolder((IResource)file);
        if (root == null) {
            root = file.getProject().getFolder(ctx.getSrcName());
        }
        return root.getFullPath().isPrefixOf(file.getFullPath());
    }
}

