/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tool.dbupdate;

import com.kingdee.bos.metadata.management.PackageInfo;
import com.kingdee.bos.tool.FileUtils;
import com.kingdee.bos.tool.dbupdate.DBCreateXml;
import com.kingdee.bos.tool.dbupdate.data.DBUpdateInfo;
import com.kingdee.bos.tool.dbupdate.data.DBUpdateList;
import com.kingdee.util.StringUtils;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

public class DBCreateTableSql {
    private static final String SEPARATOR = System.getProperty("file.separator");
    private DBCreateXml createXml = null;
    private String packageName;
    private DBUpdateList updateList = new DBUpdateList();

    public DBCreateTableSql(DBCreateXml createXml, PackageInfo pInfo) {
        this.createXml = createXml;
        this.packageName = pInfo.getPackage();
    }

    public DBCreateTableSql(DBCreateXml createXml, String packageName) {
        this.createXml = createXml;
        this.packageName = packageName;
    }

    public DBUpdateList getUpdateList() {
        return this.updateList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File create(String scriptPath) throws IOException {
        File file = null;
        if (this.updateList.size() > 0) {
            File path = new File(this.getFilePath(scriptPath));
            if (!path.exists()) {
                path.mkdirs();
            }
            file = new File(this.getFilePath(scriptPath) + SEPARATOR + "createtable.sql");
            FileOutputStream fileOutputStream = null;
            BufferedOutputStream bfs = null;
            try {
                fileOutputStream = new FileOutputStream(file);
                bfs = new BufferedOutputStream(fileOutputStream);
                int n = this.updateList.size();
                for (int i = 0; i < n; ++i) {
                    DBUpdateInfo updateInfo = this.updateList.getInfo(i);
                    String statement = DBCreateTableSql.createStatement4Update(updateInfo);
                    bfs.write(statement.getBytes("UTF-8"));
                }
                bfs.flush();
            }
            catch (Throwable throwable) {
                FileUtils.close(fileOutputStream);
                FileUtils.close(bfs);
                throw throwable;
            }
            FileUtils.close(fileOutputStream);
            FileUtils.close(bfs);
        }
        return file;
    }

    public String getFilePath(String scriptPath) {
        return scriptPath + SEPARATOR + this.getRelativePath();
    }

    public String getRelativePath() {
        String path = StringUtils.replace((String)this.packageName, (String)".app", (String)"");
        path = path.equalsIgnoreCase(this.createXml.getPackageName()) ? "" : StringUtils.replace((String)path, (String)(this.createXml.getPackageName() + "."), (String)"");
        path = StringUtils.replace((String)path, (String)".", (String)SEPARATOR);
        path = StringUtils.isEmpty((String)path) ? this.createXml.getRelativePath() : this.createXml.getRelativePath() + SEPARATOR + path;
        return path;
    }

    private static String createStatement4Update(DBUpdateInfo updateInfo) {
        return updateInfo.getSql() + ";\n\n";
    }
}

