/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tool.dbupdate;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.engine.impl.Loader2;
import com.kingdee.bos.metadata.AbstractMetaDataValue;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataHeavyLoadCache;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.MetaDataUtils;
import com.kingdee.bos.metadata.data.AbstractTableInfo;
import com.kingdee.bos.metadata.data.ColumnCollection;
import com.kingdee.bos.metadata.data.ColumnInfo;
import com.kingdee.bos.metadata.data.DataTableCollection;
import com.kingdee.bos.metadata.data.IndexCollection;
import com.kingdee.bos.metadata.data.IndexColumnCollection;
import com.kingdee.bos.metadata.data.IndexColumnInfo;
import com.kingdee.bos.metadata.data.IndexInfo;
import com.kingdee.bos.metadata.data.PKColumnCollection;
import com.kingdee.bos.metadata.data.PKColumnInfo;
import com.kingdee.bos.metadata.data.PrimaryKeyInfo;
import com.kingdee.bos.metadata.data.SQLType;
import com.kingdee.bos.metadata.management.LanguageCollection;
import com.kingdee.bos.metadata.management.LanguageInfo;
import com.kingdee.bos.metadata.management.PackageCollection;
import com.kingdee.bos.metadata.management.PackageCtrl;
import com.kingdee.bos.metadata.management.PackageInfo;
import com.kingdee.bos.metadata.management.SolutionInfo;
import com.kingdee.bos.metadata.util.MetaDataLoader;
import com.kingdee.bos.tool.FileUtils;
import com.kingdee.bos.tool.dbupdate.DBCreateIndexSql;
import com.kingdee.bos.tool.dbupdate.DBCreateTableSql;
import com.kingdee.bos.tool.dbupdate.DBCreateXml;
import com.kingdee.bos.tool.dbupdate.DBCreateXmlRoot;
import com.kingdee.bos.tool.dbupdate.DBUpdateException;
import com.kingdee.bos.tool.dbupdate.DBUpdateStrategy;
import com.kingdee.bos.tool.dbupdate.data.DBUpdateInfo;
import com.kingdee.bos.tool.dbupdate.data.DBUpdateList;
import com.kingdee.bos.tool.dbupdate.dbtools.DBSchema;
import com.kingdee.bos.tool.dbupdate.dbtools.DBSchemaDAO;
import com.kingdee.bos.tool.dbupdate.dbtools.DBUtils;
import com.kingdee.bos.tool.dbupdate.engine.DBUpdateEngineImpl;
import com.kingdee.bos.tool.dbupdate.report.Report;
import com.kingdee.bos.tool.dbupdate.report.ReportUtil;
import com.kingdee.util.ObjectUtils;
import com.kingdee.util.StringUtils;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class DBUpdateUtils {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.bos.tool.dbupdate.DBUpdateUtils");
    private static final String TAB = "\t\t";
    private static final String SEPARATOR = System.getProperty("file.separator");

    public static String[] Update(Connection cn, List tables, String path, String slnName) throws SQLException {
        DBUpdateEngineImpl dbUpdateEngine = new DBUpdateEngineImpl();
        DBUpdateList dbUpdateList = dbUpdateEngine.generateUpdateScript(cn, dbUpdateEngine.getDifferenceReport(cn, DBUpdateUtils.getTables(tables, path, slnName)));
        int size = dbUpdateList.size();
        String[] sqls = new String[size];
        for (int i = 0; i < size; ++i) {
            sqls[i] = ((DBUpdateInfo)dbUpdateList.get(i)).getSql();
        }
        return sqls;
    }

    public static AbstractTableInfo[] getTables(String metadataPath, String solutionName) {
        logger.debug((Object)"\u6b63\u5728\u6267\u884c\u88c5\u8f7d\u6570\u636e\u8868\u5143\u6570\u636e...");
        Context ctx = new Context(null, solutionName, "", new Locale("l2"));
        ctx.put((Object)"METADATAPATH", (Object)metadataPath);
        DataTableCollection tables = MetaDataLoader.getDataTableCollection((Context)ctx);
        AbstractTableInfo[] tableInfos = new AbstractTableInfo[tables.size()];
        int n = tables.size();
        for (int i = 0; i < n; ++i) {
            tableInfos[i] = tables.get(i);
        }
        logger.debug((Object)"\u6b63\u5728\u6267\u884c\u88c5\u8f7d\u6570\u636e\u8868\u5143\u6570\u636e...\u6267\u884c\u5b8c\u6bd5!");
        return tableInfos;
    }

    private static AbstractTableInfo[] getTables(List tables, String path, String slnName) {
        logger.debug((Object)"\u6b63\u5728\u6267\u884c\u88c5\u8f7d\u6570\u636e\u8868\u5143\u6570\u636e...");
        Context ctx = new Context(null, slnName, "", new Locale("l2"));
        ctx.put((Object)"METADATAPATH", (Object)path);
        AbstractTableInfo[] tableInfos = new AbstractTableInfo[tables.size()];
        int n = tables.size();
        for (int i = 0; i < n; ++i) {
            tableInfos[i] = MetaDataLoader.getDataTable((Context)ctx, (IMetaDataPK)new MetaDataPK(tables.get(i).toString()));
        }
        logger.debug((Object)"\u6b63\u5728\u6267\u884c\u88c5\u8f7d\u6570\u636e\u8868\u5143\u6570\u636e...\u6267\u884c\u5b8c\u6bd5!");
        return tableInfos;
    }

    public static boolean updateDatabase(Connection cn, String metadataPath, String solutionName, AbstractTableInfo[] tables) throws DBUpdateException, SQLException {
        DBUpdateEngineImpl dbUpdateEngine = new DBUpdateEngineImpl();
        SolutionInfo solution = DBUpdateUtils.getSolution(metadataPath, solutionName);
        if (solution == null) {
            throw new DBUpdateException("Can not found " + solutionName + " solution!");
        }
        String[] languages = DBUpdateUtils.getMultiLanguages(solution);
        AbstractTableInfo[] newTables = DBUpdateUtils.ignoreDataView(tables);
        newTables = DBUpdateUtils.addMultilangColumns(newTables, languages);
        Report report = dbUpdateEngine.getDifferenceReport(cn, newTables);
        DBUpdateList dbUpdateList = dbUpdateEngine.generateUpdateScript(cn, report);
        return DBUpdateUtils.updateDatabase(cn, dbUpdateList);
    }

    public static boolean updateDatabase(Connection cn, String metadataPath, String solutionName) throws DBUpdateException, SQLException {
        AbstractTableInfo[] tables = DBUpdateUtils.getTables(metadataPath, solutionName);
        return DBUpdateUtils.updateDatabase(cn, metadataPath, solutionName, tables);
    }

    public static boolean updateDatabase(Connection cn, String metadataPath, String solutionName, String[] tablePKs) throws DBUpdateException, SQLException {
        ArrayList<String> list = new ArrayList<String>();
        int n = tablePKs.length;
        for (int i = 0; i < n; ++i) {
            if (StringUtils.isEmpty((String)tablePKs[i])) continue;
            list.add(tablePKs[i]);
        }
        AbstractTableInfo[] tables = DBUpdateUtils.getTables(list, metadataPath, solutionName);
        return DBUpdateUtils.updateDatabase(cn, metadataPath, solutionName, tables);
    }

    public static boolean updateDatabase(Connection cn, DBUpdateList updateList) throws DBUpdateException {
        logger.debug((Object)"\u6b63\u5728\u66f4\u65b0\u6570\u636e\u5e93\u8868\u7ed3\u6784...");
        String sql = "";
        try {
            int n = updateList.size();
            for (int i = 0; i < n; ++i) {
                DBUpdateInfo info = (DBUpdateInfo)updateList.get(i);
                if (info.getType() == 17) continue;
                sql = info.getSql();
                if (info.getType() == 9 && !sql.startsWith("/*dialect*/")) {
                    sql = "/*dialect*/" + sql;
                }
                Statement stmt = cn.createStatement();
                if (info.getType() == 8) {
                    String sqlGetRs = "";
                    String tableName = info.getName();
                    String tempTableName = ReportUtil.getTempTableName(tableName);
                    sqlGetRs = "Select Count(*) as FCount From " + tableName;
                    ResultSet rs = stmt.executeQuery(sqlGetRs);
                    int tableRowCount = -1;
                    if (rs.next()) {
                        tableRowCount = rs.getInt("FCount");
                    }
                    rs.close();
                    if (tableRowCount > 0) {
                        sqlGetRs = "Select Count(*) as FCount From " + tempTableName;
                        rs = stmt.executeQuery(sqlGetRs);
                        int tempTableRowCount = -1;
                        if (rs.next()) {
                            tempTableRowCount = rs.getInt("FCount");
                        }
                        rs.close();
                        if (tableRowCount > tempTableRowCount) {
                            throw new DBUpdateException(" \u5f53\u524d\u6570\u636e\u540c\u6b65\u51fa\u73b0\u6570\u636e\u4e0d\u540c\u6b65\u7684\u95ee\u9898\uff0c\u4e0d\u80fd\u6267\u884c\u5f53\u524d\u7684\u64cd\u4f5c\uff0c\u8bf7\u4ece\u65b0\u518d\u8bd5\u8bd5\uff01");
                        }
                    }
                }
                logger.debug((Object)sql);
                int type = DBUtils.getDbType(cn);
                if (info.getType() == 2 && !StringUtils.isEmpty((String)info.getTableName()) && DBUtils.isOracle(type)) {
                    try {
                        stmt.execute(sql);
                        stmt.close();
                    }
                    catch (SQLException e) {
                        String newsql = " ALTER TABLE " + info.getTableName() + " DROP CONSTRAINT " + info.getName();
                        logger.debug((Object)newsql);
                        stmt.execute(newsql);
                        stmt.execute(sql);
                        stmt.close();
                    }
                    continue;
                }
                stmt.execute(sql);
                stmt.close();
            }
        }
        catch (SQLException e) {
            logger.debug((Object)"\u6b63\u5728\u66f4\u65b0\u6570\u636e\u5e93\u8868\u7ed3\u6784...\u66f4\u65b0\u5931\u8d25!");
            logger.error((Object)("Error at execute sql:" + sql), (Throwable)e);
            try {
                cn.rollback();
            }
            catch (Throwable t) {
                logger.error((Object)"rollbak error", t);
            }
            throw new DBUpdateException("Error at execute sql:" + sql, e);
        }
        logger.debug((Object)"\u6b63\u5728\u66f4\u65b0\u6570\u636e\u5e93\u8868\u7ed3\u6784...\u66f4\u65b0\u5b8c\u6bd5!");
        return true;
    }

    public static boolean generateDBScript(Connection cn, String metadataPath, String solutionName, String scriptPath, AbstractTableInfo[] tables) throws DBUpdateException, FileNotFoundException, SQLException {
        DBUpdateEngineImpl dbUpdateEngine = new DBUpdateEngineImpl();
        SolutionInfo solution = DBUpdateUtils.getSolution(metadataPath, solutionName);
        if (solution == null) {
            throw new DBUpdateException("Can not found " + solutionName + " solution!");
        }
        String[] languages = DBUpdateUtils.getMultiLanguages(solution);
        AbstractTableInfo[] newTables = DBUpdateUtils.ignoreDataView(tables);
        newTables = DBUpdateUtils.addMultilangColumns(newTables, languages);
        Report report = dbUpdateEngine.getDifferenceReport(cn, newTables);
        DBUpdateList dbUpdateList = dbUpdateEngine.generateUpdateScript(cn, report);
        return DBUpdateUtils.generateDBScript(cn, metadataPath, solutionName, scriptPath, dbUpdateList);
    }

    public static boolean generateDBScript(Connection cn, String metadataPath, String solutionName, String scriptPath) throws DBUpdateException, FileNotFoundException, SQLException {
        AbstractTableInfo[] tables = DBUpdateUtils.getTables(metadataPath, solutionName);
        return DBUpdateUtils.generateDBScript(cn, metadataPath, solutionName, scriptPath, tables);
    }

    public static boolean generateDBScript(Connection cn, String metadataPath, String solutionName, String scriptPath, String[] tablePKs) throws DBUpdateException, FileNotFoundException, SQLException {
        ArrayList<String> list = new ArrayList<String>();
        int n = tablePKs.length;
        for (int i = 0; i < n; ++i) {
            if (StringUtils.isEmpty((String)tablePKs[i])) continue;
            list.add(tablePKs[i]);
        }
        AbstractTableInfo[] tables = DBUpdateUtils.getTables(list, metadataPath, solutionName);
        return DBUpdateUtils.generateDBScript(cn, metadataPath, solutionName, scriptPath, tables);
    }

    public static boolean generateDBScript(String metadataPath, String solutionName, String scriptPath) throws DBUpdateException, IOException {
        AbstractTableInfo[] tables = DBUpdateUtils.getTables(metadataPath, solutionName);
        SolutionInfo solution = DBUpdateUtils.getSolution(metadataPath, solutionName);
        if (solution == null) {
            throw new DBUpdateException("Can not found " + solutionName + " solution!");
        }
        String[] languages = DBUpdateUtils.getMultiLanguages(solution);
        AbstractTableInfo[] newTables = DBUpdateUtils.ignoreDataView(tables);
        newTables = DBUpdateUtils.addMultilangColumns(newTables, languages);
        return DBUpdateUtils.generateDBScript(metadataPath, solutionName, scriptPath, newTables);
    }

    public static boolean generateCreateDBScriptProcessError(String metadataPath, String solutionName, String scriptPath, List ignorePackages, List errorInfos) throws DBUpdateException, IOException {
        File scriptFile = new File(scriptPath);
        if (!scriptFile.exists()) {
            scriptFile.mkdirs();
        }
        AbstractTableInfo[] tables = DBUpdateUtils.getTablesByNewLoader(metadataPath, solutionName);
        HashMap<String, AbstractTableInfo> newtables = new HashMap<String, AbstractTableInfo>();
        ArrayList<String> errTables = errorInfos;
        if (errTables == null) {
            errTables = new ArrayList<String>();
        }
        for (int i = 0; i < tables.length; ++i) {
            if (DBUpdateUtils.isIgnore(tables[i].getPackage(), ignorePackages)) continue;
            if (newtables.get(tables[i].getName().toLowerCase()) == null) {
                newtables.put(tables[i].getName().toLowerCase(), tables[i]);
                continue;
            }
            String errtbl = "Table:[" + tables[i].getFullName() + "] equals with[" + ((AbstractTableInfo)newtables.get(tables[i].getName().toLowerCase())).getFullName() + "]";
            errTables.add(errtbl);
            logger.debug((Object)("\u9519\u8bef\u8868\uff1a" + errtbl));
        }
        tables = newtables.values().toArray(new AbstractTableInfo[0]);
        HashMap<String, ArrayList<AbstractTableInfo>> topPacks = new HashMap<String, ArrayList<AbstractTableInfo>>();
        for (int i = 0; i < tables.length; ++i) {
            AbstractTableInfo table = tables[i];
            String pack = DBUpdateUtils.getTopPack(table);
            ArrayList<AbstractTableInfo> list = (ArrayList<AbstractTableInfo>)topPacks.get(pack);
            if (list == null) {
                list = new ArrayList<AbstractTableInfo>();
                topPacks.put(pack, list);
            }
            list.add(table);
        }
        tables = null;
        try {
            DBUpdateList updateList = new DBUpdateList();
            DBCreateXmlRoot rootCreateXml = new DBCreateXmlRoot();
            for (String pack : topPacks.keySet()) {
                List list = (List)topPacks.get(pack);
                if (list != null && list.size() > 0) {
                    DBUpdateUtils.generateDBScript(metadataPath, solutionName, scriptPath, list.toArray(new AbstractTableInfo[0]), updateList, false, rootCreateXml);
                }
                topPacks.put(pack, null);
            }
        }
        catch (DBUpdateException dBUpdateException) {
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        logger.info((Object)"\u751f\u6210\u8868\u5b8c\u6210!");
        return true;
    }

    private static AbstractTableInfo[] getTablesByNewLoader(String metadataPath, String solutionName) {
        logger.debug((Object)"\u6b63\u5728\u6267\u884c\u88c5\u8f7d\u6570\u636e\u8868\u5143\u6570\u636e...");
        Context ctx = new Context(null, solutionName, "", new Locale("l2"));
        ctx.put((Object)"METADATAPATH", (Object)metadataPath);
        MetaDataHeavyLoadCache loader = new MetaDataHeavyLoadCache(ctx);
        IObjectCollection tables = loader.getCollection(MetaDataTypeList.ABSTRACTTABLE);
        ArrayList<IObjectValue> tableList = new ArrayList<IObjectValue>();
        int n = tables.size();
        for (int i = 0; i < n; ++i) {
            tableList.add(tables.getObject(i));
        }
        AbstractTableInfo[] tableInfos = new AbstractTableInfo[tableList.size()];
        tableInfos = tableList.toArray(new AbstractTableInfo[0]);
        logger.debug((Object)"\u6b63\u5728\u6267\u884c\u88c5\u8f7d\u6570\u636e\u8868\u5143\u6570\u636e...\u6267\u884c\u5b8c\u6bd5!");
        return tableInfos;
    }

    private static boolean isIgnore(String spackage, List ignorePackages) {
        if (ignorePackages != null && !StringUtils.isEmpty((String)spackage)) {
            for (int i = 0; i < ignorePackages.size(); ++i) {
                if (ignorePackages.get(i) == null || !((String)ignorePackages.get(i)).equalsIgnoreCase(spackage)) continue;
                return true;
            }
        }
        return false;
    }

    private static String getTopPack(AbstractTableInfo table) {
        String easPack = "com.kingdee.eas";
        String bosPack = "com.kingdee.bos";
        if (table.getPackage().startsWith("com.kingdee.bos")) {
            return "BOS";
        }
        String pack = table.getPackage();
        if (!pack.startsWith("com.kingdee.eas")) {
            return "OTHER";
        }
        if ((pack = pack.substring("com.kingdee.eas".length() + 1)).indexOf(46) != -1) {
            pack = pack.substring(0, pack.indexOf(46));
        }
        return pack;
    }

    public static boolean generateUpdateDBScriptProcessError(Connection cn, String metadataPath, String solutionName, String scriptPath, List ignorePackages, List errorInfos) throws DBUpdateException, FileNotFoundException, SQLException {
        File scriptFile = new File(scriptPath);
        if (!scriptFile.exists()) {
            scriptFile.mkdirs();
        }
        AbstractTableInfo[] tables = DBUpdateUtils.getTablesByNewLoader(metadataPath, solutionName);
        HashMap<String, AbstractTableInfo> newtables = new HashMap<String, AbstractTableInfo>();
        ArrayList<String> errTables = errorInfos;
        if (errTables == null) {
            errTables = new ArrayList<String>();
        }
        for (int i = 0; i < tables.length; ++i) {
            if (DBUpdateUtils.isIgnore(tables[i].getPackage(), ignorePackages)) continue;
            if (newtables.get(tables[i].getName().toLowerCase()) == null) {
                newtables.put(tables[i].getName().toLowerCase(), tables[i]);
                continue;
            }
            String errtbl = "Table:[" + tables[i].getFullName() + "]equals with[" + ((AbstractTableInfo)newtables.get(tables[i].getName().toLowerCase())).getFullName() + "]";
            errTables.add(errtbl);
            logger.debug((Object)("\u9519\u8bef\u8868\uff1a" + errtbl));
        }
        tables = newtables.values().toArray(new AbstractTableInfo[0]);
        return DBUpdateUtils.generateUpdateDBScript(cn, metadataPath, solutionName, scriptPath, tables, false, errTables);
    }

    private static boolean generateUpdateDBScript(Connection cn, String metadataPath, String solutionName, String scriptPath, AbstractTableInfo[] tables, boolean copytable, List errors) throws DBUpdateException, FileNotFoundException, SQLException {
        DBUpdateEngineImpl dbUpdateEngine = new DBUpdateEngineImpl();
        SolutionInfo solution = DBUpdateUtils.getSolution(metadataPath, solutionName);
        if (solution == null) {
            throw new DBUpdateException("Can not found " + solutionName + " solution!");
        }
        String[] languages = DBUpdateUtils.getMultiLanguages(solution);
        AbstractTableInfo[] newTables = DBUpdateUtils.ignoreDataView(tables);
        newTables = DBUpdateUtils.addMultilangColumns(newTables, languages, copytable);
        Report report = dbUpdateEngine.getDifferenceReport(cn, newTables);
        DBUpdateList dbUpdateList = dbUpdateEngine.generateUpdateScript(cn, report);
        block0: for (int i = 0; i < dbUpdateList.size(); ++i) {
            DBUpdateInfo dbinfo = dbUpdateList.getInfo(i);
            if (dbinfo == null || 13 != dbinfo.getType()) continue;
            for (int j = dbUpdateList.size() - 1; j > i; --j) {
                DBUpdateInfo dbinfo2 = dbUpdateList.getInfo(j);
                if (dbinfo2 == null || 13 != dbinfo2.getType() || !dbinfo.getName().equalsIgnoreCase(dbinfo2.getName())) continue;
                String name = dbinfo.getName();
                String newname = name + "_err";
                String sql = dbinfo.getSql();
                sql = StringUtils.replace((String)sql, (String)("CONSTRAINT " + name), (String)("CONSTRAINT " + newname));
                dbinfo.setName(newname);
                dbinfo.setSql(sql);
                String serr = "\u9519\u8bef\u8868\uff1a" + dbinfo.getTableName() + ":PK:" + name;
                errors.add(serr);
                logger.debug((Object)serr);
                --i;
                continue block0;
            }
        }
        return DBUpdateUtils.generateDBScript(cn, metadataPath, solutionName, scriptPath, dbUpdateList);
    }

    public static boolean generateUpdateDBScriptAndUpdateDB(Connection cn, String metadataPath, String solutionName, String scriptPath, List packages, boolean isUpdateDataBase) throws DBUpdateException, FileNotFoundException, SQLException {
        SolutionInfo solution;
        if (StringUtils.isEmpty((String)solutionName)) {
            solutionName = "eas";
        }
        if ((solution = DBUpdateUtils.getSolution(metadataPath, solutionName)) == null) {
            throw new DBUpdateException("Can not found " + solutionName + " solution!");
        }
        File scriptFile = new File(scriptPath);
        if (!scriptFile.exists()) {
            scriptFile.mkdirs();
        }
        AbstractTableInfo[] tables = null;
        if (packages != null) {
            Context ctx = new Context(null, solutionName, "", new Locale("l2"));
            ctx.put((Object)"METADATAPATH", (Object)metadataPath);
            IMetaDataLoader loader = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx);
            ArrayList<IObjectValue> listtables = new ArrayList<IObjectValue>();
            for (int i = 0; i < packages.size(); ++i) {
                String pkgName = (String)packages.get(i);
                IObjectCollection curTables = loader.getAllObjectByPackage(MetaDataTypeList.ABSTRACTTABLE, pkgName);
                for (int j = 0; j < curTables.size(); ++j) {
                    listtables.add(curTables.getObject(j));
                }
            }
            if (listtables != null && listtables.size() > 0) {
                tables = listtables.toArray(new AbstractTableInfo[0]);
            }
        } else {
            tables = DBUpdateUtils.getTables(metadataPath, solutionName);
        }
        if (tables == null) {
            return false;
        }
        String[] languages = DBUpdateUtils.getMultiLanguages(solution);
        AbstractTableInfo[] newTables = DBUpdateUtils.ignoreDataView(tables);
        newTables = DBUpdateUtils.addMultilangColumns(newTables, languages);
        DBUpdateEngineImpl dbUpdateEngine = new DBUpdateEngineImpl();
        Report report = dbUpdateEngine.getDifferenceReport(cn, newTables);
        DBUpdateList updateList = dbUpdateEngine.generateUpdateScript(cn, report);
        DBUpdateUtils.generateDBScript(cn, metadataPath, solutionName, scriptPath, updateList);
        if (isUpdateDataBase) {
            DBUpdateUtils.updateDatabase(cn, updateList);
        }
        return true;
    }

    public static boolean generateUpdateDBScriptByMetas(String metadataPath, String solutionName, String oldmetaPath, String scriptPath, List packages) throws DBUpdateException, FileNotFoundException {
        SolutionInfo solution;
        if (StringUtils.isEmpty((String)solutionName)) {
            solutionName = "eas";
        }
        if ((solution = DBUpdateUtils.getSolution(metadataPath, solutionName)) == null) {
            throw new DBUpdateException("Can not found " + solutionName + " solution!");
        }
        File scriptFile = new File(scriptPath);
        if (!scriptFile.exists()) {
            scriptFile.mkdirs();
        }
        AbstractTableInfo[] tables = null;
        AbstractTableInfo[] otables = null;
        if (packages != null) {
            Context ctx = new Context(null, solutionName, "", new Locale("l2"));
            ctx.put((Object)"METADATAPATH", (Object)metadataPath);
            IMetaDataLoader loader = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx);
            Context oldctx = new Context(null, solutionName + "_old", "", new Locale("l2"));
            ctx.put((Object)"METADATAPATH", (Object)oldmetaPath);
            IMetaDataLoader oldLoader = MetaDataLoaderFactory.getMetaDataLoader((Context)oldctx);
            ArrayList<IObjectValue> listtables = new ArrayList<IObjectValue>();
            ArrayList<IObjectValue> listOldTables = new ArrayList<IObjectValue>();
            for (int i = 0; i < packages.size(); ++i) {
                String pkgName = (String)packages.get(i);
                IObjectCollection curTables = loader.getAllObjectByPackage(MetaDataTypeList.ABSTRACTTABLE, pkgName);
                for (int j = 0; j < curTables.size(); ++j) {
                    listtables.add(curTables.getObject(j));
                }
                IObjectCollection curOldTables = oldLoader.getAllObjectByPackage(MetaDataTypeList.ABSTRACTTABLE, pkgName);
                for (int j = 0; j < curOldTables.size(); ++j) {
                    listOldTables.add(curOldTables.getObject(j));
                }
            }
            if (listtables != null && listtables.size() > 0) {
                tables = listtables.toArray(new AbstractTableInfo[0]);
            }
            if (listOldTables != null && listOldTables.size() > 0) {
                otables = listOldTables.toArray(new AbstractTableInfo[0]);
            }
        } else {
            tables = DBUpdateUtils.getTablesByNewLoader(metadataPath, solutionName);
            otables = DBUpdateUtils.getTablesByNewLoader(oldmetaPath, solutionName + "_old");
        }
        if (tables == null) {
            return false;
        }
        String[] languages = DBUpdateUtils.getMultiLanguages(solution);
        AbstractTableInfo[] newTables = DBUpdateUtils.ignoreDataView(tables);
        newTables = DBUpdateUtils.addMultilangColumns(newTables, languages);
        AbstractTableInfo[] oldTables = DBUpdateUtils.ignoreDataView(otables);
        oldTables = DBUpdateUtils.addMultilangColumns(otables, languages);
        DBUpdateEngineImpl dbUpdateEngine = new DBUpdateEngineImpl();
        Report report = dbUpdateEngine.getDifferenceReport(oldTables, newTables);
        DBUpdateList updateList = dbUpdateEngine.generateUpdateScript(report, DBUpdateStrategy.AddTempTable);
        DBUpdateUtils.generateDBScript(null, metadataPath, solutionName, scriptPath, updateList);
        return true;
    }

    public static boolean generateDBScript(String metadataPath, String solutionName, String scriptPath, String[] tablePKs) throws DBUpdateException, IOException {
        ArrayList<String> list = new ArrayList<String>();
        int n = tablePKs.length;
        for (int i = 0; i < n; ++i) {
            if (StringUtils.isEmpty((String)tablePKs[i])) continue;
            list.add(tablePKs[i]);
        }
        AbstractTableInfo[] tables = DBUpdateUtils.getTables(list, metadataPath, solutionName);
        return DBUpdateUtils.generateDBScript(metadataPath, solutionName, scriptPath, tables);
    }

    public static boolean generateDBScript(String metadataPath, String solutionName, String scriptPath, AbstractTableInfo[] tables, DBUpdateList backList, boolean copytable) throws DBUpdateException, IOException {
        DBCreateXmlRoot rootXml = new DBCreateXmlRoot();
        return DBUpdateUtils.generateDBScript(metadataPath, solutionName, scriptPath, tables, backList, copytable, rootXml);
    }

    public static boolean generateDBScript(String metadataPath, String solutionName, String scriptPath, AbstractTableInfo[] tables, DBUpdateList backList, boolean copytable, DBCreateXmlRoot rootXml) throws DBUpdateException, IOException {
        int j;
        int i;
        SolutionInfo solution = DBUpdateUtils.getSolution(metadataPath, solutionName);
        if (solution == null) {
            throw new DBUpdateException("Can not found " + solutionName + " solution!");
        }
        String[] languages = DBUpdateUtils.getMultiLanguages(solution);
        AbstractTableInfo[] newTables = DBUpdateUtils.ignoreDataView(tables);
        newTables = DBUpdateUtils.addMultilangColumns(newTables, languages, copytable);
        logger.debug((Object)"\u6b63\u5728\u751f\u6210\u6570\u636e\u5e93\u8868\u7ed3\u6784\u66f4\u65b0\u811a\u672c...");
        DBUpdateList updateList = new DBUpdateList();
        HashMap<String, String> tableMDMap = new HashMap<String, String>();
        try {
            int n = newTables.length;
            for (int i2 = 0; i2 < n; ++i2) {
                tableMDMap.put(newTables[i2].getName(), newTables[i2].getFullName());
                DBSchemaDAO.createDBTable(3, newTables[i2], updateList);
                DBSchemaDAO.createPK(3, newTables[i2], updateList);
                DBSchemaDAO.createDBIndex(3, newTables[i2], updateList);
                DBSchemaDAO.createDBIndex(2, newTables[i2], updateList);
                DBSchemaDAO.createDBIndex(1, newTables[i2], updateList);
                DBSchemaDAO.createDBIndex(4, newTables[i2], updateList);
            }
        }
        catch (SQLException e) {
            logger.debug((Object)"\u6b63\u5728\u751f\u6210\u6570\u636e\u5e93\u8868\u7ed3\u6784\u66f4\u65b0\u811a\u672c...\u751f\u6210\u5931\u8d25!");
            throw new DBUpdateException(e);
        }
        logger.debug((Object)"\u6b63\u5728\u751f\u6210\u6570\u636e\u5e93\u8868\u7ed3\u6784\u66f4\u65b0\u811a\u672c...\u751f\u6210\u5b8c\u6bd5!");
        logger.debug((Object)"\u6b63\u5728\u521b\u5efa\u6570\u636e\u5e93\u8868\u7ed3\u6784\u66f4\u65b0\u811a\u672c\u6587\u4ef6...");
        String perfix = solution.getPerfix();
        DBCreateXmlRoot rootCreateXml = rootXml;
        if (rootCreateXml == null) {
            rootCreateXml = new DBCreateXmlRoot();
        }
        List list = DBUpdateUtils.getSubPackages(metadataPath, solutionName, perfix);
        List list2 = DBUpdateUtils.getSubPackages(metadataPath, solutionName, "com.kingdee.bos");
        list.addAll(list2);
        if (backList != null) {
            String sql;
            String newname;
            String name;
            DBUpdateInfo dbinfo2;
            DBUpdateInfo dbinfo;
            block3: for (i = 0; i < updateList.size(); ++i) {
                dbinfo = updateList.getInfo(i);
                if (dbinfo == null || 13 != dbinfo.getType()) continue;
                for (j = updateList.size() - 1; j > i; --j) {
                    dbinfo2 = updateList.getInfo(j);
                    if (dbinfo2 == null || 13 != dbinfo2.getType() || !dbinfo.getName().equalsIgnoreCase(dbinfo2.getName())) continue;
                    name = dbinfo.getName();
                    newname = name + "_err";
                    sql = dbinfo.getSql();
                    sql = StringUtils.replace((String)sql, (String)("CONSTRAINT " + name), (String)("CONSTRAINT " + newname));
                    dbinfo.setName(newname);
                    dbinfo.setSql(sql);
                    --i;
                    continue block3;
                }
            }
            block5: for (i = 0; i < updateList.size(); ++i) {
                dbinfo = updateList.getInfo(i);
                if (dbinfo == null || 13 != dbinfo.getType()) continue;
                for (j = backList.size() - 1; j >= 0; --j) {
                    dbinfo2 = backList.getInfo(j);
                    if (dbinfo2 == null || 13 != dbinfo2.getType() || !dbinfo.getName().equalsIgnoreCase(dbinfo2.getName())) continue;
                    name = dbinfo.getName();
                    newname = name + "_err";
                    sql = dbinfo.getSql();
                    sql = StringUtils.replace((String)sql, (String)("CONSTRAINT " + name), (String)("CONSTRAINT " + newname));
                    dbinfo.setName(newname);
                    dbinfo.setSql(sql);
                    --i;
                    continue block5;
                }
            }
            backList.addAll(updateList);
        }
        for (i = 0; i < list.size(); ++i) {
            PackageInfo pkginfo = (PackageInfo)list.get(i);
            for (j = list.size() - 1; j > i; --j) {
                if (j == i || !pkginfo.getFullName().equalsIgnoreCase(((PackageInfo)list.get(j)).getFullName())) continue;
                list.remove(j);
            }
        }
        int n = list.size();
        for (i = 0; i < n; ++i) {
            DBCreateXml createXml = DBUpdateUtils.createCreateXml((PackageInfo)list.get(i), updateList, tableMDMap);
            rootCreateXml.addCreateXml(createXml);
        }
        rootCreateXml.create(scriptPath);
        logger.debug((Object)"\u6b63\u5728\u521b\u5efa\u6570\u636e\u5e93\u8868\u7ed3\u6784\u66f4\u65b0\u811a\u672c\u6587\u4ef6...\u521b\u5efa\u5b8c\u6bd5!");
        return true;
    }

    public static boolean generateDBScript(String metadataPath, String solutionName, String scriptPath, AbstractTableInfo[] tables) throws DBUpdateException, IOException {
        DBCreateXmlRoot rootCreateXml = new DBCreateXmlRoot();
        return DBUpdateUtils.generateDBScript(metadataPath, solutionName, scriptPath, tables, null, true, rootCreateXml);
    }

    public static boolean generateDBScript(Connection cn, String metadataPath, String solutionName, String scriptPath, DBUpdateList updateList) throws DBUpdateException, FileNotFoundException {
        logger.debug((Object)"\u6b63\u5728\u521b\u5efa\u6570\u636e\u5e93\u8868\u7ed3\u6784\u66f4\u65b0\u811a\u672c\u6587\u4ef6...");
        OutputStream bfs = DBUpdateUtils.createDBScriptFile(scriptPath);
        try {
            DBUpdateUtils.ignoreForeignKey(updateList);
            int n = updateList.size();
            for (int i = 0; i < n; ++i) {
                DBUpdateInfo updateInfo = updateList.getInfo(i);
                String preStatement = DBUpdateUtils.createPreStatement4Update(updateInfo);
                String statement = DBUpdateUtils.createStatement4Update(updateInfo);
                if (!StringUtils.isEmpty((String)preStatement)) {
                    bfs.write(preStatement.getBytes("UTF-8"));
                    bfs.write(TAB.getBytes("UTF-8"));
                    bfs.write(statement.getBytes("UTF-8"));
                    continue;
                }
                bfs.write(statement.getBytes("UTF-8"));
            }
            bfs.flush();
        }
        catch (Exception e) {
            logger.debug((Object)"\u6b63\u5728\u521b\u5efa\u6570\u636e\u5e93\u8868\u7ed3\u6784\u66f4\u65b0\u811a\u672c\u6587\u4ef6...\u521b\u5efa\u5931\u8d25!");
            throw new DBUpdateException(e);
        }
        finally {
            FileUtils.close(bfs);
        }
        logger.debug((Object)"\u6b63\u5728\u521b\u5efa\u6570\u636e\u5e93\u8868\u7ed3\u6784\u66f4\u65b0\u811a\u672c\u6587\u4ef6...\u521b\u5efa\u5b8c\u6bd5!");
        return true;
    }

    private static String createStatement4Update(DBUpdateInfo updateInfo) {
        return updateInfo.getSql() + ";\n";
    }

    private static String createPreStatement4Update(DBUpdateInfo updateInfo) {
        String preStatement = "";
        int type = updateInfo.getType();
        if (0 == type || 1 == type || 2 == type || 4 == type || 5 == type || 6 == type || 8 == type || 9 == type || 10 == type || 13 == type || 14 == type || 15 == type || 17 == type) {
            // empty if block
        }
        return preStatement;
    }

    private static OutputStream createDBScriptFile(String scriptPath) throws FileNotFoundException {
        File file = new File(scriptPath);
        BufferedOutputStream bfs = new BufferedOutputStream(new FileOutputStream(file.getAbsoluteFile() + SEPARATOR + "update.sql"));
        return bfs;
    }

    private static SolutionInfo getSolution(String metadataPath, String solutionName) {
        Context ctx = new Context(null, solutionName, "", new Locale("l2"));
        ctx.put((Object)"METADATAPATH", (Object)metadataPath);
        SolutionInfo solution = MetaDataLoader.getSolution((Context)ctx);
        return solution;
    }

    private static List getSubPackages(String metadataPath, String solutionName, String packageName) {
        ArrayList<PackageInfo> list = new ArrayList<PackageInfo>();
        Context ctx = new Context(null, solutionName, "", new Locale("l2"));
        ctx.put((Object)"METADATAPATH", (Object)metadataPath);
        PackageCollection pCol = null;
        try {
            pCol = new PackageCtrl(ctx).getCollection(packageName);
        }
        catch (Exception e) {
            logger.debug((Object)e);
        }
        if (pCol != null) {
            int n = pCol.size();
            for (int i = 0; i < n; ++i) {
                String subPackageName = MetaDataUtils.getPackageName((String)pCol.get(i).getPackage());
                if (!packageName.equalsIgnoreCase(subPackageName)) continue;
                list.add(pCol.get(i));
            }
        }
        File file = new File(metadataPath + File.separator + StringUtils.replace((String)packageName, (String)".", (String)File.separator));
        File[] files = file.listFiles();
        for (int i = 0; i < files.length; ++i) {
            String pkname = packageName + "." + files[i].getName() + "." + files[i].getName();
            boolean exists = false;
            for (int j = list.size() - 1; j >= 0; --j) {
                if ((PackageInfo)list.get(j) == null || !((PackageInfo)list.get(j)).getFullName().equalsIgnoreCase(pkname)) continue;
                exists = true;
                break;
            }
            if (exists) continue;
            PackageInfo pkinfo = new PackageInfo();
            pkinfo.setPackage(packageName + "." + files[i].getName());
            pkinfo.setName(files[i].getName());
            list.add(pkinfo);
        }
        return list;
    }

    private static DBCreateXml createCreateXml(PackageInfo pInfo, DBUpdateList updateList, Map tableMDMap) {
        DBCreateXml createXml = new DBCreateXml(pInfo);
        HashMap<String, DBCreateTableSql> tableSqlMap = new HashMap<String, DBCreateTableSql>();
        HashMap<String, DBCreateIndexSql> indexSqlMap = new HashMap<String, DBCreateIndexSql>();
        DBCreateTableSql tableSql = null;
        DBCreateIndexSql indexSql = null;
        String packageName = pInfo.getPackage() + ".";
        int n = updateList.size();
        for (int i = 0; i < n; ++i) {
            DBUpdateInfo updateInfo = updateList.getInfo(i);
            String subPackageName = MetaDataUtils.getPackageName((String)((String)tableMDMap.get(updateInfo.getTableName())));
            if (!StringUtils.isEmpty((String)subPackageName) && !subPackageName.endsWith(".app")) {
                subPackageName = subPackageName + ".app";
            }
            if (StringUtils.isEmpty((String)subPackageName) || !subPackageName.startsWith(packageName)) continue;
            if (13 == updateInfo.getType()) {
                updateInfo.getTableName();
            }
            if (15 == updateInfo.getType()) {
                if (!indexSqlMap.containsKey(subPackageName)) {
                    indexSql = new DBCreateIndexSql(createXml, subPackageName);
                    indexSqlMap.put(subPackageName, indexSql);
                } else {
                    indexSql = (DBCreateIndexSql)indexSqlMap.get(subPackageName);
                }
                if (updateInfo.getForDBType() == 0) {
                    indexSql.getUpdateList().addInfo(updateInfo);
                    continue;
                }
                if (DBUtils.isMSSQL(updateInfo.getForDBType())) {
                    if (indexSql.getMssqlIndexSql() == null) {
                        indexSql.setMssqlIndexSql(new DBCreateIndexSql(createXml, subPackageName, 3));
                    }
                    indexSql.getMssqlIndexSql().getUpdateList().addInfo(updateInfo);
                    continue;
                }
                if (DBUtils.isOracle(updateInfo.getForDBType())) {
                    if (indexSql.getOracleIndexSql() == null) {
                        indexSql.setOracleIndexSql(new DBCreateIndexSql(createXml, subPackageName, 2));
                    }
                    indexSql.getOracleIndexSql().getUpdateList().addInfo(updateInfo);
                    continue;
                }
                if (DBUtils.isDB2(updateInfo.getForDBType())) {
                    if (indexSql.getDb2IndexSql() == null) {
                        indexSql.setDb2IndexSql(new DBCreateIndexSql(createXml, subPackageName, 1));
                    }
                    indexSql.getDb2IndexSql().getUpdateList().addInfo(updateInfo);
                    continue;
                }
                if (!DBUtils.isSybase(updateInfo.getForDBType())) continue;
                if (indexSql.getSybaseIndexSql() == null) {
                    indexSql.setSybaseIndexSql(new DBCreateIndexSql(createXml, subPackageName, 4));
                }
                indexSql.getSybaseIndexSql().getUpdateList().addInfo(updateInfo);
                continue;
            }
            if (17 == updateInfo.getType()) continue;
            if (!tableSqlMap.containsKey(subPackageName)) {
                tableSql = new DBCreateTableSql(createXml, subPackageName);
                tableSqlMap.put(subPackageName, tableSql);
            } else {
                tableSql = (DBCreateTableSql)tableSqlMap.get(subPackageName);
            }
            tableSql.getUpdateList().addInfo(updateInfo);
        }
        Iterator iter = tableSqlMap.values().iterator();
        while (iter.hasNext()) {
            createXml.addCreateTableSql((DBCreateTableSql)iter.next());
        }
        iter = indexSqlMap.values().iterator();
        while (iter.hasNext()) {
            createXml.addCreateIndexSql((DBCreateIndexSql)iter.next());
        }
        return createXml;
    }

    private static void ignoreForeignKey(DBUpdateList updateList) {
        for (int i = updateList.size() - 1; i >= 0; --i) {
            DBUpdateInfo updateInfo = updateList.getInfo(i);
            if (0 != updateInfo.getType() && 17 != updateInfo.getType()) continue;
            updateList.remove(i);
        }
    }

    private static AbstractTableInfo[] ignoreDataView(AbstractTableInfo[] tables) {
        ArrayList<AbstractTableInfo> list = new ArrayList<AbstractTableInfo>();
        int n = tables.length;
        for (int i = 0; i < n; ++i) {
            String tableName;
            if (tables[i] == null || (tableName = tables[i].getName()) == null || tableName.startsWith("V_") || tableName.startsWith("v_")) continue;
            list.add(tables[i]);
        }
        AbstractTableInfo[] newTables = new AbstractTableInfo[list.size()];
        int n2 = list.size();
        for (int i = 0; i < n2; ++i) {
            newTables[i] = (AbstractTableInfo)list.get(i);
        }
        return newTables;
    }

    private static AbstractTableInfo[] addMultilangColumns(AbstractTableInfo[] tables, String[] languages) {
        return DBUpdateUtils.addMultilangColumns(tables, languages, true);
    }

    private static AbstractTableInfo[] addMultilangColumns(AbstractTableInfo[] tables, String[] languages, boolean copytable) {
        if (tables == null || tables.length <= 0) {
            return tables;
        }
        ArrayList<ColumnInfo> addedColumns = new ArrayList<ColumnInfo>();
        ArrayList<ColumnInfo> removedColumns = new ArrayList<ColumnInfo>();
        for (int tableIndex = 0; tableIndex < tables.length; ++tableIndex) {
            AbstractTableInfo table = tables[tableIndex];
            if (tables[tableIndex] == null) continue;
            AbstractTableInfo newTable = null;
            try {
                int c;
                newTable = copytable ? (AbstractTableInfo)ObjectUtils.createCopy((Object)table) : table;
                newTable.setAlias(table.getAlias());
                newTable.setName(table.getName());
                newTable.setOldTableName(table.getOldTableName());
                newTable.setUserDefined(table.isUserDefined());
                IndexCollection indexes = newTable.getIndexes();
                if (table == null) continue;
                ColumnCollection cc = table.getColumns();
                ColumnCollection newcc = newTable.getColumns();
                addedColumns.clear();
                removedColumns.clear();
                int n = cc.size();
                block3: for (int columnIndex = 0; columnIndex < n; ++columnIndex) {
                    ColumnInfo column = cc.get(columnIndex);
                    if (!column.isMultilingual()) continue;
                    removedColumns.add(column);
                    String name = column.getName();
                    ColumnInfo[] newindexcols = new ColumnInfo[languages.length];
                    for (int lan = 0; lan < languages.length; ++lan) {
                        ColumnInfo multiColumn = (ColumnInfo)ObjectUtils.createCopy((Object)column);
                        multiColumn.setName(name + "_" + languages[lan]);
                        newindexcols[lan] = multiColumn;
                        multiColumn.setMultilingual(false);
                        addedColumns.add(multiColumn);
                    }
                    block5: for (int i = 0; i < indexes.size(); ++i) {
                        IndexInfo index = indexes.get(i);
                        IndexColumnCollection idxCols = index.getIndexColumns();
                        for (int j = 0; j < idxCols.size(); ++j) {
                            IndexColumnInfo indexcol = idxCols.get(j);
                            ColumnInfo colinfo = indexcol.getColumn();
                            if (!colinfo.getName().equalsIgnoreCase(name)) continue;
                            indexcol.setColumn(newindexcols[0]);
                            for (int l = 1; l < newindexcols.length; ++l) {
                                IndexColumnInfo indexcol_lan = new IndexColumnInfo();
                                indexcol_lan.setSortType(indexcol.getSortType());
                                indexcol_lan.setColumn(newindexcols[l]);
                                idxCols.add(indexcol_lan);
                            }
                            continue block5;
                        }
                    }
                    PrimaryKeyInfo pkinfo = newTable.getPrimaryKey();
                    if (pkinfo == null) continue;
                    PKColumnCollection pkCols = pkinfo.getPKColumns();
                    for (int j = 0; j < pkCols.size(); ++j) {
                        PKColumnInfo pkcol = pkCols.get(j);
                        ColumnInfo colinfo = pkcol.getColumn();
                        if (!colinfo.getName().equalsIgnoreCase(name)) continue;
                        pkcol.setColumn(newindexcols[0]);
                        for (int l = 1; l < newindexcols.length; ++l) {
                            PKColumnInfo indexcol_lan = new PKColumnInfo();
                            indexcol_lan.setSortType(pkcol.getSortType());
                            indexcol_lan.setColumn(newindexcols[l]);
                            pkCols.add(indexcol_lan);
                        }
                        continue block3;
                    }
                }
                n = removedColumns.size();
                for (c = 0; c < n; ++c) {
                    newcc.remove((ColumnInfo)removedColumns.get(c));
                }
                n = addedColumns.size();
                for (c = 0; c < n; ++c) {
                    newcc.add((ColumnInfo)addedColumns.get(c));
                }
                tables[tableIndex] = newTable;
                continue;
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                // empty catch block
            }
        }
        return tables;
    }

    public static String[] getMultiLanguages(SolutionInfo solution) {
        LanguageCollection lc = solution.getLanguages();
        String[] languages = new String[lc.size()];
        for (int i = 0; i < lc.size(); ++i) {
            LanguageInfo lan = lc.get(i);
            languages[i] = lan.getPostfix();
        }
        return languages;
    }

    public static boolean synTableMetasByDb(Connection cn, String metadataPath, String solutionName) throws Exception {
        if (cn == null) {
            return false;
        }
        SolutionInfo solution = DBUpdateUtils.getSolution(metadataPath, solutionName);
        if (solution == null) {
            throw new DBUpdateException("Can not found " + solutionName + " solution!");
        }
        Context ctx = new Context(null, solutionName, "", new Locale("l2"));
        ctx.put((Object)"METADATAPATH", (Object)metadataPath);
        Loader2 devloader = new Loader2(new File(metadataPath), null, null, null);
        AbstractTableInfo[] newTables = DBUpdateUtils.getTablesByNewLoader(metadataPath, solutionName);
        String[] languages = DBUpdateUtils.getMultiLanguages(solution);
        newTables = DBUpdateUtils.addMultilangColumns(newTables, languages, false);
        if (newTables == null) {
            return false;
        }
        AbstractTableInfo[] dbTables = DBSchema.getTablesForDiffDB(cn, newTables);
        for (int i = 0; i < newTables.length; ++i) {
            int j;
            AbstractTableInfo devTableInfo = (AbstractTableInfo)devloader.loadMetadata(MetaDataTypeList.ABSTRACTTABLE, (IMetaDataPK)new MetaDataPK(newTables[i].getFullName()));
            ColumnCollection devTableColumns = devTableInfo.getColumns();
            AbstractTableInfo dbTableInfo = null;
            if (devTableInfo == null) continue;
            for (int k = 0; k < dbTables.length; ++k) {
                AbstractTableInfo dbTemp = dbTables[k];
                if (dbTemp == null || !dbTemp.getName().equalsIgnoreCase(devTableInfo.getName())) continue;
                dbTableInfo = dbTemp;
                break;
            }
            if (dbTableInfo == null) continue;
            ColumnCollection dbTableColumns = dbTableInfo.getColumns();
            for (j = 0; j < devTableColumns.size(); ++j) {
                ColumnInfo devcol = devTableColumns.get(j);
                if (SQLType.NUMERIC != devcol.getTypeName() && SQLType.VARCHAR != devcol.getTypeName() && SQLType.NVARCHAR != devcol.getTypeName() && SQLType.CHAR != devcol.getTypeName() && SQLType.NCHAR != devcol.getTypeName() && SQLType.INT != devcol.getTypeName() && SQLType.DATETIME != devcol.getTypeName()) continue;
                ColumnInfo dbcol = null;
                boolean isMutiLan = false;
                for (int l = 0; l < dbTableColumns.size(); ++l) {
                    ColumnInfo colTemp = dbTableColumns.get(l);
                    String sdbRealName = colTemp.getName();
                    int index = sdbRealName.toLowerCase().lastIndexOf("_l");
                    isMutiLan = false;
                    if (index > 0) {
                        int llen = sdbRealName.length() - index;
                        sdbRealName = sdbRealName.substring(0, index);
                        if (llen == 3 && sdbRealName.equalsIgnoreCase(devcol.getName())) {
                            isMutiLan = true;
                            dbcol = colTemp;
                            break;
                        }
                    }
                    if (!colTemp.getName().equalsIgnoreCase(devcol.getName())) continue;
                    dbcol = colTemp;
                    break;
                }
                if (dbcol == null) continue;
                if (devcol.getTypeName() != dbcol.getTypeName()) {
                    devcol.setTypeName(dbcol.getTypeName());
                }
                if (devcol.isMultilingual() != isMutiLan) {
                    devcol.setMultilingual(isMutiLan);
                }
                if (SQLType.NUMERIC == devcol.getTypeName()) {
                    if (devcol.getPrecision() != dbcol.getPrecision()) {
                        devcol.setPrecision(dbcol.getPrecision());
                    }
                    if (devcol.getScale() != dbcol.getScale()) {
                        devcol.setScale(dbcol.getScale());
                    }
                }
                if (devcol.getLength() != dbcol.getLength()) {
                    devcol.setLength(dbcol.getLength());
                }
                if (devcol.isNullable() != dbcol.isNullable()) {
                    devcol.setNullable(dbcol.isNullable());
                }
                if (devcol.getDefaultValue() == dbcol.getDefaultValue()) continue;
                devcol.setDefaultValue(dbcol.getDefaultValue());
            }
            for (j = 0; j < dbTableColumns.size(); ++j) {
                ColumnInfo dbcol = dbTableColumns.get(j);
                ColumnInfo devcol = null;
                boolean isMutiLanColumn = false;
                String sdbOrgName = dbcol.getName();
                String sdbRealName = dbcol.getName();
                int index = sdbRealName.toLowerCase().lastIndexOf("_l");
                int llen = 0;
                if (index > 0) {
                    llen = sdbRealName.length() - index;
                    sdbRealName = sdbRealName.substring(0, index);
                }
                for (int l = 0; l < devTableColumns.size(); ++l) {
                    ColumnInfo colTemp = devTableColumns.get(l);
                    if (colTemp.getName().equalsIgnoreCase(sdbOrgName)) {
                        devcol = colTemp;
                        break;
                    }
                    if (llen != 3 || !colTemp.getName().equalsIgnoreCase(sdbRealName)) continue;
                    isMutiLanColumn = true;
                    devcol = colTemp;
                    break;
                }
                if (devcol != null) continue;
                devcol = new ColumnInfo();
                devcol.setName(sdbRealName);
                devcol.setAlias(dbcol.getAlias());
                devcol.setDescription(dbcol.getDescription());
                devcol.setTypeName(dbcol.getTypeName());
                devcol.setLength(dbcol.getLength());
                devcol.setPrecision(dbcol.getPrecision());
                devcol.setScale(dbcol.getScale());
                devcol.setNullable(dbcol.isNullable());
                devcol.setDefaultValue(dbcol.getDefaultValue());
                devcol.setMultilingual(isMutiLanColumn);
                devTableColumns.add(devcol);
            }
            IndexCollection dbIndexes = dbTableInfo.getIndexes();
            IndexCollection devIndexes = devTableInfo.getIndexes();
            devIndexes.clear();
            for (int j2 = 0; j2 < dbIndexes.size(); ++j2) {
                IndexInfo dbIdxInfo = dbIndexes.get(j2);
                IndexInfo devIdxInfo = null;
                for (int k = 0; k < devIndexes.size(); ++k) {
                    IndexInfo devIdxInfoTmp = devIndexes.get(k);
                    if (devIdxInfoTmp == null || !devIdxInfoTmp.getName().equalsIgnoreCase(dbIdxInfo.getName())) continue;
                    devIdxInfo = devIdxInfoTmp;
                    break;
                }
                if (devIdxInfo != null) continue;
                devIdxInfo = new IndexInfo();
                devIdxInfo.setName(dbIdxInfo.getName());
                IndexColumnCollection dbIdxColumnCols = dbIdxInfo.getIndexColumns();
                IndexColumnCollection devIdxColumnCols = new IndexColumnCollection();
                for (int k = 0; k < dbIdxColumnCols.size(); ++k) {
                    IndexColumnInfo dbidxcolInfo = dbIdxColumnCols.get(k);
                    ColumnInfo dbidxCol = dbidxcolInfo.getColumn();
                    ColumnInfo devIdxCol = devTableInfo.getColumnByName(dbidxCol.getName());
                    if (devIdxCol == null) {
                        String sdbRealName = dbidxCol.getName();
                        int index = sdbRealName.toLowerCase().lastIndexOf("_l");
                        int llen = 0;
                        if (index > 0) {
                            llen = sdbRealName.length() - index;
                            sdbRealName = sdbRealName.substring(0, index);
                            if (llen == 3) {
                                devIdxCol = devTableInfo.getColumnByName(sdbRealName);
                            }
                        }
                    }
                    if (devIdxCol == null) continue;
                    IndexColumnInfo devidxColInfo = new IndexColumnInfo();
                    devidxColInfo.setSortType(dbidxcolInfo.getSortType());
                    devidxColInfo.setColumn(devIdxCol);
                    boolean bexists = false;
                    for (int l = 0; l < devIdxColumnCols.size(); ++l) {
                        IndexColumnInfo tempIdxCol = devIdxColumnCols.get(l);
                        if (!tempIdxCol.getColumn().getName().equalsIgnoreCase(devIdxCol.getName())) continue;
                        bexists = true;
                        break;
                    }
                    if (bexists) continue;
                    devIdxColumnCols.add(devidxColInfo);
                }
                if (devIdxColumnCols.size() <= 0) continue;
                devIdxInfo.setIndexColumns(devIdxColumnCols);
                devIndexes.add(devIdxInfo);
            }
            PrimaryKeyInfo dbPkInfo = dbTableInfo.getPrimaryKey();
            PrimaryKeyInfo devPkInfo = devTableInfo.getPrimaryKey();
            if (devPkInfo == null) {
                devPkInfo = new PrimaryKeyInfo();
            }
            if (dbPkInfo != null && dbPkInfo.getName() != null && !dbPkInfo.getName().equalsIgnoreCase(devPkInfo.getName())) {
                devPkInfo.setName(dbPkInfo.getName());
                PKColumnCollection dbPkColumnCols = dbPkInfo.getPKColumns();
                PKColumnCollection devPkColumnCols = devPkInfo.getPKColumns();
                devPkColumnCols.clear();
                for (int k = 0; k < dbPkColumnCols.size(); ++k) {
                    PKColumnInfo dbPkColInfo = dbPkColumnCols.get(k);
                    ColumnInfo dbPkCol = dbPkColInfo.getColumn();
                    ColumnInfo devPkCol = devTableInfo.getColumnByName(dbPkCol.getName());
                    if (devPkCol == null) {
                        String sdbRealName = dbPkCol.getName();
                        int index = sdbRealName.toLowerCase().lastIndexOf("_l");
                        int llen = 0;
                        if (index > 0) {
                            llen = sdbRealName.length() - index;
                            sdbRealName = sdbRealName.substring(0, index);
                            if (llen == 3) {
                                devPkCol = devTableInfo.getColumnByName(sdbRealName);
                            }
                        }
                    }
                    if (devPkCol == null) continue;
                    PKColumnInfo devPkColInfo = new PKColumnInfo();
                    devPkColInfo.setColumn(devPkCol);
                    boolean bexists = false;
                    for (int l = 0; l < devPkColumnCols.size(); ++l) {
                        PKColumnInfo tempPKCol = devPkColumnCols.get(l);
                        if (!tempPKCol.getColumn().getName().equalsIgnoreCase(devPkCol.getName())) continue;
                        bexists = true;
                        break;
                    }
                    if (bexists) continue;
                    devPkColumnCols.add(devPkColInfo);
                }
                if (devPkColumnCols.size() > 0) {
                    devTableInfo.setPrimaryKey(devPkInfo);
                }
            }
            try {
                devloader.saveMetadata((AbstractMetaDataValue)devTableInfo);
                continue;
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        return true;
    }
}

