/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tool.dbupdate.dbtools;

import com.kingdee.bos.metadata.data.AbstractTableInfo;
import com.kingdee.bos.metadata.data.ColumnInfo;
import com.kingdee.bos.metadata.data.FKColumnPairInfo;
import com.kingdee.bos.metadata.data.ForeignKeyInfo;
import com.kingdee.bos.metadata.data.IndexColumnInfo;
import com.kingdee.bos.metadata.data.IndexInfo;
import com.kingdee.bos.metadata.data.PKColumnInfo;
import com.kingdee.bos.metadata.data.PrimaryKeyInfo;
import com.kingdee.bos.metadata.data.SQLType;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.sql.shell.KDConnection;
import com.kingdee.bos.tool.dbupdate.data.DBUpdateList;
import com.kingdee.bos.tool.dbupdate.dbtools.DBSchemaDAO;
import com.kingdee.bos.tool.dbupdate.dbtools.DBUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;

public class DB2SchemaDAO
extends DBSchemaDAO {
    public static Vector getAllTableName(Connection cn) throws SQLException {
        if (cn instanceof KDConnection) {
            cn = ((KDConnection)cn).getNativeConnection();
        }
        PreparedStatement stmt = null;
        ResultSet rs = null;
        Vector<String> vector = new Vector<String>(0);
        try {
            String sql = "SELECT NAME FROM SYSIBM.SYSTABLES WHERE TYPE='T' AND CREATOR != 'SYSIBM'";
            stmt = DBUtils.createPreparedStatement(cn, sql, new String[0]);
            rs = stmt.executeQuery();
            while (rs.next()) {
                vector.addElement(rs.getString("NAME"));
            }
        }
        catch (SQLException sqle) {
            try {
                throw sqle;
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                SQLUtils.cleanup(stmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        SQLUtils.cleanup((Statement)stmt);
        return vector;
    }

    public static void renameTable(String oldName, String newName, DBUpdateList dbUpdateList) throws SQLException {
        String sql = "/*dialect*/RENAME TABLE " + oldName + " TO " + newName;
        DB2SchemaDAO.addSQLToList(9, newName, sql, dbUpdateList);
    }

    public static AbstractTableInfo getTable(Connection cn, String tableName) throws SQLException {
        AbstractTableInfo abstractTableInfo;
        ResultSet subrs;
        ResultSet rs;
        PreparedStatement substmt;
        PreparedStatement stmt;
        block19: {
            stmt = null;
            substmt = null;
            rs = null;
            subrs = null;
            if (cn instanceof KDConnection) {
                cn = ((KDConnection)cn).getNativeConnection();
            }
            String sql = "SELECT NAME FROM SYSIBM.SYSTABLES WHERE TYPE='T' AND NAME=?";
            stmt = DBUtils.createPreparedStatement(cn, sql, tableName.toUpperCase());
            rs = stmt.executeQuery();
            if (!rs.next()) break block19;
            AbstractTableInfo table = new AbstractTableInfo();
            table.setName(tableName);
            sql = "SELECT * FROM SYSIBM.SYSCOLUMNS WHERE TBNAME=?";
            substmt = DBUtils.createPreparedStatement(cn, sql, tableName.toUpperCase());
            subrs = substmt.executeQuery();
            while (subrs.next()) {
                ColumnInfo col = new ColumnInfo();
                col.setName(subrs.getString("NAME").trim());
                String typeName = subrs.getString("COLTYPE").trim();
                SQLType sqlType = DB2SchemaDAO.getSQLType(typeName);
                if (sqlType == null) {
                    throw new SQLException("unexcept data type:" + typeName + " in col:" + col.getName());
                }
                col.setTypeName(sqlType);
                col.setDefaultValue(subrs.getString("DEFAULT"));
                col.setLength(subrs.getInt("LONGLENGTH"));
                col.setNullable(subrs.getString("NULLS").equals("Y"));
                col.setPrecision(subrs.getInt("LONGLENGTH"));
                col.setScale(subrs.getInt("SCALE"));
                table.getColumns().add(col);
            }
            SQLUtils.cleanup((ResultSet)subrs, (Statement)substmt);
            sql = "SELECT NAME,COLNAMES FROM SYSIBM.SYSINDEXES WHERE UNIQUERULE ='P' AND NAME NOT LIKE 'SQL%' AND TBNAME=?";
            substmt = DBUtils.createPreparedStatement(cn, sql, tableName.toUpperCase());
            subrs = substmt.executeQuery();
            if (subrs.next()) {
                PrimaryKeyInfo pk = new PrimaryKeyInfo();
                pk.setName(subrs.getString("NAME"));
                table.setPrimaryKey(pk);
                String strPK = subrs.getString("COLNAMES");
                strPK = StringUtils.replace((String)strPK, (String)"+", (String)",");
                strPK = StringUtils.replace((String)strPK, (String)"-", (String)",");
                strPK = strPK.substring(1);
                String[] PKColumns = StringUtils.split((String)strPK, (String)",");
                for (int i = 0; i < PKColumns.length; ++i) {
                    ColumnInfo col = DBUtils.getColumnByName(table, PKColumns[i]);
                    PKColumnInfo pkcol = new PKColumnInfo();
                    pkcol.setColumn(col);
                    pk.getPKColumns().add(pkcol);
                }
            }
            SQLUtils.cleanup((ResultSet)subrs, (Statement)substmt);
            sql = "SELECT NAME,COLNAMES,UNIQUERULE FROM SYSIBM.SYSINDEXES WHERE NAME NOT LIKE 'SQL%' AND SYSTEM_REQUIRED = 0 AND TBNAME=?";
            substmt = DBUtils.createPreparedStatement(cn, sql, tableName.toUpperCase());
            subrs = substmt.executeQuery();
            while (subrs.next()) {
                String indexName = subrs.getString("NAME");
                if (table.getPrimaryKey() != null && table.getPrimaryKey().getName().equals(indexName)) continue;
                IndexInfo index = new IndexInfo();
                index.setName(subrs.getString("NAME"));
                index.setUnique(subrs.getString("UNIQUERULE").equals("U"));
                String strIdx = subrs.getString("COLNAMES");
                strIdx = StringUtils.replace((String)strIdx, (String)"+", (String)",+");
                strIdx = StringUtils.replace((String)strIdx, (String)"-", (String)",-");
                strIdx = strIdx.substring(1);
                String[] idxColumns = StringUtils.split((String)strIdx, (String)",");
                for (int i = 0; i < idxColumns.length; ++i) {
                    IndexColumnInfo indexColumn = new IndexColumnInfo();
                    String columnName = idxColumns[i].substring(1).trim();
                    indexColumn.setColumn(DBUtils.getColumnByName(table, columnName.trim()));
                    if (idxColumns[i].substring(0, 1).equals("-")) {
                        indexColumn.setSortType(SortType.DESCEND);
                    }
                    index.getIndexColumns().add(indexColumn);
                }
                table.getIndexes().add(index);
            }
            SQLUtils.cleanup((ResultSet)subrs, (Statement)substmt);
            sql = "SELECT * FROM SYSIBM.SYSRELS WHERE RELNAME NOT LIKE 'SQL%' AND TBNAME=?";
            substmt = DBUtils.createPreparedStatement(cn, sql, tableName.toUpperCase());
            subrs = substmt.executeQuery();
            ForeignKeyInfo prevFK = null;
            while (subrs.next()) {
                prevFK = new ForeignKeyInfo();
                AbstractTableInfo refTable = new AbstractTableInfo();
                refTable.setName(subrs.getString("REFTBNAME"));
                prevFK.setRefTable(refTable);
                prevFK.setName(subrs.getString("RELNAME"));
                String fkcolumns = subrs.getString("FKCOLNAMES").trim();
                String pkcolumns = subrs.getString("PKCOLNAMES").trim();
                while (!fkcolumns.equals("") && !pkcolumns.equals("")) {
                    ColumnInfo pkcolumn;
                    String colname;
                    FKColumnPairInfo fkcol = new FKColumnPairInfo();
                    int spaceindex = fkcolumns.indexOf(" ");
                    if (spaceindex > 0) {
                        colname = fkcolumns.substring(0, spaceindex);
                        fkcol.setForeignKeyColumn(DBUtils.getColumnByName(table, colname));
                        fkcolumns = fkcolumns.substring(spaceindex).trim();
                    } else {
                        colname = fkcolumns;
                        fkcol.setForeignKeyColumn(DBUtils.getColumnByName(table, colname));
                        fkcolumns = "";
                    }
                    spaceindex = pkcolumns.indexOf(" ");
                    if (spaceindex > 0) {
                        colname = pkcolumns.substring(0, spaceindex);
                        pkcolumn = new ColumnInfo();
                        pkcolumn.setName(colname);
                        fkcol.setPrimaryKeyColumn(pkcolumn);
                        pkcolumns = pkcolumns.substring(spaceindex).trim();
                    } else {
                        colname = pkcolumns;
                        pkcolumn = new ColumnInfo();
                        pkcolumn.setName(colname);
                        fkcol.setPrimaryKeyColumn(pkcolumn);
                        pkcolumns = "";
                    }
                    prevFK.getFKColumnPairs().add(fkcol);
                }
                table.getForeignKeys().add(prevFK);
            }
            SQLUtils.cleanup((ResultSet)subrs, (Statement)substmt);
            AbstractTableInfo abstractTableInfo2 = table;
            SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
            SQLUtils.cleanup((ResultSet)subrs, (Statement)substmt);
            return abstractTableInfo2;
        }
        try {
            abstractTableInfo = null;
        }
        catch (SQLException sqle) {
            try {
                throw sqle;
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt);
                SQLUtils.cleanup(subrs, substmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
        SQLUtils.cleanup(subrs, substmt);
        return abstractTableInfo;
    }

    protected static SQLType getSQLType(String typeName) {
        if (typeName.equals("TIME")) {
            return SQLType.DATETIME;
        }
        if (typeName.equals("TIMESTMP")) {
            return SQLType.DATETIME;
        }
        if (typeName.equals("INTEGER")) {
            return SQLType.INT;
        }
        if (typeName.equals("SMALLINT")) {
            return SQLType.INT;
        }
        if (typeName.equals("FLOAT")) {
            return SQLType.NUMERIC;
        }
        if (typeName.equals("VARCHAR")) {
            return SQLType.VARCHAR;
        }
        if (typeName.equals("LONGVAR")) {
            return SQLType.CLOB;
        }
        if (typeName.equals("DECIMAL")) {
            return SQLType.NUMERIC;
        }
        if (typeName.equals("GRAPHIC")) {
            return SQLType.NCHAR;
        }
        if (typeName.equals("VARGRAPH")) {
            return SQLType.NVARCHAR;
        }
        if (typeName.equals("VARG")) {
            return SQLType.NVARCHAR;
        }
        if (typeName.equals("LONGVARG")) {
            return SQLType.NCLOB;
        }
        if (typeName.equals("BIGINT")) {
            return SQLType.INT;
        }
        if (typeName.equals("DOUBLE")) {
            return SQLType.NUMERIC;
        }
        if (typeName.equals("CHAR")) {
            return SQLType.CHAR;
        }
        return null;
    }
}

