/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tool.dbupdate.dbtools;

import com.kingdee.bos.tool.LogTool;
import com.kingdee.bos.tool.dbupdate.DBUpdateStrategy;
import com.kingdee.bos.tool.dbupdate.data.DBUpdateList;
import com.kingdee.bos.tool.dbupdate.dbtools.DBSchema;
import com.kingdee.bos.tool.dbupdate.dbtools.DBUtils;
import com.kingdee.bos.tool.dbupdate.kdbtools.KDBSchema;
import com.kingdee.bos.tool.dbupdate.report.Report;
import com.kingdee.bos.tool.dbupdate.report.TableReportCollection;
import com.kingdee.bos.tool.dbupdate.report.TableReportItem;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class DBUpdate {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.bos.studio.dbupdate.dbtools.DBUpdate");

    public static void update(Connection cn, Report report, DBUpdateStrategy strategy, DBUpdateList dbUpdateList, boolean ignoreFKAndIndexWhenUpdateTable) {
        logger.debug((Object)"\u6b63\u5728\u751f\u6210\u6570\u636e\u5e93\u8868\u7ed3\u6784\u66f4\u65b0\u811a\u672c...");
        if (strategy.equals((Object)DBUpdateStrategy.AddTempTable)) {
            try {
                TableReportCollection tableReportCollection = report.getTableReportCollection();
                int n = tableReportCollection.size();
                for (int i = 0; i < n; ++i) {
                    TableReportItem tableReportItem = tableReportCollection.get(i);
                    if (tableReportItem.getReportState() == 1) continue;
                    if (tableReportItem.getReportState() == 0) {
                        DBSchema.addNewSchema(cn, tableReportItem.getNewTable(), dbUpdateList);
                        continue;
                    }
                    if (tableReportItem.getReportState() != 2 && tableReportItem.getReportState() != 4) continue;
                    if (ignoreFKAndIndexWhenUpdateTable) {
                        DBSchema.updateSchemaIngnoreFKAndIndex(cn, tableReportItem, dbUpdateList);
                        continue;
                    }
                    DBSchema.updateSchema(cn, tableReportItem, dbUpdateList);
                }
            }
            catch (SQLException ex) {
                logger.error((Object)"error", (Throwable)ex);
            }
            logger.debug((Object)"\u6b63\u5728\u751f\u6210\u6570\u636e\u5e93\u8868\u7ed3\u6784\u66f4\u65b0\u811a\u672c...\u751f\u6210\u5b8c\u6bd5!");
        } else if (strategy.equals((Object)DBUpdateStrategy.AlterTable)) {
            try {
                TableReportCollection tableReportCollection = report.getTableReportCollection();
                int dbType = DBUtils.getDbType(cn);
                int n = tableReportCollection.size();
                for (int i = 0; i < n; ++i) {
                    TableReportItem tableReportItem = tableReportCollection.get(i);
                    if (tableReportItem.getReportState() == 1) continue;
                    if (tableReportItem.getReportState() == 0) {
                        KDBSchema.addNewSchema(dbType, tableReportItem.getNewTable(), dbUpdateList);
                        continue;
                    }
                    if (tableReportItem.getReportState() != 2 && tableReportItem.getReportState() != 4) continue;
                    KDBSchema.updateSchema(dbType, tableReportItem, dbUpdateList);
                }
            }
            catch (SQLException ex) {
                LogTool.logError("\u6570\u636e\u5e93\u8fde\u63a5\u9519\u8bef", ex);
            }
        }
    }

    public static void update(Connection cn, Report report, DBUpdateStrategy strategy, DBUpdateList dbUpdateList) {
        DBUpdate.update(cn, report, strategy, dbUpdateList, false);
    }
}

