/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tool.dbupdate.dbtools;

import com.kingdee.bos.metadata.data.AbstractTableInfo;
import com.kingdee.bos.metadata.data.ColumnInfo;
import com.kingdee.bos.metadata.data.FKColumnPairInfo;
import com.kingdee.bos.metadata.data.ForeignKeyInfo;
import com.kingdee.bos.metadata.data.IndexColumnInfo;
import com.kingdee.bos.metadata.data.IndexInfo;
import com.kingdee.bos.metadata.data.PKColumnInfo;
import com.kingdee.bos.metadata.data.PrimaryKeyInfo;
import com.kingdee.bos.metadata.data.SQLType;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.sql.shell.KDConnection;
import com.kingdee.bos.tool.dbupdate.data.DBUpdateList;
import com.kingdee.bos.tool.dbupdate.dbtools.DBSchemaDAO;
import com.kingdee.bos.tool.dbupdate.dbtools.DBUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;

public class ORACLESchemaDAO
extends DBSchemaDAO {
    public static Vector getAllTableName(Connection cn) throws SQLException {
        if (cn instanceof KDConnection) {
            cn = ((KDConnection)cn).getNativeConnection();
        }
        PreparedStatement stmt = null;
        ResultSet rs = null;
        Vector<String> vector = new Vector<String>(0);
        try {
            String sql = "Select TABLE_NAME FROM USER_TABLES";
            stmt = DBUtils.createPreparedStatement(cn, "Select TABLE_NAME FROM USER_TABLES", new String[0]);
            rs = stmt.executeQuery();
            while (rs.next()) {
                vector.addElement(rs.getString("TABLE_NAME"));
            }
        }
        catch (SQLException sqle) {
            try {
                throw sqle;
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        return vector;
    }

    public static void renameTable(String oldName, String newName, DBUpdateList dbUpdateList) throws SQLException {
        String sql = "/*dialect*/ALTER TABLE " + oldName + " RENAME TO " + newName;
        ORACLESchemaDAO.addSQLToList(9, newName, sql, dbUpdateList);
    }

    public static AbstractTableInfo getTable(Connection cn, String tableName) throws SQLException {
        AbstractTableInfo abstractTableInfo;
        ResultSet subrs2;
        ResultSet subrs;
        ResultSet rs;
        PreparedStatement substmt2;
        PreparedStatement substmt;
        PreparedStatement stmt;
        block26: {
            if (cn instanceof KDConnection) {
                cn = ((KDConnection)cn).getNativeConnection();
            }
            stmt = null;
            substmt = null;
            substmt2 = null;
            rs = null;
            subrs = null;
            subrs2 = null;
            String sql = "Select TABLE_NAME FROM USER_TABLES WHERE TABLE_NAME =?";
            stmt = DBUtils.createPreparedStatement(cn, sql, tableName.toUpperCase());
            rs = stmt.executeQuery();
            if (!rs.next()) break block26;
            AbstractTableInfo table = new AbstractTableInfo();
            table.setName(tableName);
            sql = "SELECT * FROM USER_TAB_COLUMNS WHERE TABLE_NAME=?";
            substmt = DBUtils.createPreparedStatement(cn, sql, tableName.toUpperCase());
            subrs = substmt.executeQuery();
            while (subrs.next()) {
                SQLType dataType;
                ColumnInfo col = new ColumnInfo();
                col.setName(subrs.getString("COLUMN_NAME"));
                String typeName = subrs.getString("DATA_TYPE");
                if (typeName.equals("NUMBER") && subrs.getInt("DATA_SCALE") == 0) {
                    typeName = "LONG";
                }
                if ((dataType = ORACLESchemaDAO.getSQLType(typeName)) == null) {
                    throw new SQLException("unexcept data type:" + typeName + " in col:" + col.getName());
                }
                col.setTypeName(dataType);
                String strDef = subrs.getString("DATA_DEFAULT");
                if (strDef != null && strDef.length() != 0 && (strDef = strDef.trim()).startsWith("( ") && strDef.endsWith(" )")) {
                    strDef = "(" + strDef.substring(2, strDef.length() - 4) + ")";
                }
                col.setDefaultValue(strDef);
                col.setLength(subrs.getInt("DATA_LENGTH"));
                col.setNullable(subrs.getString("NULLABLE").equals("Y"));
                col.setPrecision(subrs.getInt("DATA_PRECISION"));
                col.setScale(subrs.getInt("DATA_SCALE"));
                table.getColumns().add(col);
            }
            SQLUtils.cleanup((ResultSet)subrs, (Statement)substmt);
            sql = "select oc.name as \"CONSTRAINT_NAME\", o.name as \"TABLE_NAME\",\r\n       decode(ac.name, null, col.name, ac.name) as \"COLUMN_NAME\", cc.pos# as \"POSITION\"\r\nfrom sys.con$ oc, sys.col$ col, sys.ccol$ cc, sys.cdef$ c,\r\n     sys.obj$ o, sys.attrcol$ ac\r\nwhere oc.con# = c.con#\r\n  and c.type# = 2\r\n  and c.con# = cc.con#\r\n  and cc.obj# = col.obj#\r\n  and cc.intcol# = col.intcol#\r\n  and cc.obj# = o.obj#\r\n  and oc.owner# = userenv('SCHEMAID')\r\n  and col.obj# = ac.obj#(+)\r\n  and col.intcol# = ac.intcol#(+)\r\n  and o.name = '" + tableName.toUpperCase() + "' order by cc.pos# ";
            sql = "/*dialect*/" + sql;
            substmt = DBUtils.createPreparedStatement(cn, sql, new String[0]);
            subrs = substmt.executeQuery();
            if (subrs.next()) {
                PrimaryKeyInfo pk = new PrimaryKeyInfo();
                pk.setName(subrs.getString("CONSTRAINT_NAME"));
                table.setPrimaryKey(pk);
                ColumnInfo col = DBUtils.getColumnByName(table, subrs.getString("COLUMN_NAME"));
                PKColumnInfo pkcol = new PKColumnInfo();
                pkcol.setColumn(col);
                pk.getPKColumns().add(pkcol);
                while (subrs.next()) {
                    col = DBUtils.getColumnByName(table, subrs.getString("COLUMN_NAME"));
                    pkcol = new PKColumnInfo();
                    pkcol.setColumn(col);
                    pk.getPKColumns().add(pkcol);
                }
            }
            SQLUtils.cleanup((ResultSet)subrs, (Statement)substmt);
            try {
                sql = "SELECT INDEX_NAME,UNIQUENESS,INDEX_TYPE FROM USER_INDEXES WHERE INDEX_TYPE<>'LOB' AND TABLE_NAME=?";
                substmt = DBUtils.createPreparedStatement(cn, sql, tableName.toUpperCase());
                subrs = substmt.executeQuery();
                while (subrs.next()) {
                    String indexName = subrs.getString("INDEX_NAME");
                    if (table.getPrimaryKey() != null && table.getPrimaryKey().getName().equals(indexName)) continue;
                    IndexInfo index = new IndexInfo();
                    index.setName(subrs.getString("INDEX_NAME"));
                    index.setUnique(subrs.getString("UNIQUENESS").equals("UNIQUE"));
                    boolean isFunctionIndex = false;
                    if (subrs.getString("INDEX_TYPE").equalsIgnoreCase("FUNCTION-BASED NORMAL")) {
                        sql = "SELECT Column_Expression as COLUMN_NAME,'DESC' as DESCEND FROM USER_IND_EXPRESSIONS WHERE TABLE_NAME=? AND INDEX_NAME=?";
                        isFunctionIndex = true;
                    } else {
                        sql = "SELECT COLUMN_NAME,DESCEND FROM USER_IND_COLUMNS WHERE TABLE_NAME=? AND INDEX_NAME=?";
                    }
                    substmt2 = DBUtils.createPreparedStatement(cn, sql, new String[]{tableName.toUpperCase(), index.getName().toUpperCase()});
                    subrs2 = substmt2.executeQuery();
                    ColumnInfo colInfo = null;
                    boolean isIndexValidate = true;
                    while (subrs2.next()) {
                        IndexColumnInfo indexColumn = new IndexColumnInfo();
                        colInfo = isFunctionIndex ? DBUtils.getColumnByName(table, subrs2.getString("COLUMN_NAME").replaceAll("\"", "")) : DBUtils.getColumnByName(table, subrs2.getString("COLUMN_NAME"));
                        if (colInfo == null) {
                            isIndexValidate = false;
                            break;
                        }
                        indexColumn.setColumn(colInfo);
                        if (subrs2.getString("DESCEND").equals("DESC")) {
                            indexColumn.setSortType(SortType.DESCEND);
                        }
                        index.getIndexColumns().add(indexColumn);
                    }
                    if (isIndexValidate) {
                        table.getIndexes().add(index);
                    }
                    SQLUtils.cleanup((ResultSet)subrs2, (Statement)substmt2);
                }
            }
            catch (SQLException e) {
                throw e;
            }
            finally {
                SQLUtils.cleanup((ResultSet)subrs, (Statement)substmt);
            }
            sql = "select oc.name as \"CONSTRAINT_NAME\"\r\n       ,o.name as \"TABLE_NAME\"\r\n      ,decode(ac.name, null, col.name, ac.name) as \"COLUMN_NAME\"\r\n      ,rc.name as \"R_CONSTRAINT_NAME\"\r\n      ,o1.name as \"R_TABLE_NAME\"\r\n      ,decode(ac1.name, null, col1.name, ac1.name) as \"R_COLUMN_NAME\"\r\nfrom sys.con$ oc, sys.con$ rc, sys.obj$ o, sys.cdef$ c\r\n    ,sys.obj$ o1,sys.cdef$ c1, sys.col$ col, sys.ccol$ cc\r\n     ,sys.attrcol$ ac, sys.col$ col1, sys.ccol$ cc1,sys.attrcol$ ac1\r\n    \r\nwhere oc.con# = c.con#\r\n  and c.obj# = o.obj#\r\n  and c.rcon# = rc.con#(+)\r\n  and o.owner# = userenv('SCHEMAID')\r\n  and c.type#=4\r\n  and rc.con# =c1.con#\r\n  and c1.obj# = o1.obj#  \r\n  and c1.type#=2\r\n  and c.con# = cc.con#\r\n  and cc.obj# = col.obj#\r\n  and cc.intcol# = col.intcol#\r\n  and cc.obj# = o.obj#\r\n  and oc.owner# = userenv('SCHEMAID')\r\n  and col.obj# = ac.obj#(+)\r\n  and col.intcol# = ac.intcol#(+)  \r\n  and cc.pos# = cc1.pos#  \r\n  and c1.con# = cc1.con#\r\n  and cc1.obj# = col1.obj#\r\n  and cc1.intcol# = col1.intcol#\r\n  and cc1.obj# = o1.obj#\r\n  and rc.owner# = userenv('SCHEMAID')\r\n  and col1.obj# = ac1.obj#(+)\r\n  and col1.intcol# = ac1.intcol#(+)\r\n  and o.name = '" + tableName.toUpperCase() + "'";
            sql = "/*dialect*/" + sql;
            substmt = DBUtils.createPreparedStatement(cn, sql, new String[0]);
            subrs = substmt.executeQuery();
            ForeignKeyInfo prevFK = null;
            while (subrs.next()) {
                String fkName = subrs.getString("CONSTRAINT_NAME");
                FKColumnPairInfo fkcol = new FKColumnPairInfo();
                fkcol.setForeignKeyColumn(DBUtils.getColumnByName(table, subrs.getString("COLUMN_NAME")));
                ColumnInfo pkcolumn = new ColumnInfo();
                pkcolumn.setName(subrs.getString("R_COLUMN_NAME"));
                fkcol.setPrimaryKeyColumn(pkcolumn);
                if (prevFK != null && prevFK.getName().equals(fkName)) {
                    prevFK.getFKColumnPairs().add(fkcol);
                    continue;
                }
                prevFK = new ForeignKeyInfo();
                AbstractTableInfo refTable = new AbstractTableInfo();
                refTable.setName(subrs.getString("R_TABLE_NAME"));
                prevFK.setRefTable(refTable);
                prevFK.setName(fkName);
                prevFK.getFKColumnPairs().add(fkcol);
                table.getForeignKeys().add(prevFK);
            }
            SQLUtils.cleanup((ResultSet)subrs, (Statement)substmt);
            AbstractTableInfo abstractTableInfo2 = table;
            SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
            SQLUtils.cleanup((ResultSet)subrs, (Statement)substmt);
            SQLUtils.cleanup((ResultSet)subrs2, (Statement)substmt2);
            return abstractTableInfo2;
        }
        try {
            abstractTableInfo = null;
        }
        catch (SQLException sqle) {
            try {
                throw sqle;
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt);
                SQLUtils.cleanup(subrs, substmt);
                SQLUtils.cleanup(subrs2, substmt2);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
        SQLUtils.cleanup(subrs, substmt);
        SQLUtils.cleanup(subrs2, substmt2);
        return abstractTableInfo;
    }

    public static void dropRefForeignKey(Connection cn, AbstractTableInfo table, DBUpdateList dbUpdateList) throws SQLException {
        if (cn instanceof KDConnection) {
            cn = ((KDConnection)cn).getNativeConnection();
        }
        PreparedStatement stmt = null;
        ResultSet rs = null;
        String tableName = table.getName();
        String sql = "select oc.name as \"CONSTRAINT_NAME\"\r\n       ,o.name as \"TABLE_NAME\"\r\n      ,o1.name as \"R_TABLE_NAME\"\r\nfrom sys.con$ oc, sys.con$ rc, sys.obj$ o, sys.cdef$ c\r\n    ,sys.obj$ o1,sys.cdef$ c1   \r\nwhere oc.con# = c.con#\r\n  and c.obj# = o.obj#\r\n  and c.rcon# = rc.con#(+)\r\n  and o.owner# = userenv('SCHEMAID')\r\n  and c.type#=4\r\n  and rc.con# =c1.con#\r\n  and c1.obj# = o1.obj#  \r\n  and c1.type#=2\r\n  and o1.name = '" + tableName.toUpperCase() + "'";
        sql = "/*dialect*/" + sql;
        stmt = DBUtils.createPreparedStatement(cn, sql, new String[0]);
        rs = stmt.executeQuery();
        while (rs.next()) {
            String fkName = rs.getString("CONSTRAINT_NAME");
            String refTableName = rs.getString("TABLE_NAME");
            String dropsql = "ALTER TABLE " + refTableName + " DROP CONSTRAINT " + fkName;
            ORACLESchemaDAO.addSQLToList(0, fkName, dropsql, dbUpdateList);
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
    }

    public static void createRefForeignKey(Connection cn, AbstractTableInfo oldTable, AbstractTableInfo newTable, DBUpdateList dbUpdateList) throws SQLException {
        if (cn instanceof KDConnection) {
            cn = ((KDConnection)cn).getNativeConnection();
        }
        PreparedStatement stmt = null;
        ResultSet rs = null;
        String tableName = oldTable.getName();
        String sql = "select oc.name as \"CONSTRAINT_NAME\"\r\n       ,o.name as \"TABLE_NAME\"\r\n      ,decode(ac.name, null, col.name, ac.name) as \"COLUMN_NAME\"\r\n      ,rc.name as \"R_CONSTRAINT_NAME\"\r\n      ,o1.name as \"R_TABLE_NAME\"\r\n      ,decode(ac1.name, null, col1.name, ac1.name) as \"R_COLUMN_NAME\"\r\nfrom sys.con$ oc, sys.con$ rc, sys.obj$ o, sys.cdef$ c\r\n    ,sys.obj$ o1,sys.cdef$ c1, sys.col$ col, sys.ccol$ cc\r\n     ,sys.attrcol$ ac, sys.col$ col1, sys.ccol$ cc1,sys.attrcol$ ac1    \r\nwhere oc.con# = c.con#\r\n  and c.obj# = o.obj#\r\n  and c.rcon# = rc.con#(+)\r\n  and o.owner# = userenv('SCHEMAID')\r\n  and c.type#=4\r\n  and rc.con# =c1.con#\r\n  and c1.obj# = o1.obj#  \r\n  and c1.type#=2\r\n  and c.con# = cc.con#\r\n  and cc.obj# = col.obj#\r\n  and cc.intcol# = col.intcol#\r\n  and cc.obj# = o.obj#\r\n  and oc.owner# = userenv('SCHEMAID')\r\n  and col.obj# = ac.obj#(+)\r\n  and col.intcol# = ac.intcol#(+)  \r\n  and cc.pos# = cc1.pos#  \r\n  and c1.con# = cc1.con#\r\n  and cc1.obj# = col1.obj#\r\n  and cc1.intcol# = col1.intcol#\r\n  and cc1.obj# = o1.obj#\r\n  and rc.owner# = userenv('SCHEMAID')\r\n  and col1.obj# = ac1.obj#(+)\r\n  and col1.intcol# = ac1.intcol#(+)\r\n  and o1.name = '" + tableName.toUpperCase() + "'";
        sql = "/*dialect*/" + sql;
        stmt = DBUtils.createPreparedStatement(cn, sql, new String[0]);
        rs = stmt.executeQuery();
        Hashtable<String, FKInfo> fkInfos = new Hashtable<String, FKInfo>();
        while (rs.next()) {
            String fkName = rs.getString("CONSTRAINT_NAME");
            FKInfo fk = (FKInfo)fkInfos.get(fkName);
            if (fk == null) {
                fk = new FKInfo();
                fkInfos.put(fkName, fk);
            }
            fk.tableName = rs.getString("TABLE_NAME");
            fk.ColName.add(rs.getString("COLUMN_NAME"));
            fk.refColName.add(rs.getString("R_COLUMN_NAME"));
            fk.refTableName = tableName;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
        Enumeration e = fkInfos.keys();
        while (e.hasMoreElements()) {
            String fkName = (String)e.nextElement();
            FKInfo fkInfo = (FKInfo)fkInfos.get(fkName);
            if (fkInfo == null) continue;
            StringBuffer keysBuffer = new StringBuffer();
            int n = fkInfo.ColName.size();
            for (int i = 0; i < n; ++i) {
                keysBuffer.append(fkInfo.ColName.get(i));
                if (i == n - 1) continue;
                keysBuffer.append(',');
            }
            StringBuffer refsBuffer = new StringBuffer();
            int n2 = fkInfo.refColName.size();
            for (int i = 0; i < n2; ++i) {
                fkInfo.ColName.get(i);
                refsBuffer.append(fkInfo.refColName.get(i));
                if (i == n2 - 1) continue;
                refsBuffer.append(',');
            }
            String addSql = "ALTER TABLE " + fkInfo.tableName + " ADD CONSTRAINT " + fkName + " FOREIGN KEY(" + keysBuffer.toString() + ") REFERENCES " + fkInfo.refTableName + "(" + refsBuffer + ")";
            ORACLESchemaDAO.addSQLToList(17, fkName, addSql, dbUpdateList);
        }
    }

    protected static SQLType getSQLType(String typeName) {
        if (typeName.equals("VARCHAR2")) {
            return SQLType.VARCHAR;
        }
        if (typeName.equals("NVARCHAR2")) {
            return SQLType.NVARCHAR;
        }
        if (typeName.equals("NUMBER")) {
            return SQLType.NUMERIC;
        }
        if (typeName.equals("LONG")) {
            return SQLType.INT;
        }
        if (typeName.equals("DATE")) {
            return SQLType.DATETIME;
        }
        if (typeName.equals("TIMESTAMP(6)")) {
            return SQLType.DATETIME;
        }
        if (typeName.equals("CHAR")) {
            return SQLType.CHAR;
        }
        if (typeName.equals("NCHAR")) {
            return SQLType.NCHAR;
        }
        if (typeName.equals("CLOB")) {
            return SQLType.CLOB;
        }
        if (typeName.equals("NCLOB")) {
            return SQLType.NCLOB;
        }
        if (typeName.equals("BLOB")) {
            return SQLType.BLOB;
        }
        if (typeName.equals("RAW")) {
            return SQLType.VARBINARY;
        }
        if (typeName.equals("LONG RAW")) {
            return SQLType.VARBINARY;
        }
        return null;
    }

    private static class FKInfo {
        public String tableName;
        public List refColName = new ArrayList();
        public List ColName = new ArrayList();
        public String refTableName;

        private FKInfo() {
        }
    }
}

