/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tool.dialog.mutillang;

import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.md.mdfs.IMDFile;
import com.kingdee.bos.md.multipageeditor.IMDSourceEditor;
import com.kingdee.bos.metadata.AbstractMetaDataCtrl;
import com.kingdee.bos.metadata.management.LanguageCollection;
import com.kingdee.bos.metadata.management.SolutionInfo;
import com.kingdee.bos.tool.dialog.mutillang.Messages;
import com.kingdee.bos.tool.dialog.mutillang.MultiLangPanel;
import com.kingdee.bos.tool.utils.EditorHelper;
import com.kingdee.bos.util.BOSObjectType;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;

public class MultiLangDefineDialog
extends Dialog {
    private MultiLangPanel panel;
    private IMDFile file;
    private Map map = new HashMap();
    private AbstractMetaDataCtrl ctrl;
    private LanguageCollection languages;
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.bos.tool.dialog.mutillang.MultiLangDefineDialog");

    public MultiLangDefineDialog(Shell shell, IMDFile file) {
        super(shell);
        this.file = file;
    }

    protected void okPressed() {
        if (this.file != null) {
            this.save();
        }
        super.okPressed();
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        container.setLayout((Layout)layout);
        this.initModle();
        this.panel = new MultiLangPanel(container, 0, this.languages);
        this.panel.setDefaultProviderAndCellModifier();
        this.panel.setDefaultViewerSorter();
        GridData gd = new GridData(1808);
        gd.heightHint = 400;
        gd.widthHint = 680;
        this.panel.setLayoutData(gd);
        this.initTable();
        return container;
    }

    private void initModle() {
        SolutionInfo solution = this.getSolution();
        if (solution == null) {
            return;
        }
        this.languages = solution.getLanguages();
    }

    private SolutionInfo getSolution() {
        return this.file.getMDProject().getSolutionInfo();
    }

    private void initTable() {
        InputStream is = null;
        try {
            BOSObjectType type = this.file.getBOSType();
            this.ctrl = (AbstractMetaDataCtrl)BOSObjectFactory.createBOSObject((Context)this.file.getMDProject().getORMContext(), (BOSObjectType)type);
            is = this.file.getContent();
            this.map = this.ctrl.loadResource(is);
        }
        catch (Exception e) {
            logger.debug((Object)"", (Throwable)e);
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.MultiLangDefineDialog_CuoWu, (String)Messages.MultiLangDefineDialog_WuFaZhuangZaiXuanZeDeYuanShuJu);
        }
        finally {
            try {
                is.close();
            }
            catch (Exception exception) {}
        }
        this.panel.setInput(this.map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void save() {
        InputStream in = null;
        ByteArrayOutputStream out = null;
        try {
            out = new ByteArrayOutputStream(8192);
            in = this.file.getContent();
            this.ctrl.storeResource(in, (OutputStream)out, this.map);
            in.close();
            in = new ByteArrayInputStream(out.toByteArray());
            this.file.create(in);
            IEditorPart part = EditorHelper.findEditor(this.file);
            if (part != null && part instanceof IMDSourceEditor) {
                ((IMDSourceEditor)part).refreshPages();
            }
        }
        catch (Exception e) {
            logger.debug((Object)"", (Throwable)e);
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.MultiLangDefineDialog_CuoWu, (String)Messages.MultiLangDefineDialog_BaoCunDuoYuYanXinXiShiBai);
        }
        finally {
            try {
                in.close();
                out.close();
            }
            catch (Exception exception) {}
        }
    }
}

