/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tool.function;

import com.kingdee.bos.tool.function.Func1;
import com.kingdee.bos.tool.function.Func1V;
import com.kingdee.bos.tool.function.Func2V;
import com.kingdee.bos.tool.function.FuncB;
import com.kingdee.bos.tool.function.Functions;
import com.kingdee.bos.tool.function.Preconditions;
import com.kingdee.bos.tool.function.Predicate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class Lists {
    public static <T> List<T> ofList(T ... args) {
        ArrayList<T> list = new ArrayList<T>();
        for (T t : args) {
            list.add(t);
        }
        return list;
    }

    public static <T> List<T> findAll(List<T> list, Predicate<T> predicate) {
        Preconditions.checkNotNull(list, "\u53c2\u6570%s\u4e0d\u80fd\u4e3a\u7a7a", "list");
        Preconditions.checkNotNull(predicate, "\u53c2\u6570%s\u4e0d\u80fd\u4e3a\u7a7a", "predicate");
        ArrayList<T> newlist = new ArrayList<T>();
        for (T obj : list) {
            if (!predicate.apply(obj)) continue;
            newlist.add(obj);
        }
        Functions.debug("findAll: size=" + newlist.size());
        return newlist;
    }

    public static <T> List<T> findAll(T[] source, Predicate<T> predicate) {
        return Lists.findAll(Arrays.asList(source), predicate);
    }

    public static <T> T findFirst(List<T> list, Predicate<T> predicate) {
        Preconditions.checkNotNull(list, "\u53c2\u6570%s\u4e0d\u80fd\u4e3a\u7a7a", "list");
        Preconditions.checkNotNull(predicate, "\u53c2\u6570%s\u4e0d\u80fd\u4e3a\u7a7a", "predicate");
        for (T obj : list) {
            if (!predicate.apply(obj)) continue;
            Functions.debug("findFirst:" + obj);
            return obj;
        }
        return null;
    }

    public static <T> T findFirst(T[] source, Predicate<T> predicate) {
        Preconditions.checkNotNull(source, "\u53c2\u6570%s\u4e0d\u80fd\u4e3a\u7a7a", "source");
        return Lists.findFirst(Arrays.asList(source), predicate);
    }

    public static <T, F> List<F> map(List<T> list, Func1<F, T> trans) {
        Preconditions.checkNotNull(list, "\u53c2\u6570%s\u4e0d\u80fd\u4e3a\u7a7a", "list");
        Preconditions.checkNotNull(trans, "\u53c2\u6570%s\u4e0d\u80fd\u4e3a\u7a7a", "trans");
        return Lists.foreach(list, trans);
    }

    public static <T, F> List<F> transform(List<T> source, Func1<F, T> trans) {
        return Lists.map(source, trans);
    }

    public static <T, F> List<F> map(T[] source, Func1<F, T> trans) {
        Preconditions.checkNotNull(source, "\u53c2\u6570%s\u4e0d\u80fd\u4e3a\u7a7a", "source");
        Preconditions.checkNotNull(trans, "\u53c2\u6570%s\u4e0d\u80fd\u4e3a\u7a7a", "trans");
        return Lists.foreach(source, trans);
    }

    public static <T, F> List<F> transform(T[] source, Func1<F, T> trans) {
        return Lists.map(source, trans);
    }

    public static <T, F> List<F> foreach(List<T> list, Func1<F, T> iterator) {
        ArrayList<F> newList = new ArrayList<F>();
        for (T t : list) {
            newList.add(iterator.invoke(t));
        }
        return newList;
    }

    public static <T, F> List<F> foreach(T[] source, Func1<F, T> iterator) {
        return Lists.foreach(Arrays.asList(source), iterator);
    }

    public static <T> void foreach(List<T> list, Func1V<T> iterator) {
        for (T t : list) {
            iterator.invoke(t);
        }
    }

    public static <T> void foreach(T[] source, Func1V<T> iterator) {
        Lists.foreach(Arrays.asList(source), iterator);
    }

    public static <T> boolean foreach(List<T> list, Func1V<T> iterator, FuncB isContinue) {
        Preconditions.checkNotNull(list, "\u53c2\u6570%s\u4e0d\u80fd\u4e3a\u7a7a", "list");
        Preconditions.checkNotNull(isContinue, "\u53c2\u6570%s\u4e0d\u80fd\u4e3a\u7a7a", "isContinue");
        Iterator<T> it = list.iterator();
        while (isContinue.invoke() && it.hasNext()) {
            iterator.invoke(it.next());
        }
        return isContinue.invoke();
    }

    public static <T> boolean foreachWithIndex(final List<T> list, final Func2V<T, Integer> iterator, final FuncB isContinue) {
        Preconditions.checkNotNull(list, "\u53c2\u6570%s\u4e0d\u80fd\u4e3a\u7a7a", "list");
        Preconditions.checkNotNull(isContinue, "\u53c2\u6570%s\u4e0d\u80fd\u4e3a\u7a7a", "isContinue");
        Functions.withParam(1, new Func1<Void, Integer>(){

            @Override
            public Void invoke(Integer index) {
                Iterator it = list.iterator();
                while (isContinue.invoke() && it.hasNext()) {
                    Integer n = index;
                    Integer n2 = index = Integer.valueOf(index + 1);
                    iterator.invoke(it.next(), n);
                }
                return null;
            }
        });
        return isContinue.invoke();
    }

    public static <T> boolean foreach(T[] source, Func1V<T> iterator, FuncB isContinue) {
        Preconditions.checkNotNull(source, "\u53c2\u6570%s\u4e0d\u80fd\u4e3a\u7a7a", "source");
        return Lists.foreach(Arrays.asList(source), iterator, isContinue);
    }

    public static <T> boolean foreachWithIndex(T[] source, Func2V<T, Integer> iterator, FuncB isContinue) {
        Preconditions.checkNotNull(source, "\u53c2\u6570%s\u4e0d\u80fd\u4e3a\u7a7a", "source");
        return Lists.foreachWithIndex(Arrays.asList(source), iterator, isContinue);
    }

    public static <T> void addWhenNoExist(List<T> source, T obj) {
        Preconditions.checkNotNull(source, "\u53c2\u6570%s\u4e0d\u80fd\u4e3a\u7a7a", "source");
        if (!source.contains(obj)) {
            source.add(obj);
        }
    }

    public static <T> T deleteFirst_if(final List<T> list, Predicate<T> filter) {
        Preconditions.checkNotNull(list, "\u53c2\u6570%s\u4e0d\u80fd\u4e3a\u7a7a", "list");
        Preconditions.checkNotNull(filter, "\u53c2\u6570%s\u4e0d\u80fd\u4e3a\u7a7a", "filter");
        return (T)Functions.invokeAsParam(Lists.findFirst(list, filter), new Func1<T, T>(){

            @Override
            public T invoke(T item) {
                list.remove(item);
                return item;
            }
        });
    }

    public static <T> boolean deleteAll_if(List<T> list, Predicate<T> filter) {
        Preconditions.checkNotNull(list, "\u53c2\u6570%s\u4e0d\u80fd\u4e3a\u7a7a", "list");
        Preconditions.checkNotNull(filter, "\u53c2\u6570%s\u4e0d\u80fd\u4e3a\u7a7a", "filter");
        return list.removeAll(Lists.findAll(list, filter));
    }

    public static void main(String[] args) {
        List<Integer> list = Lists.ofList(1, 2, 3, 4, 5, 6);
        System.out.println(Lists.foreach(list, new Func1V<Integer>(){

            @Override
            public void invoke(Integer v) {
                System.out.println(v);
            }
        }, new FuncB(){

            @Override
            public boolean invoke() {
                return true;
            }
        }));
        Lists.foreachWithIndex(list.toArray(new Integer[0]), new Func2V<Integer, Integer>(){

            @Override
            public void invoke(Integer value, Integer index) {
                System.out.println("index=" + index + " value=" + value);
            }
        }, new FuncB(){

            @Override
            public boolean invoke() {
                return true;
            }
        });
    }
}

