/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tool.function.event;

import com.kingdee.bos.tool.function.Func1V;
import com.kingdee.bos.tool.function.Lists;
import com.kingdee.bos.tool.function.Preconditions;
import com.kingdee.bos.tool.function.event.FunctionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class EventDispatcher {
    private static final Logger log = Logger.getLogger(EventDispatcher.class);
    private static List<Func1V<FunctionEvent>> listeners = new ArrayList<Func1V<FunctionEvent>>();
    private static List<FunctionEvent> eventList = Collections.synchronizedList(new ArrayList());
    private static Thread dispatchThread = null;
    private static boolean stop = true;

    public static Func1V<FunctionEvent> addListener(Func1V<FunctionEvent> listener) {
        Lists.addWhenNoExist(listeners, listener);
        return listener;
    }

    public static void removeListener(Func1V<FunctionEvent> listener) {
        listeners.remove(listener);
    }

    public static <T> void fireEvent(String eventName, Object eventValue, Map<String, Object> event) {
        Preconditions.checkNotNull(eventName, "eventName\u4e0d\u80fd\u4e3a\u7a7a");
        EventDispatcher.startEventDispatcher();
        eventList.add(FunctionEvent.createFunctionEvent(eventName, eventValue, event == null ? null : Collections.unmodifiableMap(event)));
        EventDispatcher._notifyAll_();
    }

    private static void dispatchEvent(final FunctionEvent funcEvent) {
        Lists.foreach(listeners, new Func1V<Func1V<FunctionEvent>>(){

            @Override
            public void invoke(Func1V<FunctionEvent> listener) {
                try {
                    listener.invoke(funcEvent);
                }
                catch (Exception e) {
                    log.error((Object)"\u4e8b\u4ef6\u5904\u7406\u5f02\u5e38:", (Throwable)e);
                }
            }
        });
    }

    public static synchronized void startEventDispatcher() {
        if (stop || dispatchThread == null || !dispatchThread.isAlive()) {
            EventDispatcher.runEventDispatcher();
        }
    }

    public static synchronized void stopEventDispatcher() {
        stop = true;
        EventDispatcher._notifyAll_();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void _notifyAll_() {
        List<FunctionEvent> list = eventList;
        synchronized (list) {
            eventList.notifyAll();
        }
    }

    private static void runEventDispatcher() {
        stop = false;
        dispatchThread = new Thread("com.kingdee.bos.tool.function.event.EventDispatcher"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (!stop) {
                    List list = eventList;
                    synchronized (list) {
                        if (eventList.isEmpty()) {
                            try {
                                eventList.wait();
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                    }
                    while (!eventList.isEmpty()) {
                        EventDispatcher.dispatchEvent((FunctionEvent)eventList.remove(0));
                    }
                }
            }
        };
        dispatchThread.setDaemon(true);
        dispatchThread.start();
    }

    public static void main(String[] args) {
        EventDispatcher.addListener(new Func1V<FunctionEvent>(){

            @Override
            public void invoke(FunctionEvent event) {
                System.out.println(event);
            }
        });
        HashMap<String, Object> event = new HashMap<String, Object>();
        event.put("aaa", 123);
        event.put("bbb", "hello kingdee");
        EventDispatcher.fireEvent("one", "testOne", event);
        event.put("ccc", "hello cds");
        EventDispatcher.fireEvent("two", "testTwo", event);
        int i = 0;
        while (i < 3) {
            ++i;
            try {
                Thread.sleep(1000L);
                System.out.println("i=" + i);
                EventDispatcher.fireEvent("test", "testtest", event);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        event = new HashMap();
        event.put("repeet===========", "ok");
        EventDispatcher.fireEvent("test", "testteat", event);
        System.out.println("exit......");
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        EventDispatcher.stopEventDispatcher();
    }
}

