/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tool.multipageeditor;

import com.kingdee.bos.tool.multipageeditor.common.CommonPage;
import com.kingdee.bos.tool.multipageeditor.common.CommonPageSection;
import java.util.Vector;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public abstract class AbstractPageSection
extends CommonPageSection {
    private InnerModifyAdapter modifyListener = new InnerModifyAdapter();
    private InnerSelectionAdapter selectionListener = new InnerSelectionAdapter();
    private Vector sectionControlList = new Vector();
    protected boolean updateing = false;
    private boolean created = false;
    private Composite container;

    public AbstractPageSection(CommonPage page, String title, String desc) {
        super(page);
        this.setHeaderText(title);
        this.setDescription(desc);
    }

    public Vector getSectionControlList() {
        return this.sectionControlList;
    }

    @Override
    protected Composite createClient(Composite composite) {
        this.created = true;
        this.container = composite;
        return null;
    }

    public ISelection getSelection() {
        return null;
    }

    public void refresh() {
        if (!this.created) {
            return;
        }
        this.updateing = true;
        this.updateControls();
        this.updateing = false;
    }

    protected void registerControl(Control control) {
        if (this.sectionControlList.contains(control)) {
            return;
        }
        this.sectionControlList.add(control);
        if (control instanceof Button) {
            ((Button)control).addSelectionListener((SelectionListener)this.selectionListener);
        } else if (control instanceof Text) {
            ((Text)control).addModifyListener((ModifyListener)this.modifyListener);
        } else if (control instanceof CCombo) {
            ((CCombo)control).addModifyListener((ModifyListener)this.modifyListener);
        }
    }

    public void setSelection(ISelection selection, boolean reveal) {
    }

    protected void modifyText(ModifyEvent e) {
        if (!this.updateing) {
            this.getEditor().setNeedSync(true);
            this.getEditor().setModify(true);
        }
    }

    protected void widgetSelected(SelectionEvent e) {
        if (!this.updateing) {
            this.getEditor().setNeedSync(true);
            this.getEditor().setModify(true);
        }
    }

    protected void updateControls() {
        this.enableSection(!this.isReadOnly());
    }

    protected void enableSection(boolean enable) {
        this.enableComposite(this.container, enable);
    }

    private void enableComposite(Composite composite, boolean enable) {
        if (composite == null) {
            return;
        }
        Control[] acontrol = composite.getChildren();
        for (int i = 0; i < acontrol.length; ++i) {
            Control control = acontrol[i];
            if (control instanceof Composite) {
                this.enableComposite((Composite)control, enable);
            }
            control.setEnabled(enable);
        }
    }

    private class InnerSelectionAdapter
    extends SelectionAdapter {
        private InnerSelectionAdapter() {
        }

        public void widgetSelected(SelectionEvent e) {
            AbstractPageSection.this.widgetSelected(e);
        }
    }

    private class InnerModifyAdapter
    implements ModifyListener {
        private InnerModifyAdapter() {
        }

        public void modifyText(ModifyEvent e) {
            AbstractPageSection.this.modifyText(e);
        }
    }
}

