/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tool.multipageeditor;

import com.kingdee.bos.tool.common.TranslateUtil;
import com.kingdee.bos.tool.multipageeditor.AbstractPageSection;
import com.kingdee.bos.tool.multipageeditor.common.CommonPage;
import com.kingdee.bos.tool.utils.ToolCommonImages;
import java.util.List;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.jdom2.Content;
import org.jdom2.Element;

public abstract class TreeWithButtonsSection2
extends AbstractPageSection {
    private TreeViewer fTreeViewer;
    private Button fAddMenuButton;
    private Button fAddMenuItemButton;
    private Button fRemoveButton;
    private String[] fButtonNames;

    public TreeWithButtonsSection2(CommonPage page, String title, String desc, String[] buttonnames, String xmlobject) {
        super(page, title, desc);
        if (buttonnames == null || buttonnames[0] == null || buttonnames[1] == null || buttonnames[2] == null) {
            this.fButtonNames = new String[3];
            this.fButtonNames[0] = TranslateUtil.MUTILPAGEEDITOR_TREE_ADDNODE;
            this.fButtonNames[1] = TranslateUtil.MUTILPAGEEDITOR_TREE_ADDLEAF;
            this.fButtonNames[2] = TranslateUtil.MUTILPAGEEDITOR_TREE_DEL;
        } else {
            this.fButtonNames = buttonnames;
        }
    }

    protected void TreeViewerBindToXML(TreeViewer control, Element e, String xmlName) {
        control.setContentProvider((IContentProvider)new DefaultMenuContentProvider());
        control.setLabelProvider((IBaseLabelProvider)new DefaultMenuLabelProvider());
    }

    @Override
    protected Composite createClient(Composite composite) {
        Composite container = this.widgetFactory.createComposite(composite);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 2;
        layout.marginWidth = 2;
        layout.numColumns = 2;
        container.setLayout((Layout)layout);
        this.fTreeViewer = new TreeViewer(container, 772);
        this.fTreeViewer.setAutoExpandLevel(-1);
        this.fTreeViewer.addSelectionChangedListener(this.createTblSelChngLstnr());
        Control control = this.fTreeViewer.getControl();
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 1;
        control.setLayoutData((Object)gd);
        Composite buttonArea = this.widgetFactory.createComposite(container);
        GridLayout buttonLayout = new GridLayout();
        buttonLayout.marginWidth = 2;
        buttonLayout.marginHeight = 2;
        buttonLayout.numColumns = 1;
        buttonArea.setLayout((Layout)buttonLayout);
        GridData buttonAreaGD = new GridData(1040);
        buttonArea.setLayoutData((Object)buttonAreaGD);
        this.fAddMenuButton = this.widgetFactory.createButton(buttonArea, this.fButtonNames[0], 8);
        this.fAddMenuItemButton = this.widgetFactory.createButton(buttonArea, this.fButtonNames[1], 8);
        this.fRemoveButton = this.widgetFactory.createButton(buttonArea, this.fButtonNames[2], 8);
        this.fAddMenuButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TreeWithButtonsSection2.this.handleButtonSelected(0);
            }
        });
        this.fAddMenuItemButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TreeWithButtonsSection2.this.handleButtonSelected(1);
            }
        });
        this.fAddMenuItemButton.setEnabled(true);
        this.fRemoveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TreeWithButtonsSection2.this.handleButtonSelected(2);
            }
        });
        this.fRemoveButton.setEnabled(false);
        this.widgetFactory.paintBordersFor(container);
        return container;
    }

    protected void handleButtonSelected(int i) {
        switch (i) {
            case 0: {
                this.handleNewNode();
                break;
            }
            case 1: {
                this.handleNewLeaf();
                break;
            }
            case 2: {
                this.handleRemove();
            }
        }
        this.getEditor().setModify(true);
    }

    protected abstract void handleNewNode();

    protected abstract void handleNewLeaf();

    protected void handleRemove() {
        if (this.fTreeViewer.getTree().getSelection() == null || this.fTreeViewer.getTree().getSelection().length == 0) {
            return;
        }
        Object obj = this.fTreeViewer.getTree().getSelection()[0].getData();
        if (!(obj instanceof Element)) {
            return;
        }
        Element e = (Element)obj;
        e.getParent().removeContent((Content)e);
        this.refresh();
    }

    @Override
    protected void handleTableSelectionChanged(SelectionChangedEvent e) {
        StructuredSelection selection = (StructuredSelection)e.getSelection();
        Object obj = selection.getFirstElement();
        if (obj instanceof Element) {
            this.fRemoveButton.setEnabled(true);
        } else {
            this.fRemoveButton.setEnabled(false);
        }
    }

    @Override
    public void refresh() {
        if (this.fTreeViewer != null && !this.fTreeViewer.getTree().isDisposed()) {
            this.fTreeViewer.refresh();
        }
    }

    private class DefaultMenuContentProvider
    implements ITreeContentProvider {
        private Object[] EMPTY_ARRAY = new Object[0];

        private DefaultMenuContentProvider() {
        }

        public Object[] getChildren(Object parent) {
            if (parent instanceof Element) {
                Element node = (Element)parent;
                List l = node.getChildren();
                return l == null ? this.EMPTY_ARRAY : l.toArray();
            }
            return this.EMPTY_ARRAY;
        }

        public boolean hasChildren(Object parent) {
            return this.getChildren(parent).length > 0;
        }

        public Object getParent(Object element) {
            if (element instanceof Element) {
                return ((Element)element).getParent();
            }
            return null;
        }

        public Object[] getElements(Object parent) {
            return this.getChildren(parent);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class DefaultMenuLabelProvider
    extends LabelProvider {
        private DefaultMenuLabelProvider() {
        }

        public String getText(Object obj) {
            if (!(obj instanceof Element)) {
                return "";
            }
            Element e = (Element)obj;
            String str = e.getAttributeValue("title");
            return str == null ? "" : str;
        }

        public Image getImage(Object obj) {
            if (obj instanceof Element) {
                Element e = (Element)obj;
                if (e.getChildren().size() > 0) {
                    return ToolCommonImages.getImage("branch.gif");
                }
                return ToolCommonImages.getImage("leaf.gif");
            }
            return ToolCommonImages.getImage("branch.gif");
        }
    }
}

