/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tool.multipageeditor.common;

import com.kingdee.bos.tool.multipageeditor.common.CommonPage;
import com.kingdee.bos.tool.multipageeditor.common.ICommonEditor;
import com.kingdee.bos.tool.multipageeditor.common.ICommonPage;
import com.kingdee.bos.tool.multipageeditor.common.WidgetFactory;
import java.util.Vector;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.MultiPageEditorActionBarContributor;
import org.eclipse.ui.part.MultiPageEditorPart;

public abstract class CommonEditor
extends MultiPageEditorPart
implements ICommonEditor {
    protected WidgetFactory fWf;
    protected Vector fPages;
    protected boolean fReadOnly = false;
    private static Class COMPOSITE_CLASS = Composite.class;
    private static Class CCOMBO_CLASS = CCombo.class;
    private static Class TABLE_CLASS = Table.class;

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        this.initializeWidgetFactory();
    }

    protected void addPage(ICommonPage iCommonpage) {
        int i = this.addPage((Control)iCommonpage.getPageControl());
        this.setPageText(i, iCommonpage.getTabText());
        iCommonpage.setPageIndex(i);
        this.registerPage(iCommonpage);
    }

    @Override
    public void dispose() {
        if (this.fWf != null) {
            this.fWf.dispose();
        }
        if (this.fPages != null && this.fPages.size() != 0) {
            for (ICommonPage iCommonpage : this.fPages) {
                iCommonpage.dispose();
            }
        }
        super.dispose();
    }

    protected void initializeWidgetFactory() {
        this.fWf = new WidgetFactory();
    }

    private void registerPage(ICommonPage iCommonpage) {
        if (this.fPages == null) {
            this.fPages = new Vector();
        }
        if (!this.fPages.contains(iCommonpage)) {
            this.fPages.add(iCommonpage);
        }
    }

    @Override
    public void setPage(int i) {
        this.setActivePage(i);
        this.setFocus();
    }

    @Override
    public void setReadOnly(boolean flag) {
        this.fReadOnly = flag;
        for (ICommonPage iCommonpage : this.fPages) {
            iCommonpage.setReadOnly(flag);
        }
    }

    protected void setReadOnly(boolean flag, Composite composite) {
        Control[] acontrol = composite.getChildren();
        int i = acontrol.length;
        Object obj = null;
        for (int j = 0; j < i; ++j) {
            Control control = acontrol[j];
            if (CCOMBO_CLASS.isInstance(control)) {
                this.setReadOnly(flag, control);
                continue;
            }
            if (TABLE_CLASS.isInstance(control)) {
                this.setReadOnly(flag, control);
                continue;
            }
            if (COMPOSITE_CLASS.isInstance(control)) {
                this.setReadOnly(flag, (Composite)control);
                continue;
            }
            this.setReadOnly(flag, control);
        }
    }

    protected void setReadOnly(boolean flag, Control control) {
        control.setEnabled(!flag);
    }

    @Override
    public boolean isReadOnly() {
        return this.fReadOnly;
    }

    protected void setActivePage(int i) {
        if (this.fPages.size() > i && this.fPages.get(i) instanceof ICommonPage) {
            ICommonPage iCommonpage = (ICommonPage)this.fPages.get(i);
            iCommonpage.setActivated(true);
            super.setActivePage(i);
        } else {
            super.setActivePage(i);
        }
        IEditorActionBarContributor ieditoractionbarcontributor = this.getEditorSite().getActionBarContributor();
        if (ieditoractionbarcontributor != null && ieditoractionbarcontributor instanceof MultiPageEditorActionBarContributor) {
            ((MultiPageEditorActionBarContributor)ieditoractionbarcontributor).setActivePage(this.getEditor(i));
        }
    }

    public abstract void doSave(IProgressMonitor var1);

    public abstract void doSaveAs();

    public void gotoMarker(IMarker imarker) {
    }

    protected abstract int getCurrentPage();

    public boolean isSaveAsAllowed() {
        return false;
    }

    public ISelection getSelection() {
        return null;
    }

    public void setSelection(ISelection selection) {
    }

    protected void pageChange(int i) {
        int j = this.getCurrentPage();
        if (this.fPages.size() > i && this.fPages.get(i) instanceof ICommonPage) {
            ((ICommonPage)this.fPages.get(i)).setActivated(true);
        }
        if (this.fPages.size() > j && this.fPages.get(j) instanceof ICommonPage) {
            ((ICommonPage)this.fPages.get(j)).setActivated(false);
        }
        super.pageChange(i);
    }

    public ICommonPage getCurrPage() {
        if (this.getCurrentPage() == this.fPages.size()) {
            return null;
        }
        return (ICommonPage)this.fPages.get(this.getCurrentPage());
    }

    public void performGlobalAction(String id) {
        ICommonPage ipage = this.getCurrPage();
        CommonPage page = null;
        if (ipage instanceof CommonPage) {
            page = (CommonPage)ipage;
        }
        boolean handled = false;
        if (page != null) {
            handled = page.doGlobalAction(id);
        }
        if (!handled) {
            // empty if block
        }
    }

    static Class _mthclass$(String s) {
        try {
            return Class.forName(s);
        }
        catch (ClassNotFoundException classnotfoundexception) {
            throw new NoClassDefFoundError(classnotfoundexception.getMessage());
        }
    }

    public WidgetFactory getWidgetFactory() {
        return this.fWf;
    }
}

