/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tool.multipageeditor.common;

import java.text.BreakIterator;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.SWTEventListener;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TypedListener;

public class LinkLabel
extends Canvas {
    private String fText = "";
    int fTextMarginWidth = 5;
    int fTextMarginHeight = 5;
    private boolean fUnderlined = true;
    private boolean fHasFocus;

    public LinkLabel(Composite composite, int i) {
        super(composite, i);
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent paintevent) {
                LinkLabel.this.paint(paintevent);
            }
        });
        this.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent keyevent) {
                if (keyevent.character == '\r') {
                    LinkLabel.this.notifyListeners(14);
                }
            }
        });
        this.addListener(31, new Listener(){

            public void handleEvent(Event event) {
                if (event.detail != 4) {
                    event.doit = true;
                }
            }
        });
        this.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent focusevent) {
                if (!LinkLabel.this.fHasFocus) {
                    LinkLabel.this.fHasFocus = true;
                    LinkLabel.this.notifyListeners(13);
                    LinkLabel.this.redraw();
                }
            }

            public void focusLost(FocusEvent focusevent) {
                if (LinkLabel.this.fHasFocus) {
                    LinkLabel.this.fHasFocus = false;
                    LinkLabel.this.notifyListeners(13);
                    LinkLabel.this.redraw();
                }
            }
        });
        this.fTextMarginWidth = 1;
        this.fTextMarginHeight = 1;
        this.initAccessible();
    }

    public void addSelectionListener(SelectionListener selectionlistener) {
        this.checkWidget();
        if (selectionlistener == null) {
            return;
        }
        TypedListener typedlistener = new TypedListener((SWTEventListener)selectionlistener);
        this.addListener(13, (Listener)typedlistener);
        this.addListener(14, (Listener)typedlistener);
    }

    public void removeSelectionListener(SelectionListener selectionlistener) {
        this.checkWidget();
        if (selectionlistener == null) {
            return;
        }
        this.removeListener(13, (SWTEventListener)selectionlistener);
        this.removeListener(14, (SWTEventListener)selectionlistener);
    }

    public boolean getSelection() {
        return this.fHasFocus;
    }

    public String getText() {
        return this.fText;
    }

    public void setText(String s) {
        this.fText = s != null ? s : "";
    }

    public void setUnderlined(boolean flag) {
        this.fUnderlined = flag;
    }

    public boolean isUnderlined() {
        return this.fUnderlined;
    }

    private void notifyListeners(int i) {
        Event event = new Event();
        event.type = i;
        event.widget = this;
        this.notifyListeners(i, event);
    }

    public Point computeSize(int i, int j, boolean flag) {
        int k = i;
        if (k != -1) {
            k -= this.fTextMarginWidth * 2;
        }
        Point point = this.computeTextSize(k, j);
        int l = point.x + 2 * this.fTextMarginWidth;
        int i1 = point.y + 2 * this.fTextMarginHeight;
        return new Point(l, i1);
    }

    public static int computeWrapHeight(GC gc, String s, int i) {
        BreakIterator breakiterator = BreakIterator.getWordInstance();
        breakiterator.setText(s);
        FontMetrics fontmetrics = gc.getFontMetrics();
        int j = fontmetrics.getHeight();
        int k = 0;
        int l = 0;
        int i1 = j;
        int j1 = breakiterator.first();
        while (j1 != -1) {
            String s1 = s.substring(k, j1);
            Point point = gc.textExtent(s1);
            if (point.x > i) {
                k = l;
                i1 += point.y;
            }
            l = j1;
            j1 = breakiterator.next();
        }
        return i1;
    }

    private Point computeTextSize(int i, int j) {
        Point point;
        GC gc = new GC((Drawable)this);
        gc.setFont(this.getFont());
        if ((this.getStyle() & 0x40) != 0 && i != -1) {
            int k = LinkLabel.computeWrapHeight(gc, this.fText, i);
            point = new Point(i, k);
        } else {
            point = gc.textExtent(this.getText());
        }
        gc.dispose();
        return point;
    }

    public static void paintWrapText(GC gc, Point point, String s, int i, int j) {
        LinkLabel.paintWrapText(gc, point, s, i, j, false);
    }

    public static void paintWrapText(GC gc, Point point, String s, int i, int j, boolean flag) {
        BreakIterator breakiterator = BreakIterator.getWordInstance();
        breakiterator.setText(s);
        FontMetrics fontmetrics = gc.getFontMetrics();
        int k = fontmetrics.getHeight();
        int l = fontmetrics.getDescent();
        int i1 = 0;
        int j1 = 0;
        int k1 = j;
        int l1 = point.x - i * 2;
        int i2 = breakiterator.first();
        while (i2 != -1) {
            String s1 = s.substring(i1, i2);
            Point point1 = gc.textExtent(s1);
            if (point1.x > l1) {
                String s3 = s.substring(i1, j1);
                gc.drawString(s3, i, k1, true);
                if (flag) {
                    Point point3 = gc.textExtent(s3);
                    int k2 = k1 + k - l + 1;
                    gc.drawLine(i, k2, point3.x, k2);
                }
                i1 = j1;
                k1 += k;
            }
            j1 = i2;
            i2 = breakiterator.next();
        }
        String s2 = s.substring(i1, j1);
        gc.drawString(s2, i, k1, true);
        if (flag) {
            int j2 = k1 + k - l + 1;
            Point point2 = gc.textExtent(s2);
            gc.drawLine(i, j2, i + point2.x, j2);
        }
    }

    protected void paint(PaintEvent paintevent) {
        GC gc = paintevent.gc;
        Point point = this.getSize();
        gc.setFont(this.getFont());
        gc.setForeground(this.getForeground());
        if ((this.getStyle() & 0x40) != 0) {
            LinkLabel.paintWrapText(gc, point, this.fText, this.fTextMarginWidth, this.fTextMarginHeight, this.fUnderlined);
        } else {
            gc.drawText(this.getText(), this.fTextMarginWidth, this.fTextMarginHeight, true);
            if (this.fUnderlined) {
                FontMetrics fontmetrics = gc.getFontMetrics();
                int i = fontmetrics.getDescent();
                int j = point.y - this.fTextMarginHeight - i + 1;
                gc.drawLine(this.fTextMarginWidth, j, point.x - this.fTextMarginWidth, j);
            }
        }
    }

    private void initAccessible() {
        this.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent accessibleevent) {
                accessibleevent.result = LinkLabel.this.getText();
            }

            public void getDescription(AccessibleEvent accessibleevent) {
                accessibleevent.result = "A link to:  " + LinkLabel.this.getText();
            }
        });
        this.getAccessible().addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(){

            public void getLocation(AccessibleControlEvent accessiblecontrolevent) {
                Rectangle rectangle = LinkLabel.this.getBounds();
                Point point = LinkLabel.this.toDisplay(new Point(rectangle.x, rectangle.y));
                accessiblecontrolevent.x = point.x;
                accessiblecontrolevent.y = point.y;
                accessiblecontrolevent.width = rectangle.width;
                accessiblecontrolevent.height = rectangle.height;
            }

            public void getChildCount(AccessibleControlEvent accessiblecontrolevent) {
                accessiblecontrolevent.detail = 0;
            }

            public void getRole(AccessibleControlEvent accessiblecontrolevent) {
                accessiblecontrolevent.detail = 43;
            }

            public void getState(AccessibleControlEvent accessiblecontrolevent) {
                accessiblecontrolevent.detail = 0;
            }
        });
    }
}

