/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tool.multipageeditor.common;

import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Item;

abstract class TableViewerImpl
implements TraverseListener {
    private boolean fIsActivating = false;
    private boolean fSingleClickCellSelect = false;
    private CellEditor fCellEditor;
    private CellEditor[] fCellEditors;
    private ICellModifier fCellModifier;
    private String[] fColumnProperties;
    private Item fTableItem;
    private int fColumnNumber;
    private ICellEditorListener fCellEditorListener;

    TableViewerImpl() {
        this.initCellEditorListener();
    }

    private void activateCellEditor() {
        String s;
        Object obj;
        if (this.fCellEditors != null && this.fCellEditors[this.fColumnNumber] != null && this.fCellModifier != null && this.fCellModifier.canModify(obj = this.fTableItem.getData(), s = this.fColumnProperties[this.fColumnNumber])) {
            this.fCellEditor = this.fCellEditors[this.fColumnNumber];
            this.fCellEditor.addListener(this.fCellEditorListener);
            Object obj1 = this.fCellModifier.getValue(obj, s);
            this.fCellEditor.setValue(obj1);
            Control control = this.fCellEditor.getControl();
            this.fCellEditor.activate();
            if (control != null) {
                this.setLayoutData(this.fCellEditor.getLayoutData());
                this.setEditor(control, this.fTableItem, this.fColumnNumber);
                this.fCellEditor.setFocus();
            }
        }
    }

    private void activateCellEditor(MouseEvent mouseevent) {
        if (this.fTableItem == null || this.fTableItem.isDisposed()) {
            return;
        }
        int i = this.getColumnCount();
        int j = -1;
        Rectangle rectangle = null;
        for (int k = 0; k < i; ++k) {
            rectangle = this.getBounds(this.fTableItem, k);
            if (!rectangle.contains(mouseevent.x, mouseevent.y)) continue;
            j = k;
            break;
        }
        if (j == -1 || rectangle == null) {
            return;
        }
        this.fColumnNumber = j;
        this.activateCellEditor();
    }

    public void activateFirstCellEditor() {
        if (this.fCellEditors != null) {
            int i = -1;
            for (int j = 0; j < this.fCellEditors.length; ++j) {
                if (this.fCellEditors[j] == null) continue;
                i = j;
                break;
            }
            if (i > -1 && this.fCellModifier != null) {
                this.fColumnNumber = i;
                this.activateCellEditor();
            }
        }
    }

    public void applyEditorValue() {
        CellEditor celleditor = this.fCellEditor;
        if (celleditor != null) {
            this.fCellEditor = null;
            Item item = this.fTableItem;
            if (item != null && !item.isDisposed()) {
                this.saveEditorValue(celleditor, item);
            }
            this.setEditor(null, null, 0);
            celleditor.removeListener(this.fCellEditorListener);
            celleditor.deactivate();
        }
    }

    public void cancelEditing() {
        if (this.fCellEditor != null) {
            this.setEditor(null, null, 0);
            this.fCellEditor.removeListener(this.fCellEditorListener);
            this.fCellEditor.deactivate();
            this.fCellEditor = null;
        }
    }

    public void editElement(Object obj, int i) {
        if (this.fCellEditor != null) {
            this.applyEditorValue();
        }
        this.setSelection(new StructuredSelection(obj), true);
        Item[] aitem = this.getSelection();
        if (aitem.length != 1) {
            return;
        }
        this.fTableItem = aitem[0];
        this.showSelection();
        this.fColumnNumber = i;
        this.activateCellEditor();
    }

    abstract Rectangle getBounds(Item var1, int var2);

    public CellEditor[] getCellEditors() {
        return this.fCellEditors;
    }

    public ICellModifier getCellModifier() {
        return this.fCellModifier;
    }

    abstract int getColumnCount();

    public Object[] getColumnProperties() {
        return this.fColumnProperties;
    }

    abstract Item[] getSelection();

    public void handleMouseDoubleClick(MouseEvent mouseevent) {
    }

    public void handleMouseDown(MouseEvent mouseevent) {
        Item[] aitem;
        if (mouseevent.button != 1) {
            return;
        }
        boolean flag = this.isCellEditorActive();
        if (flag) {
            this.applyEditorValue();
        }
        if ((aitem = this.getSelection()).length != 1) {
            this.fTableItem = null;
            return;
        }
        if (this.fTableItem != aitem[0]) {
            this.fTableItem = aitem[0];
            if (!this.fSingleClickCellSelect) {
                return;
            }
        }
        if (this.fIsActivating || flag) {
            return;
        }
        this.fIsActivating = true;
        this.postActivation(mouseevent);
    }

    private void handleRightArrow(TraverseEvent traverseevent) {
    }

    private void handleDownArrow(TraverseEvent traverseevent) {
    }

    private void handleLeftArrow(TraverseEvent traverseevent) {
    }

    private void handleUpArrow(TraverseEvent traverseevent) {
    }

    private void handleTabNext(TraverseEvent traverseevent) {
        if (this.fCellEditors != null && this.fCellModifier != null && this.fCellEditors.length > this.fColumnNumber + 1) {
            int i = this.fColumnNumber + 1;
            Object obj = null;
            Object obj1 = null;
            Object obj2 = this.fTableItem.getData();
            for (int j = i; j < this.fCellEditors.length; ++j) {
                String s;
                if (this.fCellEditors[j] == null || !this.fCellModifier.canModify(obj2, s = this.fColumnProperties[j])) continue;
                this.fColumnNumber = j;
                traverseevent.doit = false;
                break;
            }
            if (!traverseevent.doit) {
                this.startActivationThread();
            }
        }
    }

    private void handleTabPrevious(TraverseEvent traverseevent) {
        if (this.fCellEditors != null && this.fCellModifier != null) {
            int i = this.fCellEditors.length < this.fColumnNumber - 1 ? this.fCellEditors.length - 1 : this.fColumnNumber - 1;
            Object obj = null;
            Object obj1 = null;
            Object obj2 = this.fTableItem.getData();
            for (int j = i; j >= 0; --j) {
                String s;
                if (this.fCellEditors[j] == null || !this.fCellModifier.canModify(obj2, s = this.fColumnProperties[j])) continue;
                this.fColumnNumber = j;
                traverseevent.doit = false;
                break;
            }
            if (!traverseevent.doit) {
                this.startActivationThread();
            }
        }
    }

    private void initCellEditorListener() {
        this.fCellEditorListener = new ICellEditorListener(){

            public void editorValueChanged(boolean flag, boolean flag1) {
            }

            public void cancelEditor() {
                TableViewerImpl.this.cancelEditing();
            }

            public void applyEditorValue() {
                TableViewerImpl.this.applyEditorValue();
            }
        };
    }

    public boolean isCellEditorActive() {
        return this.fCellEditor != null;
    }

    public void keyTraversed(TraverseEvent traverseevent) {
        if (traverseevent.detail == 16) {
            this.applyEditorValue();
            this.handleTabNext(traverseevent);
        } else if (traverseevent.detail == 8) {
            this.applyEditorValue();
            this.handleTabPrevious(traverseevent);
        } else if (traverseevent.keyCode == 0x1000004) {
            this.handleRightArrow(traverseevent);
        } else if (traverseevent.keyCode == 0x1000003) {
            this.handleLeftArrow(traverseevent);
        } else if (traverseevent.keyCode == 0x1000001) {
            this.handleUpArrow(traverseevent);
        } else if (traverseevent.keyCode == 0x1000002) {
            this.handleDownArrow(traverseevent);
        }
    }

    private void postActivation(final MouseEvent event) {
        if (!this.fIsActivating) {
            return;
        }
        new Thread(){

            @Override
            public void run() {
                if (TableViewerImpl.this.fIsActivating) {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            TableViewerImpl.this.activateCellEditor(event);
                            TableViewerImpl.this.fIsActivating = false;
                        }
                    });
                }
            }
        }.start();
    }

    private void saveEditorValue(CellEditor celleditor, Item item) {
        if (this.fCellModifier != null && celleditor.isValueValid() && this.fColumnProperties != null && this.fColumnNumber < this.fColumnProperties.length) {
            String s = this.fColumnProperties[this.fColumnNumber];
            this.fCellModifier.modify((Object)item, s, celleditor.getValue());
        }
    }

    public void setCellEditors(CellEditor[] acelleditor) {
        this.fCellEditors = acelleditor;
        for (int i = 0; i < acelleditor.length; ++i) {
            Control control;
            if (acelleditor[i] == null || (control = acelleditor[i].getControl()) == null) continue;
            control.addTraverseListener((TraverseListener)this);
        }
    }

    public void setCellModifier(ICellModifier icellmodifier) {
        this.fCellModifier = icellmodifier;
    }

    public void setColumnProperties(String[] as) {
        this.fColumnProperties = as;
    }

    abstract void setEditor(Control var1, Item var2, int var3);

    abstract void setLayoutData(CellEditor.LayoutData var1);

    abstract void setSelection(StructuredSelection var1, boolean var2);

    abstract void showSelection();

    public boolean getSingleClickCellSelect() {
        return this.fSingleClickCellSelect;
    }

    public void setSingleClickCellSelect(boolean flag) {
        this.fSingleClickCellSelect = flag;
    }

    public void setTableItem(Item item) {
        this.fTableItem = item;
    }

    private void startActivationThread() {
        new Thread(){

            @Override
            public void run() {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        TableViewerImpl.this.activateCellEditor();
                        TableViewerImpl.this.fIsActivating = false;
                    }
                });
            }
        }.start();
    }
}

